﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.TourSample.Client.B01.ViewData;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.TourSample.Client.Common.ViewData;
using Terasoluna.DataCopy;
using Terasoluna.Windows.Forms.Controls;

namespace Terasoluna.TourSample.Client.B01.View
{   
    /// <summary>
    /// ユーザ登録画面(2/3)パネル
    /// </summary>
    public partial class SC_B01_03_02Control : UserControl, ISC_B01_03_01MainContent, IContentControl
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        private SC_B01_03_02ViewData _viewData;

        public SC_B01_03_02ViewData ViewData
        {
            get
            {
                if (_viewData == null)
                {
                    _viewData = CreateViewData();
                }
                return _viewData;
            }
        }

        protected virtual SC_B01_03_02ViewData CreateViewData()
        {
            return ValidatableViewDataManager.CreateViewData<SC_B01_03_02ViewData>();
        }

        public SC_B01_03_02Control()
        {
            InitializeComponent();
        }

        #region ISC_B01_03_01MainContent メンバ

        object ISC_B01_03_01MainContent.ViewData
        {
            get { return this.ViewData; }
        }

        public User LoginUser
        {
            get { return this.ViewData.LoginUser; }
        }

        public string Title
        {
            get { return "ユーザ登録(2/3)"; }
        }

        public string ExecuteButtonCaption
        {
            get { return "次へ"; }
        }

        public bool ExecutionEnabled
        {
            get { return true; }
        }

        public bool BackEnabled
        {
            get { return true; }
        }

        public bool HelpEnabled
        {
            get { return true; }
        }

        public string HelpUrl
        {
            get
            {
                return "sample.chm";
            }
        }

        public void Execute()
        {
            EventProcessResult result = b01_03_02_C01EventProcessWorker.RunWorker();
            if (result.IsSuccess)
            {
                ContentPlaceHolder.ShowAndHideContent(typeof(SC_B01_03_03Control));
            }
        }

        public void Back()
        {
            ContentPlaceHolder.ShowAndHideContent(typeof(SC_B01_03_01Control));
        }

        #endregion

        #region IContentControl メンバ

        [DefaultValue(null)]
        public ContentPlaceHolder ContentPlaceHolder { get; set; }

        public void HandleShowing(object sender, ControlEventArgs e)
        {
            ///遷移元遷移先パネル間で画面データをコピーして引き継ぐ例
            ISC_B01_03_01MainContent lastContentControl =
                ContentPlaceHolder.LastContentControl as ISC_B01_03_01MainContent;
            ISC_B01_03_01MainContent currentContentControl =
                ContentPlaceHolder.CurrentContentControl as ISC_B01_03_01MainContent;
            DataCopyManager.Copy(lastContentControl.LoginUser, currentContentControl.LoginUser);         
 
        }

        public void HandleHidden(object sender, ControlEventArgs e)
        {
        }

        #endregion

        private void SC_B01_03_02Control_Load(object sender, EventArgs e)
        {
            sC_B01_03_01ViewDataBindingSource.DataSource = ViewData;
        }
    }
}
