﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.TourSample.Client.B01.ViewData;
using Terasoluna.Windows.Forms.MessageNotification;

using Terasoluna.DataCopy;
using Terasoluna.TourSample.Client.Common.UserManageServiceReference;
using Terasoluna.TourSample.Client.Common.Code;

namespace Terasoluna.TourSample.Client.B01.View
{
    /// <summary>
    /// ユーザ登録画面（3/3)
    /// </summary>
    [ScreenId("SC_B01_02_03")]
    public partial class SC_B01_02_03View : TourSampleViewBase
    {
        public SC_B01_02_03ViewData ViewData { get; set; }

        public SC_B01_02_03View()
        {
            InitializeComponent();
            ViewData = ValidatableViewDataManager.CreateViewData<SC_B01_02_03ViewData>();
        }

        private void SC_B01_02_03View_Load(object sender, EventArgs e)
        {
            sC_B01_02_03ViewDataBindingSource.DataSource = ViewData;
        }

        private void backButton_Click(object sender, EventArgs e)
        {
            //非表示にして遷移元画面へ戻る
            Hide();
        }

        /// <summary>
        /// 登録ボタン押下時
        /// </summary>
        private void registButton_Click(object sender, EventArgs e)
        {
            b01_02_03_C01EventProcessWorker.RunWorkerAsync();
        }

        /// <summary>
        /// 登録ボタン押下時のイベント処理完了時
        /// </summary>
        private void b01_02_03_C01EventProcessWorker_Completed(object sender, Terasoluna.Windows.Forms.Events.EventProcCompletedEventArgs e)
        {
            if (e.Result.IsSuccess)
            {
                MessageNotifier.ShowInformationMessage(Terasoluna.TourSample.Client.Common.Properties.Resources.INFO_COMMON_0001);
                //スコープ上の画面を全てクローズ
                FormForwardGroupUtility.CloseAll(this);
                //全てCloseして開始画面を再作成（new & Show）して戻る場合
                //FormForwardGroupUtility.BackToStartFormWithClose(this); 
            }
            else if (e.Result.IsAnyBizLogicError || e.Result.IsAnyValidationError)
            {
                //業務エラー時には、スコープ上の画面開始画面へ戻る
                //全てHideして開始画面を再表示（Show）して戻る
                FormForwardGroupUtility.BackToStartFormWithHide(this); 
            }
        }

        private void b01_02_03_C01EventProcessWorker_BuiltRequest(object sender, Terasoluna.Windows.Forms.Events.RequestDataBuiltEventArgs e)
        {
            ///階層ずれのデータのコピー処理
            SC_B01_02_03ViewData viewData = e.ViewData as SC_B01_02_03ViewData;
            UserDto dest = e.RequestData as UserDto;
            DataCopyManager.Copy(viewData.User, dest);
        }

        private void addressLabel1_VisibleChanged(object sender, EventArgs e)
        {
            if (Visible)
            {
                //再描画ごとに表示を更新
                roleLabel1.Text =
                    string.Equals(ViewData.User.Role, Terasoluna.TourSample.Client.Common.Code.RoleEnum.User.ToString(), StringComparison.Ordinal)
                        ? "一般ユーザ" : "管理者";
            }
        }
    }
}
