﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using Microsoft.Practices.Unity;
using Terasoluna.TourSample.Client.Common.TourMtomServiceReference;
using System.ServiceModel;
using Terasoluna.ServiceModel;
using Terasoluna.TourSample.Client.Common.IO;
using Terasoluna.TourSample.Client.Common.Dto;

namespace Terasoluna.TourSample.Client.A01.BizLogic
{
    /// <summary>
    /// Mtomストリーミング転送モードでファイルアップロードするビジネスロジック
    /// </summary>
    public class A01_03_01_C01BizLogic
    {
        /// <summary>
        /// エンドポイント名
        /// </summary>
        private const string EndpointName = "TourMtomServicePort_Stream";

        /// <summary>
        /// WCF接続先変更機能を利用するため設定
        /// インスタンス管理コンテナを取得・設定する。
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        /// <summary>
        /// ファイルアップロードする
        /// </summary>
        public void Upload(FileInfoDto inputDto)
        {
            ///エンドポイントアドレスの取得
            ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
            EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
            TourMtomServiceClient client = new TourMtomServiceClient(EndpointName, address);
            //通常のStream
            //using (FileStream fs = new FileStream(inputDto.FilePath, FileMode.Open))
            ///ファイル送信率を通知するStream
            using (NotifyProgressInfoFileStream fs = 
                new NotifyProgressInfoFileStream(new FileStream(inputDto.FilePath, FileMode.Open)))
            {
                try
                {
                    client.UploadTourListFileWithStream(fs);
                    client.Close();
                }
                catch (System.Exception)
                {
                    if (client != null)
                    {
                        client.Abort();
                    }
                    throw;
                }
            }

        }

    }
}
