﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.TourSample.Client.Common.TourServiceReference;
using Terasoluna.Logging;
using Microsoft.Practices.Unity;
using System.ServiceModel;
using Terasoluna.ServiceModel;
using Terasoluna.DataCopy;


namespace Terasoluna.TourSample.Client.A01.BizLogic
{
    /// <summary>
    /// ツアー情報を検索するビジネスロジック
    /// 
    /// サーバ通信だけでなく
    /// クライアントビジネスロジックを伴うケース
    /// </summary>
    public class A01_02_01_C01BizLogic
    {
        /// デフォルトログの取得
        private ILogger logger = LogManager.GetLogger();
        
        /// <summary>
        /// エンドポイント名
        /// </summary>
        private const string EndpointName = "TourServicePort";

        /// <summary>
        /// WCF接続先変更機能を利用するため設定
        /// インスタンス管理コンテナを取得・設定する。
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        public TourSummaryListDto Execute(TourSearchKeyDto inputDto)
        {
            //クライアントで実施するビジネスロジック処理
            BeforeCommunicate(inputDto);
            TourSummaryListDto outputDto = null;

            //サーバ処理要求
            TourServiceClient client = null;
            try
            {
                ///エンドポイントアドレスの取得
                ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
                EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
                client = new TourServiceClient(EndpointName, address);
                outputDto = client.FindTour(inputDto);
                client.Close();
            }
            catch (System.Exception)
            {
                client.Abort();
                throw;
            }  

            //クライアントで実施するビジネスロジック処理
            AfterCommunicate(outputDto);
            return outputDto;
            
        }
        
        ///ダミーのクライアントビジネスロジック処理
        private void BeforeCommunicate(TourSearchKeyDto inputDto)
        {           
            ///ログの出力例
            if (logger.IsDebugEnabled)
            {
                logger.Debug(inputDto.TourName);
            }
        }

        ///ダミーのクライアントビジネスロジック処理
        private void AfterCommunicate(TourSummaryListDto tourList)
        {
            ///ログの出力例
            if (logger.IsDebugEnabled)
            {
                if (tourList != null)
                {
                    logger.Debug(tourList.TourList.Length + "件データ取得");
                }
            }

        }

    }

}
