package jp.terasoluna.toursample.server.interfaces.ws.mtom;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * ファイルデータを扱うDTO
 * WCFクライアント側でMTOMによる通信でbyte[]で扱う
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FileObjectDto")
public class FileObjectDto {
    @XmlElement(name = "FileName")
    private String fileName;
    @XmlElement(name = "FileData")
    private byte[] fileData;

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getFileData() {
        return fileData;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

}
