package jp.terasoluna.toursample.server.interfaces.usermanage.ws;

import javax.jws.WebMethod;
import javax.jws.WebService;

import jp.terasoluna.toursample.server.application.usermanage.UserManageBizLogic;
import jp.terasoluna.toursample.server.interfaces.usermanage.assembler.UserAssembler;
import jp.terasoluna.toursample.server.interfaces.usermanage.dto.UserDto;
import jp.terasoluna.toursample.server.interfaces.validation.SampleValidator;
import jp.terasoluna.toursample.server.interfaces.ws.exception.SampleSoapFaultException;
import jp.terasoluna.toursample.server.interfaces.ws.exception.handler.SampleSoapFaultExceptionHandler;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

/**
 *
 * 通常のWebサービスのサンプル SpringBeanAutowiringSupportを継承し作成する
 *
 */
@WebService(serviceName = "UserManageService")
public class UserManageService extends SpringBeanAutowiringSupport {
    @Autowired
    private UserManageBizLogic bizLogic;
    @Autowired
    private SampleSoapFaultExceptionHandler exceptionHandler;
    @Autowired
    @Qualifier("addUserValidator")
    private SampleValidator addUserValidator;
    @Autowired
    @Qualifier("loginValidator")
    private SampleValidator loginValidator;

    private UserAssembler assembler = new UserAssembler();

    /**
     * ユーザ登録する
     * @param dto
     * @throws SampleSoapFaultException
     */
    @WebMethod(operationName = "AddUser")
    public void addUser(UserDto dto) throws SampleSoapFaultException {
        try {
            // 入力チェック処理の実行
            addUserValidator.validate(dto);
            // ビジネスロジックの実行
            bizLogic.addUser(assembler.fromDto(dto));
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
    }

    /**
     * ログインする
     * @param dto
     * @return
     * @throws SampleSoapFaultException
     */
    @WebMethod(operationName = "Login")
    public UserDto login(UserDto dto) throws SampleSoapFaultException {
        try {
            // 入力チェック処理の実行
            loginValidator.validate(dto);
            // ビジネスロジックの実行
            return assembler.toSummaryDto(bizLogic
                    .login(assembler.fromDto(dto)));
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
        return null;
    }

}
