package jp.terasoluna.toursample.server.interfaces.usermanage.dto;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import jp.terasoluna.toursample.server.interfaces.usermanage.code.RoleEnum;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "UserDto")
public class UserDto {

    @XmlElement(name = "Id")
    private String id;
    @XmlElement(name = "Password")
    private String password;
    @XmlElement(name = "Name")
    private String name;
    @XmlElement(name = "Role")
    private RoleEnum role;
    @XmlElement(name = "UserDetail")
    private UserDetailDto userDetail;
    @XmlElement(name = "Version")
    private int version = 0;

    public UserDto() {
    }

    public UserDto(String id, String name, RoleEnum role) {
        this.id = id;
        this.name = name;
        this.role = role;
    }

    public UserDto(String id, String password, String name, RoleEnum role, UserDetailDto userDetail, int version)
    {
        this.id = id;
        this.password = password;
        this.name = name;
        this.role = role;
        this.userDetail = userDetail;
        this.version = version;
    }


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RoleEnum getRole() {
        return role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public UserDetailDto getUserDetail() {
        return userDetail;
    }

    public void setUserDetail(UserDetailDto userDetail) {
        this.userDetail = userDetail;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }


}
