package jp.terasoluna.toursample.server.infrastructure.persistence;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.toursample.server.domain.model.User;
import jp.terasoluna.toursample.server.domain.model.UserRepository;

import org.springframework.beans.factory.annotation.Autowired;

public class UserRepositoryTerasolunaDAO implements UserRepository {
    // MockDAOになっているので、
    // DB接続したい場合は、h2dbフォルダ内にあるH2DBを動作させること
    // また、環境設定手順の詳細はプロジェクト直下のreadme_h2db.txtを参照のこと
    @Autowired
    private QueryDAO queryDAO;
    @Autowired
    private UpdateDAO updateDAO;

    @Override
    public User findByIdAndPass(User user) {
        return queryDAO.executeForObject("usermanage.selectUserByIdAndPass", user, User.class);
    }

    @Override
    public void store(User user) {
         updateDAO.execute("usermanage.insertUser", user);
    }

}
