package jp.terasoluna.toursample.server.infrastructure.persistence;

import java.util.List;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.toursample.server.domain.model.Conductor;
import jp.terasoluna.toursample.server.domain.model.DeptPlace;
import jp.terasoluna.toursample.server.domain.model.Tour;
import jp.terasoluna.toursample.server.domain.model.TourCategory;
import jp.terasoluna.toursample.server.domain.model.TourRepository;

import org.springframework.beans.factory.annotation.Autowired;

public class TourRepositoryTerasolunaDAO implements TourRepository {

    // MockDAOになっているので、
    // DB接続したい場合は、h2dbフォルダ内にあるH2DBを動作させること
    // また、環境設定手順の詳細はプロジェクト直下のreadme_h2db.txtを参照のこと
    @Autowired
    private QueryDAO queryDAO;
    @Autowired
    private UpdateDAO updateDAO;

    public void store(Tour tour) {
        // ツアーの登録
        updateDAO.execute("tour.insertTour", tour);
        String tourCode = tour.getTourCode();
        if (tour.getConductorList() != null) {
            // 担当者の登録
            for (Conductor conductor : tour.getConductorList()) {
                // ツアーコードの設定
                conductor.setTourCode(tourCode);
                updateDAO.execute("tour.insertConductor", conductor);
            }
        }
        if (tour.getDeptPlaceList() != null) {
            for (DeptPlace deptPlace : tour.getDeptPlaceList()) {
                deptPlace.setTourCode(tourCode);
                updateDAO.execute("tour.insertTourDept", deptPlace);
            }
        }
        if (tour.getTourCategoryList() != null) {
            for (TourCategory category : tour.getTourCategoryList()) {
                category.setTourCode(tourCode);
                updateDAO.execute("tour.insertTourCategory", category);
            }
        }
    }

    public Tour find(String tourCode) {
        return queryDAO.executeForObject("tour.selectTour", tourCode,
                Tour.class);
    };

    public List<Tour> findByTourName(String tourName) {
        List<Tour> tourList = queryDAO.executeForObjectList(
                "tour.selectTourByTourName", tourName);

        return tourList;
    }


    @Override
    public List<TourCategory> findAllCategories() {
        return queryDAO.executeForObjectList("tour.selectTourCategories", null);
    }

    @Override
    public List<DeptPlace> findAllDeptPlaces() {
        return queryDAO.executeForObjectList("tour.selectDeptPlaces", null);
    }
}
