package jp.terasoluna.toursample.server.domain.model;

import java.util.Date;
import java.util.List;

import jp.terasoluna.toursample.server.domain.code.TourTypeEnum;
import jp.terasoluna.toursample.server.domain.code.TransportationEnum;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ツアークラス
 *
 */
public class Tour {
    private String tourCode;
    private String name;
    private TourTypeEnum tourType;
    private TransportationEnum transportation;
    private List<TourCategory> tourCategoryList;
    private List<DeptPlace> deptPlaceList;
    private String destName;
    private Date deptDate;
    private Integer tourDay;
    private List<Conductor> conductorList;
    private boolean hasOptionalTour;
    private HotelRank hotelRank;
    private int version = 0;
    public Tour() {
    }

    public Tour(String tourCode, String name, TourTypeEnum tourType,
             TransportationEnum transportation,
             List<TourCategory> tourCategoryList,
             List<DeptPlace> deptPlacelist,
             String destName, Date deptDate, Integer tourDay,
            List<Conductor> conductorList,
            boolean hasOptionalTour,
            HotelRank hotelRank,
            int version) {
        this.tourCode = tourCode;
        this.name = name;
        this.tourType = tourType;
        this.transportation = transportation;
        this.tourCategoryList = tourCategoryList;
        this.deptPlaceList = deptPlacelist;
        this.destName = destName;
        this.deptDate = deptDate;
        this.tourDay = tourDay;
        this.conductorList = conductorList;
        this.hasOptionalTour = hasOptionalTour;
        this.hotelRank = hotelRank;
        this.version = version;
    }

    public String getTourCode() {
        return tourCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TourTypeEnum getTourType() {
        return tourType;
    }

    public void setTourType(TourTypeEnum tourType) {
        this.tourType = tourType;
    }

    public TransportationEnum getTransportation() {
        return transportation;
    }

    public void setTransportation(TransportationEnum transportation) {
        this.transportation = transportation;
    }

    public List<TourCategory> getTourCategoryList() {
        return tourCategoryList;
    }

    public void setTourCategoryList(List<TourCategory> tourCategoryList) {
        this.tourCategoryList = tourCategoryList;
    }

    public List<DeptPlace> getDeptPlaceList() {
        return deptPlaceList;
    }

    public void setDeptPlaceList(List<DeptPlace> deptPlaceList) {
        this.deptPlaceList = deptPlaceList;
    }

    public String getDestName() {
        return destName;
    }

    public void setDestName(String destName) {
        this.destName = destName;
    }

    public Date getDeptDate() {
        return deptDate;
    }

    public void setDeptDate(Date deptDate) {
        this.deptDate = deptDate;
    }

    public Integer getTourDay() {
        return tourDay;
    }

    public void setTourDay(Integer tourDay) {
        this.tourDay = tourDay;
    }

    public List<Conductor> getConductorList() {
        return conductorList;
    }

    public void setConductorList(List<Conductor> conductorList) {
        this.conductorList = conductorList;
    }

    public boolean isHasOptionalTour() {
        return hasOptionalTour;
    }

    public void setHasOptionalTour(boolean hasOptionalTour) {
        this.hasOptionalTour = hasOptionalTour;
    }

    public HotelRank getHotelRank() {
        return hotelRank;
    }

    public void setHotelRank(HotelRank hotelRank) {
        this.hotelRank = hotelRank;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setTourCode(String tourCode) {
        this.tourCode = tourCode;
    }

    /**
     * ダミーのドメインロジック
     *
     * @return
     */
    public void doSomething() {
        System.out.println("Tourのビジネスロジック実行");
        if (conductorList == null) {
            return;
        }
        for (Conductor conductor : conductorList) {
            conductor.doSomething();
        }
    }

    public String toString() {
        return new ToStringBuilder(this).append("tourCode", tourCode).append(
                "name", name).append("tourType", tourType).append(
                "transportation", transportation).append("tourCategoryList",
                tourCategoryList).append("deptPlaceList", deptPlaceList)
                .append("destName", destName).append("deptDate", deptDate)
                .append("tourDay", tourDay).append("conductorList",
                        conductorList).append("hasOptionalTour",
                        hasOptionalTour).append("hotelRank", hotelRank).append(
                        "version", version).toString();
    }

}
