package jp.terasoluna.toursample.server.application.tour;

import java.util.List;

import javax.activation.DataHandler;

import jp.terasoluna.toursample.server.application.exception.ApplicationException;
import jp.terasoluna.toursample.server.domain.model.DeptPlace;
import jp.terasoluna.toursample.server.domain.model.Tour;
import jp.terasoluna.toursample.server.domain.model.TourCategory;

/**
 * ツアー情報管理業務のアプリケーションロジック
 */
public interface TourBizLogic {
    void addTour(Tour tour) throws ApplicationException;

    /**
     * ツアー名でツアーを検索する
     * @param tourName
     * @return
     * @throws ApplicationException
     */
    List<Tour> findTourByName(String tourName)
            throws ApplicationException;

    /**
     * ツアー登録ジョブを追加する
     * @param dataHandler
     */
    void addRegistTourJob(DataHandler dataHandler);

    /**
     * ツアー登録ジョブを追加する
     * @param fileName
     * @param fileData
     */
    void addRegistTourJob(String fileName, byte[] fileData);

    /**
     * 出発地リストを取得する
     * @return
     * @throws ApplicationException
     */
    List<DeptPlace> findAllDeptPlaces() throws ApplicationException;

    /**
     * ツアー分類リストを取得する
     * @return
     * @throws ApplicationException
     */
    List<TourCategory> findAllTourCategories() throws ApplicationException;

}
