﻿// Copyright (c) 2011, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.Practices.Unity;
using Terasoluna.BizLogic;

namespace Terasoluna.Windows.Forms.BizLogic
{
    public class WcfProxyBizLogicExtensionRev : ClientBizLogicExtension
    {      
        /// <summary>
        /// <para>Unity の拡張機能の初期化処理を行います。</para>
        /// </summary>
        /// <remarks>
        /// <para><see cref="Microsoft.Practices.Unity.InterceptionExtension.Interception"/> の SetInterceptor を属性情報から実行する拡張機能を登録します。</para>
        /// </remarks>
        protected override void Initialize()
        {
            base.Initialize();

            Container.RegisterType<BizLogicManager>(
                new ContainerControlledLifetimeManager());

            Container.RegisterType<IBizLogicExecutor, WcfProxyBizLogicExecutorRev>(
                WcfProxyBizLogicExecutorRev.InstanceName,
                new ContainerControlledLifetimeManager());
            Container.RegisterType<IBizLogicInfoManager, WcfProxyBizLogicInfoManager>(
                WcfProxyBizLogicExecutorRev.InstanceName,
                new ContainerControlledLifetimeManager());
        }
    }
}
