/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.StringTokenizer;

public final class BlockList {
    public static final String ALL = "#all";
    public static final String EXTENSION = "extension";
    public static final String RESTRICTION = "restriction";
    public static final String SUBSTITUTION = "substitution";
    private boolean _all = false;
    private boolean _extension = false;
    private boolean _restriction = false;
    private boolean _substitution = false;

    public BlockList() {
    }

    public BlockList(String listOfValues) {
        if (listOfValues != null) {
            this.parseValues(listOfValues);
        }
    }

    public boolean hasAll() {
        return this._all;
    }

    public boolean hasExtension() {
        return this._extension;
    }

    public boolean hasRestriction() {
        return this._restriction;
    }

    public boolean hasSubstitution() {
        return this._substitution;
    }

    public String toString() {
        if (this._all) {
            return ALL;
        }
        StringBuffer value = new StringBuffer();
        if (this._extension) {
            value.append(EXTENSION);
        }
        if (this._restriction) {
            if (value.length() > 0) {
                value.append(' ');
            }
            value.append(RESTRICTION);
        }
        if (this._substitution) {
            if (value.length() > 0) {
                value.append(' ');
            }
            value.append(RESTRICTION);
        }
        return value.toString();
    }

    private void parseValues(String values) {
        if (ALL.equals(values)) {
            this._all = true;
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(values);
        while (tokenizer.hasMoreTokens()) {
            String value = tokenizer.nextToken();
            if (EXTENSION.equals(value)) {
                this._extension = true;
                continue;
            }
            if (RESTRICTION.equals(value)) {
                this._restriction = true;
                continue;
            }
            if (SUBSTITUTION.equals(value)) {
                this._substitution = true;
                continue;
            }
            String err = "invalid block list: " + values;
            throw new IllegalArgumentException(err);
        }
    }
}

