/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

public class DbcpConfiguration {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private static final String ADD_DRIVER_PROPS_PREFIX = "Driver.";
    private static final int ADD_DRIVER_PROPS_PREFIX_LENGTH = "Driver.".length();
    private DataSource dataSource;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;

    public DbcpConfiguration(Map properties) {
        try {
            this.dataSource = this.legacyDbcpConfiguration(properties);
            if (this.dataSource == null) {
                this.dataSource = this.newDbcpConfiguration(properties);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing DbcpDataSourceFactory.  Cause: " + e, e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private BasicDataSource newDbcpConfiguration(Map map) {
        BasicDataSource basicDataSource = new BasicDataSource();
        Iterator props = map.keySet().iterator();
        while (props.hasNext()) {
            String value;
            String propertyName = (String)props.next();
            if (propertyName.startsWith(ADD_DRIVER_PROPS_PREFIX)) {
                value = (String)map.get(propertyName);
                basicDataSource.addConnectionProperty(propertyName.substring(ADD_DRIVER_PROPS_PREFIX_LENGTH), value);
                continue;
            }
            if (!PROBE.hasWritableProperty(basicDataSource, propertyName)) continue;
            value = (String)map.get(propertyName);
            Object convertedValue = this.convertValue(basicDataSource, propertyName, value);
            PROBE.setObject(basicDataSource, propertyName, convertedValue);
        }
        return basicDataSource;
    }

    private Object convertValue(Object object, String propertyName, String value) {
        Object convertedValue = value;
        Class targetType = PROBE.getPropertyTypeForSetter(object, propertyName);
        if (targetType == (class$java$lang$Integer == null ? (class$java$lang$Integer = DbcpConfiguration.class$("java.lang.Integer")) : class$java$lang$Integer) || targetType == Integer.TYPE) {
            convertedValue = Integer.valueOf(value);
        } else if (targetType == (class$java$lang$Long == null ? (class$java$lang$Long = DbcpConfiguration.class$("java.lang.Long")) : class$java$lang$Long) || targetType == Long.TYPE) {
            convertedValue = Long.valueOf(value);
        } else if (targetType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = DbcpConfiguration.class$("java.lang.Boolean")) : class$java$lang$Boolean) || targetType == Boolean.TYPE) {
            convertedValue = Boolean.valueOf(value);
        }
        return convertedValue;
    }

    private BasicDataSource legacyDbcpConfiguration(Map map) {
        BasicDataSource basicDataSource = null;
        if (map.containsKey("JDBC.Driver")) {
            basicDataSource = new BasicDataSource();
            String driver = (String)map.get("JDBC.Driver");
            String url = (String)map.get("JDBC.ConnectionURL");
            String username = (String)map.get("JDBC.Username");
            String password = (String)map.get("JDBC.Password");
            String validationQuery = (String)map.get("Pool.ValidationQuery");
            String maxActive = (String)map.get("Pool.MaximumActiveConnections");
            String maxIdle = (String)map.get("Pool.MaximumIdleConnections");
            String maxWait = (String)map.get("Pool.MaximumWait");
            basicDataSource.setUrl(url);
            basicDataSource.setDriverClassName(driver);
            basicDataSource.setUsername(username);
            basicDataSource.setPassword(password);
            if (this.notEmpty(validationQuery)) {
                basicDataSource.setValidationQuery(validationQuery);
            }
            if (this.notEmpty(maxActive)) {
                basicDataSource.setMaxActive(Integer.parseInt(maxActive));
            }
            if (this.notEmpty(maxIdle)) {
                basicDataSource.setMaxIdle(Integer.parseInt(maxIdle));
            }
            if (this.notEmpty(maxWait)) {
                basicDataSource.setMaxWait((long)Integer.parseInt(maxWait));
            }
            Iterator props = map.keySet().iterator();
            while (props.hasNext()) {
                String propertyName = (String)props.next();
                if (!propertyName.startsWith(ADD_DRIVER_PROPS_PREFIX)) continue;
                String value = (String)map.get(propertyName);
                basicDataSource.addConnectionProperty(propertyName.substring(ADD_DRIVER_PROPS_PREFIX_LENGTH), value);
            }
        }
        return basicDataSource;
    }

    private boolean notEmpty(String s) {
        return s != null && s.length() > 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

