/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.actions;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.service.thin.AbstractBLogicMapper;
import jp.terasoluna.fw.service.thin.BLogicIO;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResources;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.ModuleUtil;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.fw.web.struts.actions.ActionEx;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBLogicAction<P>
extends ActionEx {
    private static Log log = LogFactory.getLog(AbstractBLogicAction.class);
    protected static final String BLOGIC_FORM_ILLEGAL_ERROR = "errors.blogic.form";
    protected static final String BLOGIC_MAPPING_ILLEGAL_ERROR = "errors.blogic.mapping";
    protected static final String BLOGIC_RESOURCES_ILLEGAL_ERROR = "errors.blogic.resources";
    protected static final String BLOGIC_RESULT_NULL_ERROR = "errors.blogic.result.null";
    protected static final String NULL_MAPPER_KEY = "errors.blogic.mapper.null";
    private String saveMessageScope = null;

    public void setSaveMessageScope(String saveMessageScope) {
        this.saveMessageScope = saveMessageScope;
    }

    @Override
    public ActionForward doExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("*** doExecute() called. action path=[" + mapping.getPath() + "] ***"));
        }
        ActionMappingEx mappingEx = null;
        try {
            mappingEx = (ActionMappingEx)mapping;
        }
        catch (ClassCastException e) {
            log.error((Object)"Illegal ActionMapping.");
            throw new SystemException(e, BLOGIC_MAPPING_ILLEGAL_ERROR);
        }
        P params = this.getBLogicParams(mappingEx, request, response);
        if (log.isDebugEnabled()) {
            log.debug((Object)"*** BLogicParams is prepared. ***");
            if (params != null) {
                log.debug((Object)("BLogicParams:" + params.toString()));
            } else {
                log.debug((Object)"BLogicParams:null");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("*** starting blogic action[" + ((Object)((Object)this)).getClass().getName() + "] ***"));
        }
        BLogicResult result = null;
        this.preDoExecuteBLogic(request, response, params);
        result = this.doExecuteBLogic(params);
        this.postDoExecuteBLogic(request, response, params, result);
        if (log.isDebugEnabled()) {
            log.debug((Object)("*** finished blogic action[" + ((Object)((Object)this)).getClass().getName() + "] ***"));
        }
        if (result != null) {
            this.evaluateBLogicResult(result, request, response, mappingEx);
            return mapping.findForward(result.getResultString());
        }
        log.error((Object)"BLogicResult is null.");
        throw new SystemException(new NullPointerException(), BLOGIC_RESULT_NULL_ERROR);
    }

    protected void preDoExecuteBLogic(HttpServletRequest request, HttpServletResponse response, P params) throws Exception {
    }

    protected void postDoExecuteBLogic(HttpServletRequest request, HttpServletResponse response, P params, BLogicResult result) throws Exception {
    }

    protected void evaluateBLogicResult(BLogicResult result, HttpServletRequest request, HttpServletResponse response, ActionMappingEx mappingEx) {
        if (result == null) {
            log.error((Object)"BLogicResult is null.");
            throw new SystemException(new NullPointerException(), BLOGIC_RESULT_NULL_ERROR);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"*** BLogicResult is prepared. ***");
            log.debug((Object)("BLogicResult:" + result.toString()));
        }
        ActionMessages errors = this.convertMessages(result.getErrors());
        ActionMessages messages = this.convertMessages(result.getMessages());
        if ("session".equalsIgnoreCase(this.saveMessageScope)) {
            HttpSession session = request.getSession(true);
            this.addErrors(session, errors);
            this.addMessages(session, messages);
        } else {
            this.addErrors(request, errors);
            this.addMessages(request, messages);
        }
        if (this.isErrorsEmpty(result)) {
            this.processBLogicResult(result, request, response, mappingEx);
        }
    }

    protected void processBLogicResult(BLogicResult result, HttpServletRequest request, HttpServletResponse response, ActionMappingEx mappingEx) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"*** setting result into web layer. ***");
        }
        this.getBLogicMapper(request).mapBLogicResult(request, response, this.getBLogicIO(mappingEx, request), result);
    }

    protected ActionMessages convertMessages(BLogicMessages blogicMessages) {
        if (blogicMessages == null) {
            return null;
        }
        ActionMessages messages = new ActionMessages();
        Iterator<BLogicMessage> itr = blogicMessages.get();
        Iterator<String> groupItr = blogicMessages.getGroup();
        while (itr.hasNext()) {
            BLogicMessage blogicMessage = itr.next();
            ActionMessage actionMessage = null;
            actionMessage = blogicMessage.isResource() ? new ActionMessage(blogicMessage.getKey(), blogicMessage.getValues()) : new ActionMessage(blogicMessage.getKey(), blogicMessage.isResource());
            String group = groupItr.next();
            messages.add(group, actionMessage);
        }
        return messages;
    }

    public abstract BLogicResult doExecuteBLogic(P var1) throws Exception;

    protected boolean isErrorsEmpty(BLogicResult result) {
        if (result == null) {
            log.error((Object)"BLogicResult is null.");
            throw new SystemException(new NullPointerException(), BLOGIC_RESULT_NULL_ERROR);
        }
        BLogicMessages errors = result.getErrors();
        if (errors == null) {
            return true;
        }
        return errors.isEmpty();
    }

    protected AbstractBLogicMapper getBLogicMapper(HttpServletRequest req) {
        String moduleName = ModuleUtil.getPrefix(req);
        AbstractBLogicMapper mapper = null;
        try {
            mapper = (AbstractBLogicMapper)this.servlet.getServletContext().getAttribute("BLOGIC_MAPPER" + moduleName);
        }
        catch (ClassCastException e) {
            log.error((Object)("Cannot cast BLogicMapper : " + e.getMessage()));
            throw new SystemException(e, BLOGIC_MAPPING_ILLEGAL_ERROR);
        }
        if (mapper == null) {
            log.error((Object)"BLogicMapper is null.");
            throw new SystemException(new NullPointerException(), NULL_MAPPER_KEY);
        }
        return mapper;
    }

    protected P getBLogicParams(ActionMappingEx mapping, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BLogicIO io = this.getBLogicIO(mapping, request);
        Object bean = this.getBLogicMapper(request).mapBLogicParams(request, response, io);
        return (P)bean;
    }

    protected BLogicIO getBLogicIO(ActionMapping mapping, HttpServletRequest request) {
        String moduleName = ModuleUtil.getPrefix(request);
        BLogicResources resource = null;
        try {
            resource = (BLogicResources)this.servlet.getServletContext().getAttribute("BLOGIC_RESOURCES" + moduleName);
        }
        catch (ClassCastException e) {
            log.error((Object)("Cannot cast BLogicResources : " + e.getMessage()));
            throw new SystemException(e, BLOGIC_RESOURCES_ILLEGAL_ERROR);
        }
        if (resource != null) {
            return resource.getBLogicIO(mapping.getPath());
        }
        return null;
    }
}

