/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.transaction.service;

import jp.terasoluna.thin.functionsample.transaction.bean.AddressVO;
import jp.terasoluna.fw.dao.QueryDAO;

/**
 * Z擾T[rX̎NX
 *
 * @version 2006/03/06
 */
public class SelectAddressServiceImpl implements SelectAddressService {

    /**
     * Z擾pDAO 
     */
    private QueryDAO queryDAO = null;

    /**
     * f[^x[XZ擾
     * 
     * @param customerCode ڋqR[h
     * @return Z
     */
    public AddressVO getListAddress(String customerCode) {
        // Z^̃Xg擾B
        return queryDAO.executeForObject("transaction.selectAddressInfo",
                customerCode, AddressVO.class);
    }

    /**
     * Z擾pDAO擾B
     * @return Z擾pDAO
     */
    public QueryDAO getQueryDAO() {
        return queryDAO;
    }

    /**
     * Z擾pDAOݒ肷B
     * @param queryDAO Z擾pDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }
}
