/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import junit.framework.TestCase;
import junitx.framework.FileAssert;


/**
 * AT[g֘Ã[eBeBNXB
 * 
 */
class AssertUtil {

    public static void assertEqualsTimestamp(Object expected, Object actual) {

        // p[^String^łȂΗOԂB
        if ((expected != null) && (!(expected instanceof String))) {
            String msg = "ҒlString^ł͂܂B";
            throw new IllegalArgumentException(msg);
        }
        if ((actual != null) && (!(actual instanceof String))) {
            String msg = "ۂ̒lString^ł͂܂B";
            throw new IllegalArgumentException(msg);
        }

        
        // String^ɃLXgB
        String expectedString = (String) expected;
        String actualString = (String) actual;


        // Ғl̃tH[}bgɍ킹assertEqualsB        
        if (expectedString == null) {

            // Ғlnull̏ꍇ
            TestCase.assertEquals(expectedString, actualString);

        } else if (TimestampUtil.isDateString(expectedString)) {
            
            // tȑꍇ
            String actualDateString = TimestampUtil.getDateString(actualString);
            TestCase.assertEquals(expectedString, actualDateString);
            
        } else if (TimestampUtil.isTimeString(expectedString)) {

            // ȑꍇ
            String actualTimeString = TimestampUtil.getTimeString(actualString);
            TestCase.assertEquals(expectedString, actualTimeString);
            
        } else if (TimestampUtil.isDateTimeString(expectedString)) {

            // t{ȑꍇ
            String actualDateTimeString = 
                TimestampUtil.getDateTimeString(actualString);
            TestCase.assertEquals(expectedString, actualDateTimeString);

        } else if (TimestampUtil.isDateTimeNanosString(expectedString)) {

            // t{{imbȑꍇ
            TestCase.assertEquals(expectedString, actualString);

        } else {
            
            // OFzOtH[}bg̏ꍇ
            String msg = "Ғl(" + expectedString
                       + ")zǑ`ŗ^܂I";
            throw new IllegalArgumentException(msg);

        }
    }

    /**
     * ݓtƔr邽߂assert[eBeB\bhB
     * 
     * @param actual ۂ̒l
     */
    public static void assertEqualsToday(Object actual) {

        // ݓt̕擾B
        Date d = new Date();
        String currentDate = new SimpleDateFormat("yyyy-MM-dd").format(d);        

        // t̕assertEqualsB
        assertEqualsTimestamp(currentDate, actual);
    }

    /**
     * t@C̒goCirB
     * 
     * @param expected Ғl̃t@C
     * @param actual ۂ̒l̃t@C
     */
    public static void assertEqualsFile(File expected, File actual) {
        FileAssert.assertBinaryEquals(expected, actual);
    }

    /**
     * XgrB
     * 
     * @param expected Ғl̃Xg
     * @param actual ۂ̒l̃Xg
     */
    public static void assertEqualsList(Object expected,Object actual) {

        // p[^List^łȂΗOԂB
        if ((expected != null) && (!(expected instanceof List))) {
            String msg = "ҒlList^ł͂܂B";
            throw new IllegalArgumentException(msg);
        }
        if ((actual != null) && (!(actual instanceof List))) {
            String msg = "ۂ̒lList^ł͂܂B";
            throw new IllegalArgumentException(msg);
        }
        
        List expectedList = (List)expected;
        List actualList = (List)actual;

        if(expectedList == null){
            TestCase.assertNull(actualList );
        }else if(actualList == null){
            TestCase.assertNull(expectedList );
        }else{
            //NXǂr
            TestCase.assertEquals(expectedList.getClass().getName(),
                    actualList.getClass().getName());
            
            //Xg̃TCYr
            TestCase.assertEquals(expectedList.size(),actualList.size());
            
            //Xgvf̔r
            for(int i = 0;i < expectedList.size();i++ ){
                Object expectedElement = expectedList.get(i);
                Object actualElement = actualList.get(i);
                if(expectedElement instanceof List){
                    AssertUtil.assertEqualsList(expectedElement,actualElement);
                }else if(expectedElement instanceof Map){
                    AssertUtil.assertEqualsMap(expectedElement,actualElement);
                }else{
                    TestCase.assertEquals(expectedElement,actualElement);
                }
            }
        }
    }

    /**
     * }bvrB
     * 
     * @param expected Ғl̃}bv
     * @param actual ۂ̒l̃}bv
     */
    public static void assertEqualsMap(Object expected,Object actual) {

        // p[^Map^łȂΗOԂB
        if ((expected != null) && (!(expected instanceof Map))) {
            String msg = "ҒlMap^ł͂܂B";
            throw new IllegalArgumentException(msg);
        }
        if ((actual != null) && (!(actual instanceof Map))) {
            String msg = "ۂ̒lMap^ł͂܂B";
            throw new IllegalArgumentException(msg);
        }
        
        Map expectedMap = (Map)expected;
        Map actualMap = (Map)actual;

        if(expectedMap == null){
            TestCase.assertNull(actualMap );
        }else if(actualMap == null){
            TestCase.assertNull(expectedMap );
        }else{
            //NXǂr
            TestCase.assertEquals(expectedMap.getClass().getName(),
                    actualMap.getClass().getName());
            
            //}bṽTCYr
            TestCase.assertEquals(expectedMap.entrySet().size(),
                    actualMap.entrySet().size());
            
            //}bvvf̔r
            Set expectedSet = expectedMap.entrySet();
            
            for(Iterator it = expectedSet.iterator();it.hasNext(); ){
                Map.Entry  expectedEntry = (Map.Entry )it.next(); 
                Object expectedElement = expectedEntry.getValue();
                Object actualElement = actualMap.get(expectedEntry.getKey());
                if(expectedElement instanceof Map ){
                    AssertUtil.assertEqualsMap(expectedElement, actualElement);
                }else if(expectedElement instanceof List){
                    AssertUtil.assertEqualsList(expectedElement, actualElement);
                }else{
                    TestCase.assertEquals(expectedElement,actualElement);
                }
            }
        }
    }
    
}
