/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.terasoluna.fw.file.dao.standard.ColumnFormatter;
import jp.terasoluna.fw.file.dao.standard.DecimalFormatLocal;

public class DecimalColumnFormatter
implements ColumnFormatter {
    private Map<String, DecimalFormatLocal> dfMap = new ConcurrentHashMap<String, DecimalFormatLocal>();

    public String format(Object t, Method method, String columnFormat) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object column = method.invoke(t, new Object[0]);
        if (column == null) {
            return "";
        }
        if (columnFormat != null && !"".equals(columnFormat)) {
            DecimalFormatLocal dfLocal = this.dfMap.get(columnFormat);
            if (dfLocal == null) {
                dfLocal = new DecimalFormatLocal(columnFormat);
                this.dfMap.put(columnFormat, dfLocal);
            }
            return ((DecimalFormat)dfLocal.get()).format(column);
        }
        return ((BigDecimal)BigDecimal.class.cast(column)).toPlainString();
    }
}

