/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.fw.validation.ValidationUtil;

/**
 * {@link jp.terasoluna.fw.validation.ValidationUtil} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ؃WbÑ[eBeBNXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.ValidationUtil
 */
public class ValidationUtilTest05 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ValidationUtilTest05.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ValidationUtilTest05(String name) {
        super(name);
    }

    /**
     * testIsByteInRange01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsByteInRange01() throws Exception {
        // O
        String value = null;
        String encoding = null;
        int min = 0;
        int max = 0;

        // eXg{
        boolean result = ValidationUtil.isByteInRange(
                value, encoding, min, max);

        // 
        assertTrue(result);
    }

    /**
     * testIsByteInRange02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󔒂̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsByteInRange02() throws Exception {
        // O
        String value = "";
        String encoding = null;
        int min = 0;
        int max = 0;

        // eXg{
        boolean result = ValidationUtil.isByteInRange(
                value, encoding, min, max);

        // 
        assertTrue(result);
    }

    /**
     * testIsByteInRange03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         () encoding:null<br>
     *         () min:0<br>
     *         () max:10<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueNotNullAencodingnullŁAɒƂAw͈͓̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsByteInRange03() throws Exception {
        // O
        String value = "abc";
        String encoding = null;
        int min = 0;
        int max = 10;

        // eXg{
        boolean result = ValidationUtil.isByteInRange(
                value, encoding, min, max);

        // 
        assertTrue(result);
    }

    /**
     * testIsByteInRange04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         () encoding:""<br>
     *         () min:5<br>
     *         () max:10<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueNotNullAencoding󔒂ŁAɒƂAw͈͊Ȍꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsByteInRange04() throws Exception {
        // O
        String value = "abc";
        String encoding = "";
        int min = 5;
        int max = 10;

        // eXg{
        boolean result = ValidationUtil.isByteInRange(
                value, encoding, min, max);

        // 
        assertFalse(result);
    }

    /**
     * testIsByteInRange05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         () encoding:"UTF-8"<br>
     *         () min:3<br>
     *         () max:3<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueNotNullAencodingNotNullŁAɒƂAw͈͓̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsByteInRange05() throws Exception {
        // O
        String value = "abc";
        String encoding = "UTF-8";
        int min = 3;
        int max = 3;

        // eXg{
        boolean result = ValidationUtil.isByteInRange(
                value, encoding, min, max);

        // 
        assertTrue(result);
    }

    /**
     * testIsByteInRange06()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         () encoding:"aaa"<br>
     *
     * <br>
     * ҒlF(ԕω) O:OFIllegalArgumentException<br>
     *
     * <br>
     * valueNotNullAencodingsȕ̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsByteInRange06() throws Exception {
        // O
        String value = "abc";
        String encoding = "aaa";
        int min = 5;
        int max = 10;

        // eXg{
        try {
            ValidationUtil.isByteInRange(
                    value, encoding, min, max);
            fail("OȂB");
        } catch (IllegalArgumentException e) {
            // 
            //OOKB
            assertNotNull(e);
        }
    }

    /**
     * testIsDateInRange01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange01() throws Exception {
        // O
        String value = null;
        String startDateStr = null;
        String endDateStr = null;
        String datePattern = null;
        String datePatternStrict = null;

        // eXg{
        boolean result = ValidationUtil.isDateInRange(value, startDateStr,
                endDateStr,datePattern, datePatternStrict);

        // 
        assertTrue(result);
    }

    /**
     * testIsDateInRange02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󔒂̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange02() throws Exception {
        // O
        String value = "";
        String startDateStr = null;
        String endDateStr = null;
        String datePattern = null;
        String datePatternStrict = null;

        // eXg{
        boolean result = ValidationUtil.isDateInRange(value, startDateStr,
                endDateStr,datePattern, datePatternStrict);

        // 
        assertTrue(result);
    }

    /**
     * testIsDateInRange03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () datePattern:null<br>
     *         () datePatternStrict:"yyyy/MM/dd"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueɓtɕϊłȂꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange03() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = null;
        String endDateStr = null;
        String datePattern = null;
        String datePatternStrict = "yyyy/MM/dd";

        // eXg{
        boolean result = ValidationUtil.isDateInRange(value, startDateStr,
                endDateStr,datePattern, datePatternStrict);

        // 
        assertFalse(result);
    }

    /**
     * testIsDateInRange04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"2005/11/01"<br>
     *         () startDateStr:null<br>
     *         () endDateStr:null<br>
     *         () datePattern:null<br>
     *         () datePatternStrict:"yyyy/MM/dd"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * startDateStrAendDateStrnull̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange04() throws Exception {
        // O
        String value = "2005/11/01";
        String startDateStr = null;
        String endDateStr = null;
        String datePattern = null;
        String datePatternStrict = "yyyy/MM/dd";

        // eXg{
        boolean result = ValidationUtil.isDateInRange(value, startDateStr,
                endDateStr,datePattern, datePatternStrict);

        // 
        assertTrue(result);
    }

    /**
     * testIsDateInRange05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () startDateStr:""<br>
     *         () endDateStr:""<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *         () datePatternStrict:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * startDateStrAendDateStr󔒂̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange05() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = "";
        String endDateStr = "";
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        boolean result = ValidationUtil.isDateInRange(value, startDateStr,
                endDateStr,datePattern, datePatternStrict);

        // 
        assertTrue(result);
    }

    /**
     * testIsDateInRange06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"2005/11/01"<br>
     *         () startDateStr:"2005/12/1"<br>
     *         () endDateStr:null<br>
     *         () datePattern:null<br>
     *         () datePatternStrict:"yyyy/MM/dd"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:-<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"startDate is unparseable[2005/12/1]"<br>
     *
     * <br>
     * startDateStrNotNullAtɕϊłȂꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange06() throws Exception {
        // O
        String value = "2005/11/01";
        String startDateStr = "2005/12/1";
        String endDateStr = null;
        String datePattern = null;
        String datePatternStrict = "yyyy/MM/dd";

        // eXg{
        try {
            ValidationUtil.isDateInRange(value, startDateStr,
                    endDateStr,datePattern, datePatternStrict);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("startDate is unparseable[2005/12/1]", e.getMessage());
        }
    }

    /**
     * testIsDateInRange07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () startDateStr:"2005/12/1"<br>
     *         () endDateStr:null<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *         () datePatternStrict:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * startDateStrɓtɕϊłAvaluestartDateStrȑOꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange07() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = "2005/12/1";
        String endDateStr = null;
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        boolean result = ValidationUtil.isDateInRange(value, startDateStr,
                endDateStr,datePattern, datePatternStrict);

        // 
        assertFalse(result);
    }

    /**
     * testIsDateInRange08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"2005/11/01"<br>
     *         () startDateStr:null<br>
     *         () endDateStr:"2005/10/1"<br>
     *         () datePattern:null<br>
     *         () datePatternStrict:"yyyy/MM/dd"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:-<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"endDate is unparseable[2005/10/1]"<br>
     *
     * <br>
     * endDateStrNotNullAtɕϊłȂꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange08() throws Exception {
        // O
        String value = "2005/11/01";
        String startDateStr = null;
        String endDateStr = "2005/10/1";
        String datePattern = null;
        String datePatternStrict = "yyyy/MM/dd";

        // eXg{
        try {
            ValidationUtil.isDateInRange(value, startDateStr,
                    endDateStr,datePattern, datePatternStrict);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("endDate is unparseable[2005/10/1]", e.getMessage());
        }
    }

    /**
     * testIsDateInRange09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () startDateStr:null<br>
     *         () endDateStr:"2005/10/1"<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *         () datePatternStrict:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * endDateStrɓtɕϊłAvalueendDateStrȌゾꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange09() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = null;
        String endDateStr = "2005/10/1";
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        boolean result = ValidationUtil.isDateInRange(value, startDateStr,
                endDateStr,datePattern, datePatternStrict);

        // 
        assertFalse(result);
    }

    /**
     * testIsDateInRange10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () startDateStr:"2005/10/1"<br>
     *         () endDateStr:"2005/12/1"<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *         () datePatternStrict:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueAstartDateStrAendDateStrׂĐɓtɕϊłAvaluestartDateStrendDateStr̊Ԃ̓t̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange10() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = "2005/10/1";
        String endDateStr = "2005/12/1";
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        boolean result = ValidationUtil.isDateInRange(value, startDateStr,
                endDateStr,datePattern, datePatternStrict);

        // 
        assertTrue(result);
    }

    /**
     * testIsDateInRange11()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () datePattern:null<br>
     *         () datePatternStrict:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"datePattern or datePatternStrict must be specified."<br>
     *
     * <br>
     * datePatternAdatePatternStrictnull̏ꍇAIllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange11() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = "2005/10/1";
        String endDateStr = "2005/12/1";
        String datePattern = null;
        String datePatternStrict = null;

        // eXg{
        try {
            ValidationUtil.isDateInRange(value, startDateStr,
                    endDateStr,datePattern, datePatternStrict);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("datePattern or datePatternStrict must be specified.",
                    e.getMessage());
        }
    }

    /**
     * testIsDateInRange12()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () datePattern:""<br>
     *         () datePatternStrict:""<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"datePattern or datePatternStrict must be specified."<br>
     *
     * <br>
     * datePatternAdatePatternStrict󕶎̏ꍇAIllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange12() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = "2005/10/1";
        String endDateStr = "2005/12/1";
        String datePattern = "";
        String datePatternStrict = "";

        // eXg{
        try {
            ValidationUtil.isDateInRange(value, startDateStr,
                    endDateStr,datePattern, datePatternStrict);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("datePattern or datePatternStrict must be specified.",
                    e.getMessage());
        }
    }

    /**
     * testIsDateInRange13()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () datePattern:"abc"<br>
     *         () datePatternStrict:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF<br>
     *                    "Illegal pattern character 'b'"<br>
     *
     * <br>
     * datePatternsȏꍇAIllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange13() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = "2005/10/1";
        String endDateStr = "2005/12/1";
        String datePattern = "abc";
        String datePatternStrict = null;

        // eXg{
        try {
            ValidationUtil.isDateInRange(value, startDateStr,
                    endDateStr,datePattern, datePatternStrict);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("Illegal pattern character 'b'",
                    e.getMessage());
        }
    }

    /**
     * testIsDateInRange14()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () datePattern:null<br>
     *         () datePatternStrict:"abc"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF<br>
     *                    "Illegal pattern character 'b'"<br>
     *
     * <br>
     * datePatternStrictsȏꍇAIllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange14() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = "2005/10/1";
        String endDateStr = "2005/12/1";
        String datePattern = null;
        String datePatternStrict = "abc";

        // eXg{
        try {
            ValidationUtil.isDateInRange(value, startDateStr,
                    endDateStr,datePattern, datePatternStrict);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("Illegal pattern character 'b'",
                    e.getMessage());
        }
    }

    /**
     * testIsDateInRange15()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () startDateStr:"test"<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *         () datePatternStrict:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"startDate is unparseable[test]"<br>
     *
     * <br>
     * startDateStrtɕϊłȂꍇAIllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange15() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = "test";
        String endDateStr = null;
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        try {
            ValidationUtil.isDateInRange(value, startDateStr,
                    endDateStr,datePattern, datePatternStrict);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("startDate is unparseable[test]",
                    e.getMessage());
        }
    }

    /**
     * testIsDateInRange16()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () endDateStr:"test"<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *         () datePatternStrict:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"endDate is unparseable[test]"<br>
     *
     * <br>
     * endDateStrtɕϊłȂꍇAIllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange16() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = null;
        String endDateStr = "test";
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        try {
            ValidationUtil.isDateInRange(value, startDateStr,
                    endDateStr,datePattern, datePatternStrict);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("endDate is unparseable[test]",
                    e.getMessage());
        }
    }

    /**
     * testIsDateInRange17()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() value:"2005/11/1"<br>
     *         () startDateStr:"2005/11/1"<br>
     *         () endDateStr:"2005/11/1"<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *         () datePatternStrict:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * ͒lstartDateStrAendDateStr̓tꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange17() throws Exception {
        // O
        String value = "2005/11/1";
        String startDateStr = "2005/11/1";
        String endDateStr = "2005/11/1";
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        boolean result = ValidationUtil.isDateInRange(value, startDateStr,
                    endDateStr,datePattern, datePatternStrict);

        // 
        assertTrue(result);
    }

    /**
     * testIsDateInRange18()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"test"<br>
     *         () startDateStr:"2005/1/1"<br>
     *         () endDateStr:"2005/12/31"<br>
     *         () datePattern:"yyyy/MM/dd"<br>
     *         () datePatternStrict:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * ͒ltɕϊłȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsDateInRange18() throws Exception {
        // O
        String value = "test";
        String startDateStr = "2005/11/1";
        String endDateStr = "2005/12/31";
        String datePattern = "yyyy/MM/dd";
        String datePatternStrict = null;

        // eXg{
        boolean result = ValidationUtil.isDateInRange(value, startDateStr,
                    endDateStr,datePattern, datePatternStrict);

        // 
        assertFalse(result);
    }

}
