/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.tutorial.uc0001.jb0002;

import java.util.Date;

import jp.terasoluna.batch.tutorial.uc0001.JB0002JobContext;

import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.batch.openapi.SupportLogic;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.FileUpdateDAO;

/**
 * Wu㏈NXB
 */
public class FileJobPostLogic implements SupportLogic<JB0002JobContext> {

    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private FileUpdateDAO updateDAO = null;
  
    /**
     * t@C̖OB
     * SpringɂCX^Xݒ肳B
     */
    private String outputFileName = null;
    
    /**
     * Wu㏈sB
     * @param jobContext WuReLXg
     * @return rWlXWbN
     */
    public BLogicResult execute(JB0002JobContext jobContext) {
    
        //t@Cɏo͂B
        Date unyohiduke = jobContext.getUnyohiduke();
        int count = jobContext.getCount();
        
        RirekiFileData rireki = new RirekiFileData();
        rireki.setSyoribi(unyohiduke);
        rireki.setSyorikensu(count);
            
        FileLineWriter<RirekiFileData> fileLineWriter
                = updateDAO.execute(outputFileName, RirekiFileData.class);
    
        try {
            fileLineWriter.printDataLine(rireki);
        } finally {
            fileLineWriter.closeFile();
        }
        
        //rWlXWbNʃIuWFNgԋpB
        return new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    }

    /**
     * FileUpdateDAOݒ肷B
     * @param updateDAO ݒ肷FileUpdateDAO
     */
    public void setUpdateDAO(FileUpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }
    
    /**
     * t@Cݒ肷
     * @param outputFileName t@C
     */
    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }
}
