// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.ComponentModel;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Common.Validation.Validators
{
    /// <summary>
    /// ^w͈̓`FbNs <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> 
    /// ̊NXłB̃NX͒ۃNXłB
    /// </summary>
    /// <typeparam name="T">͈̓`FbNs^B</typeparam>
    /// <remarks>
    /// <para>
    /// ؑΏۂ^p[^œnꂽ^łA܂͓nꂽ^ɕϊ\ string ̏ꍇA
    /// ͈̓`FbNs܂B null ܂͋󕶎̏ꍇA؏͍sꂸA،ʂ͕KƂȂ܂B
    /// </para>
    /// <para>
    /// {NX͔hNXɂċ@\܂BƎɔhNX쐬ꍇA
    /// ؑΏۂ̌^ <see cref="Microsoft.Practices.EnterpriseLibrary.Common.Configuration.ConfigurationElementTypeAttribute"/> Ɏw肵܂B
    /// ̍ہATuNX̃NXƂĎw肵ĂB
    /// ܂AؑΏۂƂ^^p[^Ƃēn悤ɂĂB̍ہA
    /// Ɏw肷^p[^Ɠ^w肷Kv܂B
    /// </para>
    /// </remarks>
    public abstract class TypeRangeValidator<T> : RangeValidator where T : IComparable
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(TypeRangeValidator<T>));

    @@/// <summary>
        /// ͈͂ɂŏl̈񋓒lłB
        /// </summary>
        private RangeBoundaryType _lowerBoundType;

        /// <summary>
        /// ͈͂ɂől̈񋓒lłB
        /// </summary>
        private RangeBoundaryType _upperBoundType;

        /// <summary>
        /// ͈͎w𔻒肷邽߂̒萔łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "Ignore_Inclusive" łB
        /// </remarks>
        protected const string IGNORE_INCLUSIVE = "Ignore_Inclusive";

        /// <summary>
        /// ͈͎w𔻒肷邽߂̒萔łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "Ignore_Exclusive" łB
        /// </remarks>
        protected const string IGNORE_EXCLUSIVE = "Ignore_Exclusive";

        /// <summary>
        /// ͈͎w𔻒肷邽߂̒萔łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "Inclusive_Ignore" łB
        /// </remarks>
        protected const string INCLUSIVE_IGNORE = "Inclusive_Ignore";

        /// <summary>
        /// ͈͎w𔻒肷邽߂̒萔łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "Inclusive_Inclusive" łB
        /// </remarks>
        protected const string INCLUSIVE_INCLUSIVE = "Inclusive_Inclusive";

        /// <summary>
        /// ͈͎w𔻒肷邽߂̒萔łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "Inclusive_Exclusive" łB
        /// </remarks>
        protected const string INCLUSIVE_EXCLUSIVE = "Inclusive_Exclusive";

        /// <summary>
        /// ͈͎w𔻒肷邽߂̒萔łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "Exclusive_Ignore" łB
        /// </remarks>
        protected const string EXCLUSIVE_IGNORE = "Exclusive_Ignore";

        /// <summary>
        /// ͈͎w𔻒肷邽߂̒萔łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "Exclusive_Inclusive" łB
        /// </remarks>
        protected const string EXCLUSIVE_INCLUSIVE = "Exclusive_Inclusive";

        /// <summary>
        /// ͈͎w𔻒肷邽߂̒萔łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "Exclusive_Exclusive" łB
        /// </remarks>
        protected const string EXCLUSIVE_EXCLUSIVE = "Exclusive_Exclusive";

        /// <summary>
        /// RXgN^BhNXĂяo܂B
        /// </summary>
        /// <param name="lowerBound">^p[^ŗ^ꂽ^̍ŏlB</param>
        /// <param name="lowerBoundType">͈͂ɂŏl̈ <see cref="RangeBoundaryType"/> 񋓂̒lB
        /// w肵ȂꍇA<seealso cref="RangeBoundaryType.Ignore"/>@gp܂B</param>
        /// <param name="upperBound">^p[^ŗ^ꂽ^̍őlB</param>
        /// <param name="upperBoundType">͈͂ɂől̈ <see cref="RangeBoundaryType"/> 񋓂̒lB
        /// w肵ȂꍇA<see cref="RangeBoundaryType.Inclusive"/> p܂B</param>
        /// <param name="messageTemplate">؎s̍ہAbZ[W𐶐邽߂ɗpev[gB
        /// ؂ɗpp[^v[Xz_ɓn܂B
        /// p[^Ƃ̃v[Xz_ԍ͈ȉ̒ʂłB
        /// <list type="table">
        /// <listheader>
        /// <term>v[Xz_</term>
        /// <description>e</description>
        /// </listheader>
        /// <item>
        /// <term>{0}</term>
        /// <description>ؑΏە</description>
        /// </item>
        /// <item>
        /// <term>{1}</term>
        /// <description>key(vpeBE\bh)</description>
        /// </item>
        /// <item>
        /// <term>{2}</term>
        /// <description>Tag</description>
        /// </item>
        /// <item>
        /// <term>{3}</term>
        /// <description>LowerBound</description>
        /// </item>
        /// <item>
        /// <term>{4}</term>
        /// <description>LowerBoundType</description>
        /// </item>
        /// <item>
        /// <term>{5}</term>
        /// <description>UpperBound</description>
        /// </item>
        /// <item>
        /// <term>{6}</term>
        /// <description>UpperBoundType</description>
        /// </item>
        /// </list>
        /// </param>
        /// <param name="negated">؏̔]tOB
        /// ]Ō؂{ꍇɂ true w肵܂B</param>
        protected TypeRangeValidator(T lowerBound,
                                 RangeBoundaryType lowerBoundType,
                                 T upperBound,
                                 RangeBoundaryType upperBoundType,
                                 string messageTemplate,
                                 bool negated)
            : base(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated)
        {
            _lowerBoundType = lowerBoundType;
            _upperBoundType = upperBoundType;
        }

        /// <summary>
        /// l̃^Cv(l܂ށAl܂܂ȂA)擾܂B
        /// </summary>
        protected RangeBoundaryType LowerBoundType
        {
            get { return _lowerBoundType; }
        }

        /// <summary>
        /// l̃^Cv(l܂ށAl܂܂ȂA)擾܂B
        /// </summary>
        protected RangeBoundaryType UpperBoundType
        {
            get { return _upperBoundType; }
        }


        /// <summary>
        /// ^w͈̓`FbNs\bhłB^p[^ŗ^ꂽ^ŁA
        /// w肳ꂽ͈͂ɌؑΏےl܂܂邩`FbN܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <paramref name="objectToValidate"/>  null ܂͋󕶎̏ꍇA
        /// ؏͍sꂸA،ʂ͕KƂȂ܂B
        ///  negated  true ̏ꍇA؏]܂B
        /// </para>
        /// </remarks>
        /// <param name="objectToValidate">ؑΏۂ̒lB</param>
        /// <param name="currentTarget">ؑΏۂ̃IuWFNB</param>
        /// <param name="key">ؑΏۂ̃vpeB܂̓\bhB</param>
        /// <param name="validationResults">،ʂi[ <see cref="ValidationResults"/> B</param>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="validationResults"/>  null QƂłB
        /// </exception> 
        protected override void DoValidate(IComparable objectToValidate,
                                           object currentTarget,
                                           string key,
                                           ValidationResults validationResults)
        {
            if (validationResults == null)
            {
                ArgumentNullException exception = new ArgumentNullException("validationResults");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "validationResults"), exception);
                }
                throw exception;
            }

            if (objectToValidate == null || string.IsNullOrEmpty(objectToValidate.ToString()))
            {
                return;
            }

            bool isLogError = false;

            T targetObject = default(T);
            Type tp = objectToValidate.GetType();
            if (tp == typeof(T))
            {
                targetObject = (T)objectToValidate;
            }
            else if (tp == typeof(String))
            {
                string targetString = Normalize((string)objectToValidate);

                if (!TryConvertFromString(targetString, out targetObject))
                {
                    isLogError = true;
                }
            }
            else
            {
                isLogError = true;
            }


            if (!isLogError)
            {
                base.DoValidate(targetObject, currentTarget, key, validationResults);
            }
            else
            {
                LogValidationResult(validationResults,
                                    GetMessage(objectToValidate, key),
                                    currentTarget,
                                    key);
            }
        }

        /// <summary>
        /// 𐳋K郁\bhłBhNXŃI[o[Ch܂B
        /// g|CgƂėpӂĂAftHgł͓ɉ܂B
        /// ^ϊۂɁAO{ꍇÃ\bh𗘗p܂B
        /// ftHgł͂̃\bh null ܂͋󕶎ԋpꍇA؎sƂȂ܂B
        /// </summary>
        /// <param name="str">KΏۂ̕B</param>
        /// <returns>KꂽB</returns>
        protected virtual string Normalize(string str)
        {
            return str;
        }

        /// <summary>
        /// 񂩂猟ؑΏۂ̌^ɕϊ݂܂Bꍇɂ true ԂA <paramref name="output"/> ̒l
        /// ϊ̃IuWFNgɏ܂B
        /// </summary>
        /// <param name="str">ϊli[镶B</param>
        /// <param name="output">ϊꍇÃ\bhԂƂɁA
        /// <paramref name="str"/>Ɋi[ꂽϊ^p[^ŗ^ꂽ^̃IuWFNgB
        /// ϊɎsꍇ default li[܂B̃p[^͏ɓnƂł܂B</param>
        /// <returns><paramref name="str"/> ɕϊꂽꍇ true BȊȌꍇ false B</returns>
        protected virtual bool TryConvertFromString(string str, out T output)
        {
            bool result = false;
            output = default(T);
            TypeConverter typeConverter = null;
            typeConverter = TypeDescriptor.GetConverter(typeof(T));
            try
            {
                output = (T)typeConverter.ConvertFromString(str);
                result = true;
            }
            catch (Exception exception)
            {
                // ConvertFromStringSystem.ExceptionX[̂ExceptioncatchĂB
                // Ô͕ϊsȂ̂ŉȂ
                if(_log.IsWarnEnabled)
                {
                    _log.Warn(string.Format(
                        Properties.Resources.W_VALIDATOR_EXCEPTION, str, typeof(T).FullName), exception);
                }
            }
            return result;
        }
    }
}
