// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.IO;
using System.Reflection;
using Microsoft.Practices.EnterpriseLibrary.Common.Configuration;
using TERASOLUNA.Fw.Common.Logging;
using EntlibValidator = Microsoft.Practices.EnterpriseLibrary.Validation;
using TerasolunaValidator = TERASOLUNA.Fw.Common.Validation;

namespace TERASOLUNA.Fw.Common.Validation
{
    /// <summary>
    /// ͒lؐݒt@CŌ؃[w肵A<see cref="DataSet"/> ɑ΂͒l؂sNXłB
    /// <see cref="IValidator"/> Ă܂B Validation Application Block Œ񋟂 Validator @\𗘗pĂ܂B
    /// </summary>
    public class VabValidator : TerasolunaValidator.IValidator
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(VabValidator));

        /// <summary>
        /// G[@\͒l؃voC_@\ŗpXPatȟ`łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "{0}[{1}]/{2}" łB
        /// </remarks>
        public static readonly string XPATH_FORMAT = "{0}[{1}]/{2}";

        /// <summary>
        /// <see cref="DataSet"/> ɑ΂͒l؂{ہApŒ̃[ZbgłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "Default" łB
        /// </remarks>
        public static readonly string DEFAULT_RULESET_STRING = "Default";

        /// <summary>
        /// ͒lؐݒt@C̃t@CpXێ܂B
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private string _validationFilePath = null;

        /// <summary>
        /// ͒l؂{ۂɗp郋[Zbgێ܂B
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA "Default" łB
        /// </remarks>
        private string _ruleSet = DEFAULT_RULESET_STRING;


        /// <summary>
        /// ͒lؐݒt@C̃t@CpX擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// ͒lؐݒt@C̃t@CpXB
        /// </value>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        public string ValidationFilePath
        {
            get
            {
                return _validationFilePath;
            }
            set
            {
                _validationFilePath = value;
            }
        }

        /// <summary>
        /// ͒l؂pۂɗp郋[Zbg擾܂͐ݒ肵܂B
        /// </summary>
        /// <remarks>
        /// ftHg̒l <seealso cref="DEFAULT_RULESET_STRING"/> łB
        /// </remarks>
        /// <value>[ZbgB</value>
        public string RuleSet
        {
            get
            {
                return _ruleSet;
            }
            set
            {
                _ruleSet = value;
            }
        }

        /// <summary>
        /// V <see cref="VabValidator"/> ̃CX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public VabValidator() { }

        /// <summary><paramref name="dataSet"/> ɑ΂āA؃[ɊÂ͒l؂s܂</summary>
        /// <remarks>
        /// <para>
        /// <see cref="DataSet"/> Ŝ؂܂B؃[ <seealso cref="VabValidator.ValidationFilePath"/>
        /// Ŏw肳ꂽݒt@C擾܂B
        /// </para>
        /// <para>
        /// Validation Application Block ́AANZXɗOvpeBɑ΂Č؂łȂƂɒӂĉB
        /// f[^Zbg̃J̏l DBNull łAl null ɗOX[悤ɐݒ肵ĂꍇA
        /// ̃Jւ̃ANZX <see cref="StrongTypingException"/> X[܂B
        /// AJ̒l DBNull łꍇłOX[܂B
        /// vpeBւ̃ANZXOX[ꍇÃ\bh
        /// <see cref="TerasolunaException"/> X[܂B
        /// </para>
        /// <para>
        /// ͒lؐݒt@Cɂ́Ae <see cref="DataRow"/> ̌^pČ؃[`܂B
        /// ftHgŃ[Zbg"Default"ƂȂ܂BY郋[Zbg݂ȂꍇA؂͎s܂B
        /// ܂AؑΏۂ̃e[uɍs݂Ȃꍇ؂͎s܂B
        /// </para>
        /// <para>
        /// {\bh́A͒l؃G[ꍇ̂݁A؎sƂȂ܂B؂sȂꍇłĂA
        /// ؐƂȂ܂B
        /// </para>
        /// </remarks>
        /// <param name="dataSet">ؑΏۂƂȂf[^ZbgB</param>
        /// <returns>،ʂi[ <see cref="ValidationResult"/> B</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="dataSet"/>  null QƂłB
        /// </exception>
        /// <exception cref="InvalidOperationException">
        /// <list type="bullet">
        /// <item>
        /// <seealso cref="VabValidator.ValidationFilePath"/> włB
        /// </item>
        /// <item>
        /// <seealso cref="VabValidator.RuleSet"/> włB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <see cref="DataSet"/>  DBNull l؂邱Ƃ͂ł܂B
        /// </item>
        /// <item>
        /// <seealso cref="ValidationFilePath"/> ɐݒ肳ꂽlsłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="FileNotFoundException">
        /// <seealso cref="ValidationFilePath"/> ݂܂B
        /// </exception>
        public virtual TerasolunaValidator.ValidationResult Validate(DataSet dataSet)
        {
            // ̓`FbN
            if (dataSet == null)
            {
                ArgumentNullException exception = new ArgumentNullException("dataSet");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "dataSet"), exception);
                }
                throw exception;
            }

            string validationFilePath = _validationFilePath;
            if (string.IsNullOrEmpty(validationFilePath))
            {
                InvalidOperationException exception = new InvalidOperationException(Properties.Resources.E_VALIDATION_FILE_UNDEFINED);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            string ruleSet = _ruleSet;
            if (string.IsNullOrEmpty(ruleSet))
            {
                InvalidOperationException exception = new InvalidOperationException(Properties.Resources.E_VALIDATION_RULESET_UNDEFINED);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }


            TerasolunaValidator.ValidationResult result = null;
            try
            {
                // ͒lؐݒt@C̓ǂݍ
                IConfigurationSource source = LoadConfigurationSource(validationFilePath);

                // ͒l؂̎s
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_VALIDATE_DATA_SET,
                    dataSet.GetType().FullName, validationFilePath, ruleSet));
                }
                result = ValidateDataSet(dataSet, ruleSet, source);
            }
            catch (TargetInvocationException e)
            {
                if (e.InnerException is StrongTypingException)
                {
                    TerasolunaException exception = new TerasolunaException(Properties.Resources.E_STRONG_TYPING_EXCEPTION, e);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }
                else
                {
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(e.InnerException.Message, e.InnerException);
                    }
                    throw e.InnerException;
                }
            }

            return result;
        }

        /// <summary>ValidatorNX̃CX^X擾\bhłB</summary>
        /// <remarks>
        /// œnꂽ <paramref name="source"/>  <paramref name="targetType"/> A<paramref name="ruleSet"/>
        /// pāA<see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> ̃CX^X
        /// ܂B
        /// </remarks>
        /// <param name="targetType">ؑΏۂ̌^B</param>
        /// <param name="source">
        /// ݒ\ <see cref="IConfigurationSource"/> CX^XB
        /// </param>
        /// <param name="ruleSet">
        /// ؑΏۂ̃[ZbgB
        /// </param>
        /// <returns><see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> CX^XB</returns>
        /// <exception cref="TerasolunaException">
        /// ͒lؐݒ񂪕słB
        /// </exception>
        protected virtual EntlibValidator.Validator GetVabValidator(Type targetType,
                                                   string ruleSet,
                                                   IConfigurationSource source)
        {
            EntlibValidator.Validator validator = null;
            try
            {
                validator = EntlibValidator.ValidationFactory.CreateValidator(targetType, ruleSet, source);
            }
            catch (ArgumentException e)
            {
                TerasolunaException exception =
                    new TerasolunaException(Properties.Resources.E_VALIDATION_CONFIG_INFO_INVALID, e);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            catch (ConfigurationErrorsException e)
            {
                // ͒lؐݒ񂪕słB
                TerasolunaException exception =
                    new TerasolunaException(Properties.Resources.E_VALIDATION_CONFIG_INFO_INVALID, e);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(Properties.Resources.D_GENERATE_VALIDATOR,
                    targetType.FullName, ruleSet, _validationFilePath));
            }

            return validator;
        }

        /// <summary>ŗ^ꂽ <paramref name="dataSet"/> ̓͒l؂s܂B</summary>
        /// <remarks>
        /// <para>
        /// ŗ^ꂽ <paramref name="dataSet"/> ee[u̍sNX( <see cref="DataRow"/> )
        /// ΂Č؂s܂B
        /// </para>
        /// <para>
        /// ͒lؐݒt@Cɂ́Aes̎sNX̌^ɑΉ؃[
        /// LqKv܂B
        /// </para>
        /// <para>
        /// [ZbgƂāA<seealso cref="DEFAULT_RULESET_STRING"/> p܂B
        /// </para>
        /// </remarks>
        /// <param name="dataSet">ؑΏۂ <see cref="DataSet"/> Bnull łĂ͂Ȃ܂B</param>
        /// <param name="ruleSet">[ZbgB</param>
        /// <param name="configurationSource">͒lؐݒt@C̃f[^B</param>
        /// <returns>،ʂi[ <see cref="ValidationResult"/> B</returns>
        /// <exception cref="FormatException">
        /// format łB܂͏ݒΏۂ̈ 0 菬Aڂ̒ȏłB 
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ͒lؐݒ񂪕słB
        /// </exception>
        protected virtual TerasolunaValidator.ValidationResult ValidateDataSet(DataSet dataSet, string ruleSet,
                                                             IConfigurationSource configurationSource)
        {
            EntlibValidator.Validator entlibValidator = null;
            TerasolunaValidator.ValidationResult terasolunaResult = new TerasolunaValidator.ValidationResult();
            IList<MessageInfo> resultMessageList = terasolunaResult.Errors;
            EntlibValidator.ValidationResults rowResults = null;
            Type tp = null;

            // SĂDataTableDataRowɑ΂āA͒l؂s
            foreach (DataTable table in dataSet.Tables)
            {
                if (IsValidationTarget(table, configurationSource))
                {
                    tp = table.Rows[0].GetType();
                    entlibValidator = GetVabValidator(tp, ruleSet, configurationSource);
                    for (int i = 0; i < table.Rows.Count; i++)
                    {
                        // DataRowPʂœ͒l؂s
                        DataRow row = table.Rows[i];

                        if (row.RowState != DataRowState.Deleted)
                        {
                            rowResults = entlibValidator.Validate(row);

                            if (!rowResults.IsValid)
                            {
                                ReFillResultMessage(rowResults, table.TableName, i, resultMessageList);
                            }
                        }
                    }
                }
            }

            return terasolunaResult;
        }

        /// <summary>
        ///  <see cref="DataTable"/> ؑΏۂł邩`FbNB
        /// </summary>
        /// <param name="table">ؑΏۂ <see cref="DataTable"/> B</param>
        /// <param name="source">͒lؐݒt@C̃f[^łB</param>
        /// <returns>ؑΏۃf[^tOB</returns>
        protected virtual bool IsValidationTarget(DataTable table, IConfigurationSource source)
        {
            // ftHgł͏ς1sȏ̃f[^񂪂e[uؑΏۂƂ
            // ̖K(table.TableName.StartWith("View")==trueȂ)ŃtB^Ȃǂ
            // ꍇÃ\bhTuNXŃI[o[ChB
            return table.IsInitialized && (table.Rows.Count != 0);
        }

        /// <summary>
        /// ŗ^ꂽ <paramref name="results"/> ̌X̃ACeA <paramref name="list"/> ɑ΂
        /// bZ[Wlߑւ܂Bnꂽ <paramref name="xPath"/> ʃbZ[Wɐݒ肵܂B
        /// </summary>
        /// <param name="results"><see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> 
        /// ̎sʂi[񋓎qB</param>
        /// <param name="xPath">f[^Zbgɑ΂錟؎A؃G[̈ʒu XPath B</param>
        /// <param name="list">،ʂݒ肷邽߂ <see cref="MessageInfo"/> ̃XgB</param>
        protected virtual void ReFillResultMessage(IEnumerable<EntlibValidator.ValidationResult> results,
                                   string xPath,
                                   IList<MessageInfo> list)
        {
            if (results != null)
            {
                foreach (EntlibValidator.ValidationResult result in results)
                {
                    ValidationMessageInfo vMessageInfo =
                        new ValidationMessageInfo(result.Key, result.Message, xPath);
                    vMessageInfo.Detail = result;
                    list.Add(vMessageInfo);
                    ReFillResultMessage(result.NestedValidationResults, xPath, list);
                }
            }
        }

        /// <summary>
        /// ŗ^ꂽ <paramref name="results"/> ̌X̃ACeA<paramref name="list"/> ɑ΂
        /// bZ[Wlߑւ܂Bnꂽ <paramref name="table"/> A <paramref name="rowIndex"/> p
        ///  XPath 𐶐Aԋplɐݒ肵܂B
        /// </summary>
        /// <remarks>
        /// <seealso cref="ValidateDataSet"/> 痘p\bhłB
        /// </remarks>
        /// <param name="results"><see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/>
        /// ̎sʂi[񋓎qB</param>
        /// <param name="tableName">؂sꂽe[uB XPath ɗpB</param>
        /// <param name="rowIndex">؂sꂽĴsԍB XPath ɗpB</param>
        /// <param name="list">،ʂݒ肷邽߂ <see cref="MessageInfo"/> ̃XgB</param>
        /// <exception cref="FormatException">
        /// format łB܂͏ݒΏۂ̈ 0 菬Aڂ̒ȏłB 
        /// </exception>
        protected virtual void ReFillResultMessage(IEnumerable<EntlibValidator.ValidationResult> results,
                                           string tableName,
                                           int rowIndex,
                                           IList<MessageInfo> list)
        {
            if (results != null)
            {
                foreach (EntlibValidator.ValidationResult result in results)
                {
                    string xPath = BuildXPath(tableName, rowIndex, result.Key);
                    ValidationMessageInfo vMessageInfo =
                        new ValidationMessageInfo(result.Key, result.Message, xPath);
                    vMessageInfo.Detail = result;
                    list.Add(vMessageInfo);
                    ReFillResultMessage(result.NestedValidationResults, xPath, list);
                }
            }
        }

        /// <summary>e[uAsCfbNXAm[h XPath 𐶐܂B</summary>
        /// <remarks>
        /// <para>
        /// Ƃēnꂽ <paramref name="tableName"/> A<paramref name="rowIndex"/> A
        ///  <paramref name="nodeName"/> A͒l؋@\őz肳` XPath 
        /// ܂B
        /// </para>
        /// <para>
        /// ͒l؋@\őz肳 XPath ͈ȉ̃tH[}bgłB
        /// </para>
        /// <example>
        /// <code>
        ///   e[u     = "MyTable"
        ///   sCfbNX =  10
        ///   m[h       = "MyColumn"
        /// </code>
        /// ̂ƂA
        /// <code>
        ///   XPath    => "MyTable[10]/MyColumn
        /// </code>
        /// </example>
        /// </remarks>
        /// <param name="tableName">e[uB</param>
        /// <param name="rowIndex">Ώۍs̃CfbNXB</param>
        /// <param name="nodeName">Ώۂ̃m[hB</param>
        /// <returns>w肵p[^ XPath B</returns>
        /// <exception cref="FormatException">
        /// format łB܂͏ݒΏۂ̈ 0 菬Aڂ̒ȏłB 
        /// </exception>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Usage", "CA2233:OperationsShouldNotOverflow", MessageId = "rowIndex+1")]
        protected virtual string BuildXPath(string tableName, int rowIndex, string nodeName)
        {
            return string.Format(XPATH_FORMAT, tableName, rowIndex + 1, nodeName);
        }

        /// <summary>ݒǂݍ <see cref="IConfigurationSource"/> ̎NX̃CX^X𐶐܂B</summary>
        /// <remarks>
        /// <para>
        /// <seealso cref="VabValidator.ValidationFilePath"/> ɐݒ肳ꂽt@CpXA
        /// <see cref="IConfigurationSource"/> ̎NX <see cref="FileConfigurationSource"/> ̃CX^X𐶐郁\bhłB
        /// </para>
        /// </remarks>
        /// <param name="validationFilePath">͒lؐݒt@C̃pXB</param>
        /// <returns>ݒt@C琶ꂽ <see cref="IConfigurationSource"/> B</returns>
        /// <exception cref="TerasolunaException">
        /// <paramref name="validationFilePath"/> ɐݒ肳ꂽlsłB
        /// </exception>
        /// <exception cref="FileNotFoundException">
        /// <paramref name="validationFilePath"/> ݂܂B
        /// </exception>
        protected virtual IConfigurationSource LoadConfigurationSource(string validationFilePath)
        {
            string filePath = null;

            try
            {
                filePath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, validationFilePath);
            }
            catch (ArgumentException e)
            {
                string message = string.Format(Properties.Resources.E_INVALID_FILE_PATH, validationFilePath);
                TerasolunaException exception = new TerasolunaException(message, e);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            if (!File.Exists(filePath))
            {
                string message = string.Format(Properties.Resources.E_VALIDATION_CONFIG_FILE_NOT_FOUND, filePath);
                FileNotFoundException exception = new FileNotFoundException(message, filePath);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            FileConfigurationSource result = new FileConfigurationSource(filePath);

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(Properties.Resources.D_LOAD_CONFIGURATION_SOURCE, filePath));
            }

            return result;
        }
    }
}
