// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Net;
using System.Configuration;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.Client.BLogic;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.ClientUT.BLogic.CommunicateBLogicBaseTestData;
using TERASOLUNA.Fw.Client;

namespace TERASOLUNA.Fw.ClientUT.BLogic
{
    public class CommunicateBLogicBaseImpl01 : CommunicateBLogicBase<DataSet>
    {
        public CommunicateBLogicBase_CommunicatorStub01 _communicator = null;

        public ExecuteProgressChangedEventArgs _e = null;

        public bool _calledOnProgressChanged = false;
      
        protected override ICommunicator<DataSet> CreateCommunicator()
        {
            _communicator = new CommunicateBLogicBase_CommunicatorStub01();
            
            return _communicator;
        }

        protected override CommunicationResult Communicate(BLogicParam blogicParam, IDictionary<string, string> requestHeaders)
        {
            return null;
        }

        protected override void OnProgressChanged(ExecuteProgressChangedEventArgs e)
        {
            _e = e;
            _calledOnProgressChanged = true;
        }

        public void CallDoProgressChanged(ExecuteProgressChangedEventArgs e)
        {
            DoCommunicateProgressChanged(this, e);
        }
    }
}