// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.Conversion
{
    /// <summary>
    /// <see cref="IConverter"/> NX̃CX^X𐶐郁\bh񋟂܂B
    /// </summary>
    /// <remarks>
    /// <para>
    /// <see cref="CreateConverter"/> \bhɂAAvP[V\t@C appSettings vfA
    /// <see cref="CONVERTER_TYPENAME"/> L[ɂāA<see cref="IConverter"/> NX̌^擾A
    /// ΉCX^X𐶐܂B
    /// </para>
    /// <para>
    /// AvP[V\t@Cɐݒ肪݂Ȃꍇ́A <see cref="DataSetConverter"/> NX
    /// CX^X𐶐܂B
    /// </para>
    /// </remarks>
    public class ConverterFactory
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(ConverterFactory));

        /// <summary>
        /// AvP[V\t@C appSettings vfɎw肳 <see cref="IConverter"/>  key łB
        /// </summary>
        /// <remarks>
        /// <para>
        /// ̒萔̒l "ConverterTypeName" łB
        /// </para>
        /// </remarks>
        public static readonly string CONVERTER_TYPENAME = "ConverterTypeName";

        /// <summary>
        /// AvP[V\t@C appSettings vfɎw肳t@Ng^w肷
        /// L[łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "ConverterFactoryTypeName" łB
        /// </remarks>
        public static readonly string CONVERTER_FACTORY_TYPENAME = "ConverterFactoryTypeName";

        /// <summary>
        /// bNp̃IuWFNgłB
        /// </summary>
        private static object _syncRoot = new Object();

        /// <summary>
        /// <see cref="ConverterFactory"/> ̃VOgCX^XłB
        /// </summary>
        private static volatile ConverterFactory _factory = null;

        /// <summary>
        /// <see cref="IConverter"/> NXɑΉ <see cref="Type"/> CX^X
        /// LbVłB
        /// </summary>
        private Type _converterType = null;

        /// <summary>
        /// <see cref="ConverterFactory"/> 擾܂͐ݒ肵܂B
        /// </summary>
        /// <value><see cref="ConverterFactory"/> ̃VOgCX^XB</value>
        protected static ConverterFactory Factory
        {
            get
            {
                if (_factory == null)
                {
                    lock (_syncRoot)
                    {
                        if (_factory == null)
                        {
                            _factory = ClassUtil.CreateInstanceFromAppSettings<ConverterFactory>(
                              CONVERTER_FACTORY_TYPENAME, typeof(ConverterFactory));
                        }
                    }
                }
                return _factory;
            }
        }

        /// <summary>
        /// <see cref="IConverter"/> NXɑΉ <see cref="Type"/> CX^X
        /// LbV擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// <see cref="IConverter"/> NXɑΉ <see cref="Type"/> CX^X
        /// LbVB
        /// </value>
        protected Type ConverterType
        {
            get
            {
                return _converterType;
            }
            set
            {
                _converterType = value;
            }
        }

        /// <summary>
        /// <see cref="ConverterFactory"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public ConverterFactory()
        {
        }

        /// <summary>
        /// <see cref="IConverter"/> NX̃CX^X𐶐܂B
        /// </summary>
        /// <returns><see cref="IConverter"/> NX̃CX^XB
        /// Ɏsꍇ́AOX[A null ͕Ԃ܂B
        /// </returns>
        /// <exception cref="TerasolunaException">
        /// <see cref="IConverter"/> NX̃CX^X𐶐ł܂B
        /// </exception>
        /// <remarks>
        /// <para>
        /// ̃\bhł́AAvP[V\t@C appSettings vf 
        /// <see cref="CONVERTER_TYPENAME"/> L[ɂāA <see cref="IConverter"/> NX
        /// ^擾AΉCX^X𐶐܂B
        /// </para>
        /// <para>
        /// AvP[V\t@Cɐݒ肪݂Ȃꍇ́A <see cref="DataSetConverter"/> NX
        /// CX^X𐶐܂B
        /// </para>
        /// </remarks>
        /// <example>
        /// AvP[V\t@C̐ݒȉɎ܂B
        /// <code>
        /// &lt;appSettings&gt;
        ///   &lt;add key="ConverterTypeName" value="TERASOLUNA.Sample.SampleConverter, TERASOLUNA.Sample"/&gt;
        /// &lt;/appSettings&gt;
        /// </code>
        /// </example>
        public static IConverter CreateConverter()
        {
            IConverter converter = Factory.CreateInstance();

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(Properties.Resources.D_CREATE_INSTANCE_SUCCESS,
                    typeof(IConverter).FullName, converter.GetType().FullName));
            }

            return converter;
        }

        /// <summary>
        /// <see cref="IConverter"/> NX̃CX^X𐶐܂B
        /// </summary>
        /// <returns><see cref="IConverter"/> NX̃CX^XB
        /// Ɏsꍇ́AOX[A null ͕Ԃ܂B
        /// </returns>
        /// <exception cref="TerasolunaException">
        /// <see cref="IConverter"/> NX̃CX^X𐶐ł܂B
        /// </exception>
        /// <remarks>
        /// <para>
        /// ̃\bhł́AAvP[V\t@C appSettings vf 
        /// <see cref="CONVERTER_TYPENAME"/> L[ɂāA <see cref="IConverter"/> NX
        /// ^擾AΉCX^X𐶐܂B
        /// </para>
        /// <para>
        /// AvP[V\t@Cɐݒ肪݂Ȃꍇ́A <see cref="DataSetConverter"/> NX
        /// CX^X𐶐܂B
        /// </para>
        /// </remarks>
        /// <example>
        /// AvP[V\t@C̐ݒȉɎ܂B
        /// <code>
        /// &lt;appSettings&gt;
        ///   &lt;add key="ConverterTypeName" value="TERASOLUNA.Sample.SampleConverter, TERASOLUNA.Sample"/&gt;
        /// &lt;/appSettings&gt;
        /// </code>
        /// </example>
        protected virtual IConverter CreateInstance()
        {
            IConverter converter = null;
            if (_converterType == null)
            {
                // ^LbVĂȂΐݒt@C^擾Đ
                converter = 
                    ClassUtil.CreateInstanceFromAppSettings<IConverter>(CONVERTER_TYPENAME, typeof(DataSetConverter));
                
                // CX^X̌^LbV
                _converterType = converter.GetType();
            }
            else
            {
                // ^LbVĂ΁Ǎ^̃CX^X𐶐
                converter = ClassUtil.CreateInstanceByType<IConverter>(_converterType);
            }

            return converter;
        }
    }
}
