// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Collections.Generic;
using System.Data;

namespace TERASOLUNA.Fw.Client.Communication
{
    /// <summary>
    /// }`p[gf[^̑MAXML̎Ms <see cref="CommunicatorBase{IList}"/> hNXłB
    /// </summary>
    /// <remarks>
    /// ̓f[^ <see cref="MultipartElement"/> ̃RNV}`p[gf[^𐶐đM܂B
    /// Mf[^ <paramref name="TResult"/> ^̌^tf[^Zbgɓǂݍ݂܂B
    /// </remarks>
    /// <typeparam name="TResult">
    /// MXMLf[^i[f[^Zbǧ^B
    /// </typeparam>
    public class MultipartUploadCommunicator<TResult> : CommunicatorBase<IList<MultipartElement>>
        where TResult : DataSet, new()
    {
        /// <summary>
        /// <see cref="MultipartUploadCommunicator{TResult}"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// <para>
        /// <see cref="CommunicatorBase{IList}.Sender"/>  <see cref="MultipartSender"/> ݒ肵܂B
        /// <see cref="MultipartSender"/> ̓}`[p[g̋؂蕶񂪑MΏۂɑ݂ȂƂ`FbN܂B
        /// </para>
        /// <para>
        /// <see cref="CommunicatorBase{IList}.Receiver"/>  <see cref="DataSetXmlReceiver{TResult}"/> ݒ肵܂B
        /// Mf[^ <paramref name="TResult"/> ^̌^tf[^Zbgɓǂݍ݂܂B
        /// </para>
        /// </remarks>
        public MultipartUploadCommunicator()
        {
            Sender = new MultipartSender();
            Receiver = new DataSetXmlReceiver<TResult>();
        }

        /// <summary>
        /// }`[p[g̋؂蕶񂪑MΏۂɑ݂ȂƂ`FbN邩ǂw肵āA
        /// <see cref="MultipartUploadCommunicator{TResult}"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ̃RXgN^́A<see cref="MultipartSender"/>  <see cref="MultipartSender.CheckBoundary"/> 
        /// <paramref name="checkBoundaryFlag"/> p[^gpď܂B
        /// <para>
        /// <see cref="CommunicatorBase{IList}.Sender"/>  <see cref="MultipartSender"/> ݒ肵܂B
        /// <see cref="MultipartSender"/>  <paramref name="checkBoundaryFlag"/>  true ̎
        /// }`[p[g̋؂蕶񂪑MΏۂɑ݂ȂƂ`FbN܂B
        /// false ̎̓`FbN܂B
        /// </para>
        /// <para>
        /// <see cref="CommunicatorBase{IList}.Receiver"/>  <see cref="DataSetXmlReceiver{TResult}"/> ݒ肵܂B
        /// Mf[^ <paramref name="TResult"/> ^̌^tf[^Zbgɓǂݍ݂܂B
        /// </para>
        /// </remarks>
        /// <param name="checkBoundaryFlag">
        /// }`[p[g̋؂蕶񂪑MΏۂɑ݂ȂƂ`FbN邩ǂ̃tOB
        /// true ̎̓`FbN܂Bfalse ̎̓`FbN܂B
        /// </param>
        public MultipartUploadCommunicator(bool checkBoundaryFlag)
        {
            MultipartSender sender = new MultipartSender();
            sender.CheckBoundary = checkBoundaryFlag;
            Sender = sender;
            Receiver = new DataSetXmlReceiver<TResult>();
        }
    }
}
