﻿// <著作権>
// Copyright (c) 2007, NTT DATA Corporation.  

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using NTTDATA.TERASOLUNA.FW.Web;
using System.IO;
using NTTDATA.TERASOLUNA.FW.Web.Controller.Multipart;

namespace MultipartUploadUT
{
    /// <summary>
    /// NTTDATA.TERASOLUNA.FW.Web.Multipart.MultipartUploadTest のテスト クラスです。
    ///</summary>
    ///<author>
    /// 菅井隆雄
    ///</author>

    /// <summary>
    /// NTTDATA.TERASOLUNA.FW.Web.Multipart.MultipartUpload のテスト クラスです。すべての
    /// NTTDATA.TERASOLUNA.FW.Web.Multipart.MultipartUpload 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class MultipartUploadTest
    {

        private TestContext testContextInstance;

        // テスト対象となるクラス
        private MultipartUpload target = null;

        // 設定する要素
        private IMultipartItemFactory factory = null;
        private HttpContextWrapperStub01 httpContextWrapper = null;
       
        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// CreateMultipartItems (HttpContextWrapper) のテスト
        ///</summary>
        ///<remarks>
        /// _httpContextWrapper.RequestStreamがnullの場合
        /// 例外(InvalidOperationException)が発生することを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void CreateMultipartItemsTest01()
        {
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            httpContextWrapper._requestStream = null;
            httpContextWrapper._contentType = "multipart/form-data; boundary=boundary";

             target = new MultipartUpload(httpContextWrapper, factory);

            try
            {
                target.CreateMultipartItems();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (InvalidOperationException)
            {
                // 成功
            }
            catch (Exception ex)
            {
                Assert.Fail("予期せぬエラーです。"+ex.ToString());
            }
        }


        /// <summary>
        /// CreateMultipartItems (HttpContextWrapper) のテスト
        ///</summary>
        ///<remarks>
        /// 終端子が存在しない場合
        /// 例外(InvalidRquestException)が発生することを確認するテスト
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateItem03.txt")]
        public void CreateMultipartItemsTest03()
        {
            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            // 実行
            using (Stream partStream = new FileStream(@"MultipartUpload_CreateItem03.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType = "multipart/form-data; boundary=boundary";

                 target = new MultipartUpload(httpContextWrapper, factory);

                try
                {
                    // 失敗
                    target.CreateMultipartItems();
                    Assert.Fail("到達してはいけないコードです。");
                }
                catch (InvalidRequestException)
                {
                    // 成功
                }
                catch (Exception ex)
                {
                    // 失敗
                    Assert.Fail("予期せぬエラーです。"+ex.ToString());
                }
            }
        }

        ///<summary>
        /// CreateMultipartItems (HttpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// 終端子から始まっている場合、
        /// 正常に動作することを確認するテスト
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateItem04.txt")]
        public void CreateMultipartItemsTest04()
        {

            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateItem04.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType = "multipart/form-data; boundary=boundary";

                 target = new MultipartUpload(httpContextWrapper, factory);
                
                // 実行
                IDictionary<string, IMultipartItem> multipartItems 
                    = target.CreateMultipartItems();
                
                //検証
                Assert.AreEqual(0,multipartItems.Count);
            }
        }

        ///<summary>
        /// CreateMultipartItems (HttpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// 終端子の後ろにデータが存在する場合、
        /// 正常に動作することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateItem05.txt")]
        public void CreateMultipartItemsTest05()
        {

            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateItem05.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType = "multipart/form-data; boundary=boundary";

                 target = new MultipartUpload(httpContextWrapper, factory);

                // 実行
                IDictionary<string, IMultipartItem> multipartItems 
                    = target.CreateMultipartItems();

                MultipartTextItem item = (MultipartTextItem)multipartItems["text2"];

                string text1 = item.Text;
                int actual = multipartItems.Count;
                int expected = 1;

                //検証
                Assert.AreEqual("abcde", text1);
                Assert.AreEqual(expected,actual);
            }
        }

        ///<summary>
        /// CreateMultipartItems  (HttpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// 次のパートが存在する場合、
        /// 正常に動作することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateItem06.txt")]
        public void CreateMultipartItemsTest06()
        {

            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateItem06.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType = "multipart/form-data; boundary=boundary";

                 target = new MultipartUpload(httpContextWrapper, factory);

                // 実行
                IDictionary<string, IMultipartItem> multipartItems
                    = target.CreateMultipartItems();

                MultipartTextItem item1 = (MultipartTextItem)multipartItems["text2"];
                string text1 = item1.Text;

                MultipartTextItem item2 = (MultipartTextItem)multipartItems["text3"];
                string text2 = item2.Text;

                MultipartTextItem item3 = (MultipartTextItem)multipartItems["text4"];
                string text3 = item3.Text;

                 int actual= multipartItems.Count;

                 int expected = 3;

                //検証
                 Assert.AreEqual(expected, actual);
                 Assert.AreEqual("abcde", text1);
                 Assert.AreEqual("fghij", text2);
                 Assert.AreEqual("klmno", text3);
            }
        }


        ///<summary>
        /// CreateMultipartItems  (HttpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// マルチパートが要素名が重複して存在する場合、
        /// 例外(ArgumentException)が発生することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateItem07.txt")]
        public void CreateMultipartItemsTest07()
        {

            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateItem07.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType = "multipart/form-data; boundary=boundary";

                 target = new MultipartUpload(httpContextWrapper, factory);


                // 実行
                try
                {
                    // 失敗
                    IDictionary<string, IMultipartItem> multipartItems
                  = target.CreateMultipartItems();
                    Assert.Fail("到達してはいけないコードです。");
                }
                catch (InvalidRequestException)
                {
                    // 成功
                }
                catch (Exception ex)
                {
                    // 失敗
                    Assert.Fail("予期せぬエラーです。"+ex.ToString());
                }
            }
        }


        ///<summary>
        /// CreateMultipartItems (HttpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// Content-Typeにnullを設定した場合、
        /// 例外(InvalidOperationException)が発生することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems.txt")]
        public void CreateMultipartItemsTest08()
        {

            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType = null;

                 target = new MultipartUpload(httpContextWrapper, factory);

                // 実行
                try
                {
                    // 失敗
                  IDictionary<string,IMultipartItem> actual = target.CreateMultipartItems();    

                }
                catch (InvalidOperationException)
                {
                    // 成功
                }
                catch (Exception ex)
                {
                    // 失敗
                    Assert.Fail("予期せぬエラーです。"+ex.ToString());
                }
            }
        }


        ///<summary>
        /// CreateMultipartItems (HttpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// Content-Typeに空文字列を設定した場合、
        /// 例外(InvalidOperationException)が発生することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems.txt")]
        public void CreateMultipartItemsTest09()
        {

            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType = "";

                 target = new MultipartUpload(httpContextWrapper, factory);

                // 実行
                try
                {
                    // 失敗
                    IDictionary<string, IMultipartItem> actual = target.CreateMultipartItems();
                }
                catch (InvalidOperationException)
                {
                    // 成功
                }
                catch (Exception ex)
                {
                    // 失敗
                    Assert.Fail("予期せぬエラーです。"+ex.ToString());
                }
            }
        }
        ///<summary>
        /// CreateMultipartItems(HttpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// Content-Typeが"multipart/mixed"という文字列の場合、
        /// 例外(InvalidRquestException)が発生することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems.txt")]
        public void CreateMultipartItemsTest10()
        {
            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType
                    = "Multipart/mixed; boundary=boundary;charSet=UTF-8";

                 target = new MultipartUpload(httpContextWrapper, factory);

                try
                {
                    // 失敗
                    target.CreateMultipartItems();
                    Assert.Fail("到達してはいけないコードです。");
                }
                catch (InvalidRequestException)
                {
                    // 成功
                }
                catch (Exception ex)
                {
                    // 失敗
                    Assert.Fail("予期せぬエラーです。"+ex.ToString());
                }
            }
        }

        ///<summary>
        /// CreateMultipartItems(HttpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// Content-Typeに"boundary"という文字列が存在しない場合、
        /// 例外(InvalidRquestException)が発生することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems.txt")]
        public void CreateMultipartItemsTest11()
        {
            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType
                    = "multipart/form-data;charSet=UTF-8";

                 target = new MultipartUpload(httpContextWrapper, factory);

                try
                {
                    // 失敗
                    target.CreateMultipartItems();
                    Assert.Fail("到達してはいけないコードです。");
                }
                catch (InvalidRequestException)
                {
                    // 成功
                }
                catch (Exception ex)
                {
                    // 失敗
                    Assert.Fail("予期せぬエラーです。"+ex.ToString());
                }
            }
        }

        ///<summary>
        /// CreateMultipartItems(HttpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// Content-Typeに"charset"という文字列1個存在し値がUTF-8が存在する場合、
        /// 正常に動作することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems.txt")]
        public void CreateMultipartItemsTest12()
        {
            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType
                    = "multipart/form-data; boundary=boundary;charSet=UTF-8";

                 target = new MultipartUpload(httpContextWrapper, factory);

                // 実行
                IDictionary<string, IMultipartItem> multipartItems
                    = target.CreateMultipartItems();

                int actual = multipartItems.Count;
                int expected = 3;

                // 検証
                Assert.AreEqual(expected, actual);
                Assert.AreEqual("abcde", ((MultipartTextItem)multipartItems["text1"]).Text);
                Assert.AreEqual("たんたいしけん", ((MultipartTextItem)multipartItems["text2"]).Text);
                Assert.AreEqual("あいうえお", ((MultipartTextItem)multipartItems["text3"]).Text);
            }
        }

        ///<summary>
        /// CreateMultipartItems(HttpContextWrapper) のテスト
        ///</summary>
        ///<remarks>
        /// Content-Typeに"charset"文字列1個存在し値がShift-JISを設定した場合、
        /// 正常に動作することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItem_Shift_JIS.txt")]
        public void CreateMultipartItemsTest13()
        {
            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItem_Shift_JIS.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType
                    = "multipart/form-data; boundary=boundary;charset=Shift-JIS";

                 target = new MultipartUpload(httpContextWrapper, factory);

                // 実行
                IDictionary<string, IMultipartItem> multipartItems
                    = target.CreateMultipartItems();

                int actual = multipartItems.Count;
                int expected = 3;

                // 検証
                Assert.AreEqual(expected, actual);
                Assert.AreEqual("abcde", ((MultipartTextItem)multipartItems["text1"]).Text);
                Assert.AreEqual("たんたいしけん", ((MultipartTextItem)multipartItems["text2"]).Text);
                Assert.AreEqual("あいうえお", ((MultipartTextItem)multipartItems["text3"]).Text);
            }
        }

        ///<summary>
        /// CreateMultipartItems(HttpContextWrapper) のテスト
        ///</summary>
        ///<remarks>
        /// Content-TypeのcharSetに異常な値の場合、
        /// 例外(InvalidRquestException)が発生することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems.txt")]
        public void CreateMultipartItemsTest14()
        {
            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType
                    = "multipart/form-data; boundary=boundary;charSet=CreateMultipartItemTest14";

                 target = new MultipartUpload(httpContextWrapper, factory);

                try
                {
                    // 失敗
                    target.CreateMultipartItems();
                    Assert.Fail("到達してはいけないコードです。");
                }
                catch (InvalidRequestException)
                {
                    // 成功
                }
                catch (Exception ex)
                {
                    // 失敗
                    Assert.Fail("予期せぬエラーです。"+ex.ToString());
                }
            }
        }

        ///<summary>
        /// CreateMultipartItems(HttpContextWrapper) のテスト
        ///</summary>
        ///<remarks>
        /// Content-Typeに"charSet"を含む文字列が1個存在する場合、
        /// 正常に動作することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems.txt")]
        public void CreateMultipartItemsTest15()
        {
            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType
                    = "multipart/form-data; boundary=boundary;charSet=UTF-8";

                 target = new MultipartUpload(httpContextWrapper, factory);

                // 実行
                IDictionary<string, IMultipartItem> multipartItems
                    = target.CreateMultipartItems();

                int actual = multipartItems.Count;
                int expected = 3;

                // 検証
                Assert.AreEqual(expected, actual);
                Assert.AreEqual("abcde", ((MultipartTextItem)multipartItems["text1"]).Text);
                Assert.AreEqual("たんたいしけん", ((MultipartTextItem)multipartItems["text2"]).Text);
                Assert.AreEqual("あいうえお", ((MultipartTextItem)multipartItems["text3"]).Text);
            }
        }

        ///<summary>
        /// CreateMultipartItems (HttpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// Content-TypeにCHARSETが存在する場合、
        /// 正常に動作することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems.txt")]
        public void CreateMultipartItemsTest16()
        {
            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType
                    = "multipart/form-data; boundary=boundary;CHARSET=UTF-8";

                 target = new MultipartUpload(httpContextWrapper, factory);

                // 実行
                IDictionary<string, IMultipartItem> multipartItems
                    = target.CreateMultipartItems();

                int actual = multipartItems.Count;
                int expected = 3;

                // 検証
                Assert.AreEqual(expected, actual);
                Assert.AreEqual("abcde", ((MultipartTextItem)multipartItems["text1"]).Text);
                Assert.AreEqual("たんたいしけん", ((MultipartTextItem)multipartItems["text2"]).Text);
                Assert.AreEqual("あいうえお", ((MultipartTextItem)multipartItems["text3"]).Text);

            }
        }

        ///<summary>
        /// CreateMultipartItems(HttpContextWrapper) のテスト
        ///</summary>
        ///<remarks>
        /// Content-Typeに"charsets"を含む別の文字列が存在する場合、
        /// 正常に動作することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems.txt")]
        public void CreateMultipartItemsTest17()
        {

            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType
                    = "multipart/form-data; boundary=boundary;charsets=UTF-8";

                 target = new MultipartUpload(httpContextWrapper, factory);

                // 実行
                IDictionary<string, IMultipartItem> multipartItems
                    = target.CreateMultipartItems();

                int actual = multipartItems.Count;
                int expected = 3;

                // 検証
                Assert.AreEqual(expected, actual);
                Assert.AreEqual("abcde", ((MultipartTextItem)multipartItems["text1"]).Text);
                Assert.AreEqual("たんたいしけん", ((MultipartTextItem)multipartItems["text2"]).Text);
                Assert.AreEqual("あいうえお", ((MultipartTextItem)multipartItems["text3"]).Text);
            }
        }

        ///<summary>
        /// CreateMultipartItems(HttpContextWrapper) のテスト
        ///</summary>
        ///<remarks>
        /// Content-Typeに"charset"を含む文字列が2個存在する場合、
        /// 例外(InvalidRquestException)がスローされることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems.txt")]
        public void CreateMultipartItemsTest18()
        {

            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType
                    = "multipart/form-data; boundary=boundary;charset=UTF-8;charset=Shift-JIS";

                 target = new MultipartUpload(httpContextWrapper, factory);

                // 実行
                try
                {
                    // 失敗
                    target.CreateMultipartItems();
                    Assert.Fail("到達してはいけないコードです。");
                }
                catch (InvalidRequestException)
                {
                    // 成功
                }
                catch (Exception ex)
                {
                    // 失敗
                    Assert.Fail("予期せぬエラーです。"+ex.ToString());
                }
            }
        }

        ///<summary>
        /// CreateMultipartItems(HttpContextWrapper) のテスト
        ///</summary>
        ///<remarks>
        /// _httpContextWarpper.RequestStreamに最初の区切り文字の前に改行が存在する場合
        /// 正常に動作することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems19.txt")]
        public void CreateMultipartItemsTest19()
        {

            // 準備
             httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems19.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType
                    = "multipart/form-data; boundary=boundary;charset=UTF-8";

                 target = new MultipartUpload(httpContextWrapper, factory);

                // 実行
                IDictionary<string, IMultipartItem> multipartItems
                    = target.CreateMultipartItems();

                int actual = multipartItems.Count;
                int expected = 3;

                // 検証
                Assert.AreEqual(expected, actual);
                Assert.AreEqual("abcde", ((MultipartTextItem)multipartItems["text1"]).Text);
                Assert.AreEqual("たんたいしけん", ((MultipartTextItem)multipartItems["text2"]).Text);
                Assert.AreEqual("あいうえお", ((MultipartTextItem)multipartItems["text3"]).Text);
            }
        }

        ///<summary>
        /// CreateMultipartItems(HttpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// Content-Typeに"multipart/form-data"という文字列が含まれている場合、
        /// 例外(InvalidRquestException)が発生することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartUpload_CreateMultipartItems.txt")]
        public void CreateMultipartItemsTest20()
        {
            // 準備
            httpContextWrapper = new HttpContextWrapperStub01();
            factory = new MultipartItemFactory();

            using (Stream partStream = new FileStream(@"MultipartUpload_CreateMultipartItems.txt", FileMode.Open, FileAccess.Read))
            {
                httpContextWrapper._requestStream = partStream;
                httpContextWrapper._contentType
                    = "multipart/form-datas; boundary=boundary;charSet=UTF-8";

                target = new MultipartUpload(httpContextWrapper, factory);

                try
                {
                    // 失敗
                    target.CreateMultipartItems();
                    Assert.Fail("到達してはいけないコードです。");
                }
                catch (InvalidRequestException)
                {
                    // 成功
                }
                catch (Exception ex)
                {
                    // 失敗
                    Assert.Fail("予期せぬエラーです。" + ex.ToString());
                }
            }
        }

        /// <summary>
        /// Factory(IMultipartItemFactory)のテスト
        ///</summary>
        ///<remarks>
        /// nullを取得することを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void FactoryTest01()
        {
            // 準備
            HttpContextWrapper httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            // 実行
            target = new MultipartUpload(httpContextWrapper, factory);
            NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartUploadAccessor accessor = new NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartUploadAccessor(target);
            accessor._factory = null;

            // 検証
            Assert.IsNull(target.Factory);
        }


        /// <summary>
        /// Factory(IMultipartItemFactory)のテスト
        ///</summary>
        ///<remarks>
        /// notnullを取得することを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void FactoryTest02()
        {
            // 準備
            HttpContextWrapper httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            // 実行
             target = new MultipartUpload(httpContextWrapper, factory);
            NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartUploadAccessor accessor = new NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartUploadAccessor(target);
            accessor._factory = new MultipartItemFactory();

            //検証
            Assert.IsNotNull(target.Factory);
        }


        /// <summary>
        /// HttpContextWrapper(httpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// nullを取得することを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void HttpContextWrapperTest01()
        {
            // 準備
            HttpContextWrapper httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory(); 
            
            // 実行
            target = new MultipartUpload(httpContextWrapper, factory);
            NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartUploadAccessor accessor = new NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartUploadAccessor(target);
            accessor._httpContextWrapper = null;

            //検証
            Assert.IsNull(target.HttpContextWrapper);
        }


        /// <summary>
        /// HttpContextWrapper(httpContextWrapper)のテスト
        ///</summary>
        ///<remarks>
        /// notnullを取得することを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void HttpContextWrapperTest02()
        {
            // 準備
            HttpContextWrapper httpContextWrapper = new HttpContextWrapperStub01();
             factory = new MultipartItemFactory();

            // 実行
             target = new MultipartUpload(httpContextWrapper, factory);
            NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartUploadAccessor accessor = new NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartUploadAccessor(target);
            accessor._httpContextWrapper = new HttpContextWrapperStub01();

            // 検証
            Assert.IsNotNull(target.HttpContextWrapper);
        }
        

        /// <summary>
        /// MultipartUpload (HttpContextWrapper, IMultipartItemFactory) のテスト
        ///</summary>
        ///<remarks>
        /// httpContextWrapperとfactoryに正常値を入力した場合、
        /// httpContextWrapperとfactoryがnullでないことを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            // 準備
            HttpContextWrapper httpContextWrapper = new HttpContextWrapperStub01(); 
             factory = new MultipartItemFactory(); 

            // 実行
             target = new MultipartUpload(httpContextWrapper, factory);

            // 検証
            Assert.IsNotNull(target);
          }


          /// <summary>
          /// MultipartUpload (HttpContextWrapper, IMultipartItemFactory) のテスト
          ///</summary>
          ///<remarks>
          /// httpContextWrapperにnullを設定した場合、
          /// ArgumentNullExceptionがスローされることを確認するテスト
          ///</remarks>
          [TestMethod()]
          public void ConstructorTest02()
          {
              // 準備
              HttpContextWrapper httpContextWrapper = null;
               factory = new MultipartItemFactory();

              // 実行
              try
              {
                  // 失敗
                   target = new MultipartUpload(httpContextWrapper, factory);
                  Assert.Fail("到達してはいけないコードです。");
              }

              catch (ArgumentNullException)
              {
                  // 成功
              }
              
              catch (Exception ex)
              {
                  // 失敗
                  Assert.Fail("予期せぬエラーです。"+ex.ToString());
              }
          }
         

        /// <summary>
        /// MultipartUpload (HttpContextWrapper, IMultipartItemFactory) のテスト
        ///</summary>
        ///<remarks>
        /// factoryにnullを設定した場合、
        /// ArgumentNullExceptionがスローされることを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest03()
        {
            // 準備
            HttpContextWrapper httpContextWrapper = new HttpContextWrapperStub01();
             factory = null;

            // 実行
            try
            {
                // 失敗
                 target = new MultipartUpload(httpContextWrapper, factory);
                Assert.Fail("到達してはいけないコードです。");
            }

            catch (ArgumentNullException)
            {
                // 成功
            }

            catch (Exception ex)
            {
                // 失敗
                Assert.Fail("予期せぬエラーです。"+ex.ToString());
            }
        }
    }
}
