﻿//<著作権>
//Copyright (c) 2007, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using System.IO;
using NTTDATA.TERASOLUNA.FW.Common;
using NTTDATA.TERASOLUNA.FW.Web;
using NTTDATA.TERASOLUNA.FW.Web.Controller.Multipart;

namespace MultipartUploadUT
{
    /// <summary>
    /// NTTDATA.TERASOLUNA.FW.Web.Multipart.MultipartTextItem のテスト クラスです。
    ///</summary>
    ///<author>
    /// 菅井隆雄
    ///</author>

    [TestClass()]
    public class MultipartTextItemTest
    {

        private TestContext testContextInstance;

        // テスト対象となるクラス
        private MultipartTextItem target = null;

        // boudary[文字列 : boundary]
        private static readonly string BOUNDARY = "boundary";

        // エンコード[UTF-8]
        private static readonly Encoding ENCODING = new UTF8Encoding();

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// MultipartTextItem (string, Stream, IDictionary&lt;string,string&gt;, Encoding) のテスト
        ///</summary>
        ///<remarks>
        /// partStreamに区切り文字が存在する場合、
        /// 正常に動作することを確認するテスト。
        ///</remarks>

        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartTextItem.txt")]
        public void ConstructorTest01()
        {
            // 準備
            Stream fs = new FileStream(@"MultipartTextItem.txt", FileMode.Open, FileAccess.Read);

            Stream partStream = fs;

            System.Collections.Generic.IDictionary<string, string> headerList = new Dictionary<string, string>();
            headerList.Add("CONTENT-DISPOSITION", "form-data; name=text1");
            headerList.Add("content-type", "application/x-www-form-urlencoded");
            headerList.Add("content-part", "MultipartTextItem");            

            // 実行
            target = new MultipartTextItem(BOUNDARY, partStream, headerList, ENCODING);

            string expectedValue = "単体試験"; 

            NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartTextItemAccessor accessor =
                new NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartTextItemAccessor(target);
            
            // 検証
            Assert.AreEqual(expectedValue, accessor._text);
        }

        /// <summary>
        ///MultipartTextItem (string, Stream, IDictionary&lt;string,string&gt;, Encoding) のテスト
        ///</summary>
        ///<remarks>
        /// partStreamがnullの場合、
        /// 例外(ArgumentNullException)が発生することを確認するテスト。
        ///</remarks>

        [TestMethod()]
        public void ConstructorTest02()
        {
            // 準備
            Stream partStream = null;

            System.Collections.Generic.IDictionary<string, string> headerList = new Dictionary<string, string>();
            headerList.Add("CONTENT-DISPOSITION", "form-data; name=text1");
            headerList.Add("content-type", "application/x-www-form-urlencoded");
            headerList.Add("content-part", "MultipartTextItem");           

            // 実行
            try
            {
                // 失敗
                MultipartTextItem target = new MultipartTextItem(BOUNDARY, partStream, headerList, ENCODING);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException)
            {
                // 成功
            }
            catch (Exception e)
            {
                // 失敗
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }
        }

        /// <summary>
        /// MultipartTextItem (string, Stream, IDictionary&lt;string,string&gt;, Encoding) のテスト
        ///</summary>
        ///<remarks>
        /// MultipartTextItem.txtに区切り文字が存在しない場合、
        /// InvalidRequestExceptionが発生することを確認するテスト。
        ///</remarks>

        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartTextItem2.txt")]
        public void ConstructorTest03()
        {
            // 準備
            Stream fs = new FileStream(@"MultipartTextItem2.txt", FileMode.Open, FileAccess.Read);

            Stream partStream = fs;

            System.Collections.Generic.IDictionary<string, string> headerList = new Dictionary<string, string>();
            headerList.Add("CONTENT-DISPOSITION", "form-data; name=text1");
            headerList.Add("content-type", "application/x-www-form-urlencoded");
            headerList.Add("content-part", "MultipartTextItem");

            // 実行
            try
            {
                // 失敗
                MultipartTextItem target = new MultipartTextItem(BOUNDARY, partStream, headerList, ENCODING);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (InvalidRequestException)
            {
                // 成功
            }
            catch (Exception e)
            {
                // 失敗
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }
        }


        /// <summary>
        /// Text のテスト
        ///</summary>
        ///<remarks>
        /// 要素数3のインスタンスを設定し、nullを設定した場合、
        /// nullの取得を確認するテスト
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartTextItem.txt")]
        public void TextTest01()
        {
            // 準備
            Stream fs = new FileStream(@"MultipartTextItem.txt", FileMode.Open, FileAccess.Read);

            Stream partStream = fs;

            System.Collections.Generic.IDictionary<string, string> headerList = new Dictionary<string, string>();
            headerList.Add("CONTENT-DISPOSITION", "form-data; name=text1");
            headerList.Add("content-type", "application/x-www-form-urlencoded");
            headerList.Add("content-part", "MultipartTextItem");

            // 実行
            MultipartTextItem target = new MultipartTextItem(BOUNDARY, partStream, headerList, ENCODING);

            NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartTextItemAccessor accessor = new NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartTextItemAccessor(target);
            accessor._text = null;

            // 検証
            Assert.IsNull(target.Text);
        }


        /// <summary>
        /// Text のテスト
        ///</summary>
        ///<remarks>
        /// 要素数3のインスタンスを設定し、空文字列を設定した場合、
        /// 空文字列の取得を確認するテスト
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartTextItem.txt")]
        public void TextTest02()
        {
            // 準備
            Stream fs = new FileStream(@"MultipartTextItem.txt", FileMode.Open, FileAccess.Read);

            Stream partStream = fs;

            System.Collections.Generic.IDictionary<string, string> headerList = new Dictionary<string, string>();
            headerList.Add("CONTENT-DISPOSITION", "form-data; name=text1");
            headerList.Add("content-type", "application/x-www-form-urlencoded");
            headerList.Add("content-part", "MultipartTextItem");

            // 実行
            MultipartTextItem target = new MultipartTextItem(BOUNDARY, partStream, headerList, ENCODING);

            NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartTextItemAccessor accessor = new NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartTextItemAccessor(target);
            accessor._text = "";

            // 検証
            Assert.AreEqual(accessor._text, target.Text);
        }


        /// <summary>
        /// Textのテスト
        ///</summary>
        ///<remarks>
        /// 要素数3のインスタンスを設定し、半角文字列(空文字列でない)を設定した合、
        /// 半角文字列(空文字列でない)の取得を確認するテスト
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartTextItem.txt")]
        public void TextTest03()
        {
            // 検証
            Stream fs = new FileStream(@"MultipartTextItem.txt", FileMode.Open, FileAccess.Read);

            Stream partStream = fs;

            System.Collections.Generic.IDictionary<string, string> headerList = new Dictionary<string, string>();
            headerList.Add("CONTENT-DISPOSITION", "form-data; name=text1");
            headerList.Add("content-type", "application/x-www-form-urlencoded");
            headerList.Add("content-part", "MultipartTextItem");

            // 実行
            MultipartTextItem target = new MultipartTextItem(BOUNDARY, partStream, headerList, ENCODING);
            NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartTextItemAccessor accessor = new NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartTextItemAccessor(target);
            accessor._text = "hoge";

            // 検証
            Assert.AreEqual(accessor._text,target.Text);
        }


        /// <summary>
        /// Text のテスト
        ///</summary>
        ///<remarks>
        /// 要素数3のインスタンスを設定し、全角文字列(空文字列でない)を設定した場合、
        /// 全角文字列(空文字列でない)の取得を確認するテスト
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartTextItem.txt")]
        public void TextTest04()
        {
            // 準備
            Stream fs = new FileStream(@"MultipartTextItem.txt", FileMode.Open, FileAccess.Read);

            Stream partStream = fs;

            System.Collections.Generic.IDictionary<string, string> headerList = new Dictionary<string, string>();
            headerList.Add("CONTENT-DISPOSITION", "form-data; name=text1");
            headerList.Add("content-type", "application/x-www-form-urlencoded");
            headerList.Add("content-part", "MultipartTextItem");

            // 実行
            MultipartTextItem target = new MultipartTextItem(BOUNDARY, partStream, headerList, ENCODING);
            NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartTextItemAccessor accessor = new NTTDATA_TERASOLUNA_FW_Web_Multipart_MultipartTextItemAccessor(target);
            accessor._text = "単体試験";

            // 検証
            Assert.AreEqual(accessor._text,target.Text);
        }


        /// <summary>
        /// Dispose () のテスト
        /// </summary>
        /// <remarks>
        /// 実行できるかどうか確認するテスト
        /// </remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartTextItem.txt")]
        public void DisposeTest()
        {
            // 準備
            Stream fs = new FileStream(@"MultipartTextItem.txt", FileMode.Open, FileAccess.Read);

            Stream partStream = fs;

            System.Collections.Generic.IDictionary<string, string> headerList = new Dictionary<string, string>();
            headerList.Add("CONTENT-DISPOSITION", "form-data; name=text1");
            headerList.Add("content-type", "application/x-www-form-urlencoded");
            headerList.Add("content-part", "MultipartTextItem");
           
            MultipartTextItem target = new MultipartTextItem(BOUNDARY, partStream, headerList, ENCODING);

            // 実行
            target.Dispose();
        }

        /// <summary>
        /// IsText のテスト
        ///</summary>
        ///<remarks>
        /// 要素数3のインスタンスを設定し、全角文字列(空文字列でない)を設定した場合、
        /// 全角文字列(空文字列でない)の取得を確認するテスト
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\MultipartTextItem.txt")]
        public void IsTextTest()
        {
            // 準備

            Stream fs = new FileStream(@"MultipartTextItem.txt", FileMode.Open, FileAccess.Read);

            Stream partStream = fs;

            System.Collections.Generic.IDictionary<string, string> headerList = new Dictionary<string, string>();
            headerList.Add("CONTENT-DISPOSITION", "form-data; name=text1");
            headerList.Add("content-type", "application/x-www-form-urlencoded");
            headerList.Add("content-part", "MultipartTextItem");

            // 実行
            MultipartTextItem target = new MultipartTextItem(BOUNDARY, partStream, headerList, ENCODING);

            // 検証
            Assert.IsTrue(target.IsText);
        }

    }
}
