// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.IO;
using System.Net.Mime;
using System.Reflection;
using System.Text;
using System.Web;
using System.Xml;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common.Validation;
using TERASOLUNA.Fw.Web.Configuration.ExceptionCode;

namespace TERASOLUNA.Fw.Web.Controller
{
    /// <summary>
    /// NCAg̃rWlXWbNsvRg[NXłB
    /// </summary>
    /// <remarks>
    /// <para>t@C̃Abv[hAу_E[h𔺂ȂrWlXWbNsv
    /// Rg[NXłB</para>
    /// </remarks>
    public class BLogicRequestController : IHttpHandler
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(BLogicRequestController));

        /// <summary>
        /// rWlXWbN̓̓p[^ƂȂ <see cref="DataSet"/>  <see cref="HttpContext.Items"/> 
        /// ݒ/擾ۂɃL[ƂȂ镶łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "TERASOLUNA_InputParam" łB
        /// </remarks>
        protected static readonly string KEY_CONTEXT_ITEM_INPUTPARAM = "TERASOLUNA_InputParam";

        /// <summary>
        /// rWlXWbŇʃIuWFNg <see cref="BLogicResult"/> 
        /// <see cref="HttpContext.Items"/> 
        /// ݒ/擾ۂɃL[ƂȂ镶łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "TERASOLUNA_BLogicResult" łB
        /// </remarks>
        protected static readonly string KEY_CONTEXT_ITEM_BLOGIC_RESULT = "TERASOLUNA_BLogicResult";

        /// <summary>
        /// ͒l؂̌ʃIuWFNg <see cref="ValidationResult"/>  <see cref="HttpContext.Items"/> 
        /// ݒ/擾ۂɃL[ƂȂ镶łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "TERASOLUNA_ValidationResult" łB
        /// </remarks>
        protected static readonly string KEY_CONTEXT_ITEM_VALIDATION_RESULT = "TERASOLUNA_ValidationResult";
        /// <summary>
        /// G[ʃwb_̂łB 
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exception" łB
        /// </remarks>
        protected static readonly string EXCEPTION_HEADER_NAME = "exception";
        /// <summary>
        /// ͒l؃G[ɃG[ʃwb_ɐݒ肷lłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "validateException" łB
        /// </remarks>
        protected static readonly string EXCEPTION_VALIDATE = "validateException";
        /// <summary>
        /// VXeG[ɃG[ʃwb_ɐݒ肷lB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exception" łB
        /// </remarks>
        protected static readonly string EXCEPTION_SYSTEM = "exception";
        /// <summary>
        /// X|X̃Xe[^XƂĐݒ肷lłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "OK" łB
        /// </remarks>
        protected static readonly string STATUS_DESCRIPTION = "OK";
        /// <summary>
        /// OR[hݒ肪ݒ̏ꍇɃX|X̃G[R[hɐݒ肷lłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "E_UNKNOWN_EXCEPTION" łB
        /// </remarks>
        protected static readonly string UNKNOWN_EXCEPTION_ERROR_CODE = "E_UNKNOWN_EXCEPTION";
        /// <summary>
        /// ͒l؃t@CpX̃[gƂȂfBNĝłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "Bin" łB
        /// </remarks>
        protected static readonly string VALIDATION_FILE_PATH_ROOT = "Bin";

        /// <summary>
        /// ʂ̗v <see cref="IHttpHandler"/> CX^Xgpł邩ǂl擾܂B
        /// </summary>
        /// <value>
        /// <see cref="IHttpHandler"/> CX^Xgpł邩ǂlB
        /// </value>
        /// <returns>
        ///  true ԋp܂B
        /// </returns>
        public virtual bool IsReusable
        {
            get
            {
                return true;
            }
        }

        /// <summary>
        /// HTTP Web v܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// ̏ŃNGXgs܂B
        /// <list type="number">
        /// <item>
        /// <see cref="ValidateRequestHeader"/> ĂяoAwb_؂s܂B
        /// </item>
        /// <item>
        /// <see cref="ParseRequestBody"/> ĂяoA{fB̉͂s܂B
        /// </item>
        /// <item>
        /// <see cref="ValidateInputData"/> ĂяoA͒ľ؂s܂B
        /// </item>
        /// <item>
        /// <see cref="ExecuteBLogic"/> ĂяoArWlXWbN̎ss܂B
        /// </item>
        /// <item>
        /// <see cref="WriteSuccessResponse"/> ĂяoA펞̃X|X݂s܂B
        /// </item>
        /// <item>
        /// <see cref="ValidateInputData"/> ̖߂l false łꍇA <see cref="WriteValidationErrorResponse"/> ĂяoA
        /// ͒l؃G[̃X|X݂s܂B
        /// </item>
        /// <item>
        /// <description>
        /// <see cref="ExecuteBLogic"/>  false łꍇA <see cref="WriteBLogicErrorResponse"/> ĂяoA
        /// ƖG[̃X|X݂s܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// ɗOꍇA <see cref="WriteSystemErrorResponse"/> ĂяoA
        /// VXeG[̃X|X݂s܂B
        /// </description>
        /// </item>
        /// </list>
        /// </remarks>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes")]
        public virtual void ProcessRequest(HttpContext context)
        {
            try
            {
                // wb_
                ValidateRequestHeader(context);

                // {fB
                ParseRequestBody(context);

                // ͒l
                if (!ValidateInputData(context))
                {
                    if (_log.IsDebugEnabled)
                    {
                        _log.Debug(Properties.Resources.D_VALIDATION_FAILED);
                    }

                    // ͒l؃G[X|X
                    WriteValidationErrorResponse(context);
                }
                else
                {
                    // rWlXWbNs
                    if (!ExecuteBLogic(context))
                    {

                        // ƖG[X|X
                        WriteBLogicErrorResponse(context);
                    }
                    else
                    {
                        // 탌X|X
                        WriteSuccessResponse(context);
                    }
                }
            }
            catch (Exception ex)
            {
                if (_log.IsWarnEnabled)
                {
                    _log.Warn(string.Format(Properties.Resources.W_CONTROLLER_EXCEPTION, this.GetType().FullName), ex);
                }

                // ׂĂ̗OɂăVXeG[X|Xɏ
                WriteSystemErrorResponse(context, ex);
            }
        }

        /// <summary>
        /// HTTP NGXg̃wb_ݒl؂܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// <see cref="ValidateContentType"/> ĂяoA
        /// <c>content-type</c> wb_ݒl؂܂B
        /// </remarks>
        /// <exception cref="InvalidRequestException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="context.Reqeust.ContentType"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="context.Reqeust.ContentType"/> 󕶎łB
        /// </item>
        /// <item>
        /// <paramref name="context.Reqeust.ContentType"/> ̃tH[}bgsłB
        /// </item>
        /// <item>
        /// <paramref name="context.Reqeust.ContentType"/> ̃fBA^Cv <seealso name="MediaTypeNames.Text.Xml"/> ƈv܂B
        /// </item>
        /// <item>
        /// <seealso name="MediaTypeNames.Text.Xml"/>  <c>text/xml</c> łꍇɁA 
        /// <paramref name="context.Reqeust.ContentType"/>  <c>charset</c>  <c>utf-8</c> ł͂܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual void ValidateRequestHeader(HttpContext context)
        {
            ValidateContentType(context.Request.ContentType, MediaTypeNames.Text.Xml);
        }

        /// <summary>
        /// content-type wb_̌؂s܂B
        /// </summary>
        /// <param name="requestContentType">content-type wb_ݒlB</param>
        /// <param name="expectedMediaType">҂郁fBA^CvB</param>
        /// <remarks>
        /// <paramref name="requestContentType"/>  ҂lł邩؂s܂B
        /// ҂lłȂꍇAOX[܂B
        /// </remarks>
        /// <exception cref="InvalidRequestException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="requestContentType"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="requestContentType"/> 󕶎łB
        /// </item>
        /// <item>
        /// <paramref name="requestContentType"/> ̃tH[}bgsłB
        /// </item>
        /// <item>
        /// <paramref name="requestContentType"/> ̃fBA^Cv 
        /// <paramref name="expectedMediaType"/> ƈv܂B
        /// </item>
        /// <item>
        /// <paramref name="expectedMediaType"/>  <c>text/xml</c> łꍇɁA
        /// <paramref name="requestContentType"/>  <c>charset</c>  <c>utf-8</c> ł͂܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual void ValidateContentType(string requestContentType, string expectedMediaType)
        {
            if (string.IsNullOrEmpty(requestContentType))
            {
                InvalidRequestException exception = new InvalidRequestException(string.Format(
                    Properties.Resources.E_REQUIRED_HEADER_EMPTY, "content-type"));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            ContentType ct = null;
            try
            {
                ct = new ContentType(requestContentType);
            }
            catch (FormatException ex)
            {
                InvalidRequestException exception = new InvalidRequestException(string.Format(
                Properties.Resources.E_INVALID_CONTENTTYPE_FORMAT, requestContentType), ex);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            if (!expectedMediaType.Equals(ct.MediaType, StringComparison.OrdinalIgnoreCase))
            {
                InvalidRequestException exception = new InvalidRequestException(string.Format(
                Properties.Resources.E_INVALID_CONTENTTYPE_MEDIATYPE, requestContentType, expectedMediaType));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            if (expectedMediaType.Equals(MediaTypeNames.Text.Xml, StringComparison.OrdinalIgnoreCase))
            {
                // MediaTypetext/xml̏ꍇcharsetUTF-8ł邩`FbNB
                if (!Encoding.UTF8.WebName.Equals(ct.CharSet, StringComparison.OrdinalIgnoreCase))
                {
                    InvalidRequestException exception = new InvalidRequestException(string.Format(
                        Properties.Resources.E_INVALID_CONTENTTYPE_CHARSET_UTF8, ct.CharSet));
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }
            }
        }

        /// <summary>
        /// HTTP NGXg̃{fB͂܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// <para>
        /// <see cref="HttpContext.Items"/>  <seealso cref="RequestControllerConstants.KEY_INPUT_DATASET_CLASS_TYPE"/> 
        /// rWlXWbNNX̓͂ƂĎw肳Ă <see cref="DataSet"/>  <see cref="Type"/> 擾܂B
        /// </para>
        /// <para>
        /// <see cref="CreateInputDataSet"/> ĂяoAw肳ꂽ <see cref="DataSet"/> 
        /// CX^X𐶐сANGXg̓̓Xg[e̓ǂݍ݂s܂B
        /// </para>
        /// <para>
        /// <see cref="HttpContext.Items"/>  <see cref="KEY_CONTEXT_ITEM_INPUTPARAM"/>  
        ///  <see cref="DataSet"/> i[܂B
        /// </para>
        /// </remarks>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="HttpContext.Items"/>  <seealso cref="RequestControllerConstants.KEY_INPUT_DATASET_CLASS_TYPE"/> 
        /// ݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <paramref name="HttpContext.Items"/>  <seealso cref="RequestControllerConstants.KEY_INPUT_DATASET_CLASS_TYPE"/>  
        /// <see cref="Type"/> ł͂܂B
        /// </item>
        /// <item>
        /// <paramref name="HttpContext.Items"/>  <seealso cref="RequestControllerConstants.KEY_INPUT_DATASET_CLASS_TYPE"/> Ɏw肳ꂽ^̃NX̃RXgN^słB
        /// </item>
        /// <item>
        /// <paramref name="HttpContext.Items"/>  <seealso cref="RequestControllerConstants.KEY_INPUT_DATASET_CLASS_TYPE"/> Ɏw肳ꂽ^̃NX <see cref="DataSet"/> 
        /// hNXł͂܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="InvalidRequestException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="context.Request.InputStream"/> ɐݒ肳Ăf[^XMLł͂܂B
        /// </item>
        /// <item>
        /// <paramref name="context.Request.InputStream"/> ɐݒ肳Ăf[^
        /// Ώۂ <see cref="DataSet"/> ̃XL[}ƈقȂĂ܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual void ParseRequestBody(HttpContext context)
        {
            Type dataSetType = context.Items[RequestControllerConstants.KEY_INPUT_DATASET_CLASS_TYPE] as Type;
            if (dataSetType == null)
            {
                // ̓f[^Zbg^Cvݒ̏ꍇ
                TerasolunaException exception = new TerasolunaException(Properties.Resources.E_EMPTY_INPUT_DATASET_TYPE);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            Stream inputStream = context.Request.InputStream;
            DataSet inputParam = CreateInputDataSet(dataSetType, inputStream);
            context.Items[KEY_CONTEXT_ITEM_INPUTPARAM] = inputParam;
        }

        /// <summary>
        /// NGXg̓̓Xg[ɁArWlXWbN̓͒lƂȂf[^Zbg𐶐܂B
        /// </summary>
        /// <param name="dataSetType"> <see cref="DataSet"/>  <see cref="Type"/> B</param>
        /// <param name="inputStream">HTTPNGXg̓̓Xg[B</param>
        /// <returns>ꂽ <see cref="DataSet"/> ̃CX^XB</returns>
        /// <remarks>
        /// <para>
        /// <paramref name="dataSetType"/>Ɏw肳ꂽ <see cref="Type"/> 
        /// CX^X𐶐A <paramref name="inputStream"/> eǂݍ݂܂B
        /// </para>
        /// <para>
        /// Ώۂ <see cref="DataSet"/> ɑ݂ȂJe[ȕ񂪃NGXg
        /// ̓Xg[ɑ݂ꍇA̒l͖܂B
        /// </para>
        /// </remarks>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="dataSetType"/> Ɏw肳ꂽNX̃RXgN^słB
        /// </item>
        /// <item>
        /// <paramref name="dataSetType"/> Ɏw肳ꂽNX <see cref="DataSet"/> 
        /// hNXł͂܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="InvalidRequestException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="inputStream"/> ɐݒ肳Ăf[^XMLł͂܂B
        /// </item>
        /// <item>
        /// <paramref name="inputStream"/> ɐݒ肳Ăf[^
        /// Ώۂ <see cref="DataSet"/> ̃XL[}ƈقȂĂ܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual DataSet CreateInputDataSet(Type dataSetType, Stream inputStream)
        {
            DataSet inputDs = null;

            try
            {
                inputDs = Activator.CreateInstance(dataSetType) as DataSet;
            }
            catch (MemberAccessException mae)
            {
                TerasolunaException exception = new TerasolunaException(string.Format(
                    Properties.Resources.E_INVALID_CONSTRUCTOR, dataSetType.FullName), mae);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            catch (TargetInvocationException tie)
            {
                TerasolunaException exception = new TerasolunaException(string.Format(
                    Properties.Resources.E_INVALID_CONSTRUCTOR, dataSetType.FullName), tie);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            if (inputDs == null)
            {
                TerasolunaException exception = new TerasolunaException(string.Format(
                    Properties.Resources.E_INVALID_BASE_CLASS, dataSetType.FullName, typeof(DataSet).FullName));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            try
            {
                inputDs.ReadXml(inputStream);
            }
            catch (XmlException ex)
            {
                InvalidRequestException exception = new InvalidRequestException(Properties.Resources.E_INVALID_REQUEST + ex.Message, ex);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            catch (FormatException fe)
            {
                InvalidRequestException exception = new InvalidRequestException(Properties.Resources.E_INVALID_REQUEST + fe.Message, fe);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            return inputDs;
        }

        /// <summary>
        /// ͒ľ؂s܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <returns>
        /// ،ʂG[łꍇ false AȊȌꍇ true ԋp܂B
        /// </returns>
        /// <remarks>
        /// <para>
        /// <see cref="HttpContext.Items"/>  
        /// <see cref="KEY_CONTEXT_ITEM_INPUTPARAM"/> 
        /// rWlXWbNNX̓͂ƂĎw肳Ă <see cref="DataSet"/>  
        /// <see cref="Type"/> ΏۂƂē͒ľ؂sA
        /// ،ʂł <see cref="ValidationResult"/> IuWFNg <see cref="HttpContext.Items"/>  
        /// <see cref="KEY_CONTEXT_ITEM_VALIDATION_RESULT"/> ֊i[܂B
        /// </para>
        /// <para>
        /// <see cref="HttpContext.Items"/>  
        /// <see cref="RequestControllerConstants.KEY_VALIDATION_FILE_PATH"/> Ɏw肳ꂽt@CXL[}ƂA 
        /// <see cref="ValidatorFactory"/> Ŏ擾 <see cref="IValidator"/> C^tF[XNX
        /// pČ؂s܂B
        /// ł́A<see cref="VabValidator"/> NXp܂B
        /// </para>
        /// <para>
        /// <see cref="HttpContext.Items"/>  <see cref="RequestControllerConstants.KEY_VALIDATION_FILE_PATH"/> ݒ̏ꍇ́A
        /// ͒l؂s킸A true ԋp܂B
        /// </para>
        /// <para>
        /// ͒l؂ <see cref="VabValidator"/> NXȊO𗘗p@́A 
        /// <see cref="ValidatorFactory.CreateValidator"/> ̐ݒQƂĂB 
        /// </para>
        /// </remarks>
        /// <exception cref="ArgumentException">
        /// ݒt@Cɒ`Ă <see cref="IValidator"/> NX͒ۃNXłB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <see cref="HttpContext.Items"/>  
        /// <see cref="RequestControllerConstants.KEY_VALIDATION_FILE_PATH"/> Ƀt@CpX̏𒴂
        /// ̕񂪐ݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <see cref="HttpContext.Items"/>  
        /// <see cref="RequestControllerConstants.KEY_VALIDATION_FILE_PATH"/> Ƀt@ĈƂ
        /// płȂݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <see cref="HttpContext.Items"/>  
        /// <see cref="RequestControllerConstants.KEY_VALIDATION_FILE_PATH"/> ɁAAvP[V[g
        /// z̃pXłȂlݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <see cref="HttpContext.Items"/>  
        /// <see cref="RequestControllerConstants.KEY_VALIDATION_FILE_PATH"/> ɁAw肳ꂽt@C
        /// ܂B
        /// </item>
        /// <item>
        /// <see cref="IValidator"/> 𐶐ł܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual bool ValidateInputData(HttpContext context)
        {
            string validationFilePath = context.Items[RequestControllerConstants.KEY_VALIDATION_FILE_PATH] as string;
            
            //ValidationInfovalidationFilePathݒ肳Ăꍇ̂݃`FbNs܂B
            if (validationFilePath != null)
            {
                // ΃pX΃pX֕ϊB
                string absolutePath = null;
                try
                {
                    absolutePath = context.Server.MapPath(context.Request.ApplicationPath + "\\" + VALIDATION_FILE_PATH_ROOT + "\\" + validationFilePath);
                }
                catch(HttpException he)
                {
                    TerasolunaException exception = new TerasolunaException(string.Format(
                        Properties.Resources.E_INVALID_VALIDATION_FILE_PATH, validationFilePath), he);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }

                if (!File.Exists(absolutePath))
                {
                    // ͒l؃t@CȂꍇȂǁA͒l؋@\TerasolunaExceptionX[邪A
                    // ΃pXbZ[WƂĐݒ肳ĂB
                    // ObZ[W̓NCAgɗĂ܂\邽߁AŃt@C݊mFA
                    // bZ[WuATerasolunaExceptionX[B
                    TerasolunaException exception = new TerasolunaException(string.Format(
                        Properties.Resources.E_VALIDATION_FILE_NOT_FOUND, absolutePath));
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }

                string ruleSet = context.Items[RequestControllerConstants.KEY_VALIDATION_RULESET] as string;
                if (string.IsNullOrEmpty(ruleSet))
                {
                    ruleSet = "Default";
                }

                DataSet inputDataSet = context.Items[KEY_CONTEXT_ITEM_INPUTPARAM] as DataSet;

                // validator̐E
                IValidator validator = ValidatorFactory.CreateValidator();
                validator.ValidationFilePath = absolutePath;
                validator.RuleSet = ruleSet;

                // ؂̎{
                ValidationResult result = validator.Validate(inputDataSet);
                
                if (!result.IsValid)
                {
                    context.Items[KEY_CONTEXT_ITEM_VALIDATION_RESULT] = result;
                    return false;
                }
            }
            return true;
        }

        /// <summary>
        /// ͒l؃G[̃X|X݂܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// <para>
        /// <see cref="WriteValidationErrorResponseHeader"/> ĂяoA͒l؃G[
        /// X|X̃wb_ݒ肵܂B
        /// </para>
        /// <para>
        /// <see cref="WriteValidationErrorResponseBody"/> ĂяoA͒l؃G[
        /// X|Xf[^ <see cref="HttpResponse.OutputStream"/> ɏ݂܂B
        /// </para>
        /// </remarks>
        protected virtual void WriteValidationErrorResponse(HttpContext context)
        {
            // X|Xwb_ݒ
            WriteValidationErrorResponseHeader(context.Response);

            // X|X{fB
            ValidationResult result = context.Items[KEY_CONTEXT_ITEM_VALIDATION_RESULT] as ValidationResult;
            WriteValidationErrorResponseBody(context.Response, result);
        }

        /// <summary>
        /// ͒l؃G[̃X|Xwb_ݒ肵܂B
        /// </summary>
        /// <param name="response">wb_̐ݒΏۂƂȂ <see cref="HttpResponse"/> B</param>
        /// <remarks>
        /// ̍ڂwb_ɐݒ肵܂B
        /// <list type="table">
        /// <listheader>
        /// <term>
        /// wb_
        /// </term>
        /// <description>
        /// ݒl
        /// </description>
        /// </listheader>
        /// <item>
        /// <term>
        /// content-type
        /// </term>
        /// <description>
        /// text/xml; charset=utf-8
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// exception
        /// </term>
        /// <description>
        /// validateException
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// Xe[^X
        /// </term>
        /// <description>
        /// OK
        /// </description>
        /// </item>
        /// </list>
        /// </remarks>
        protected virtual void WriteValidationErrorResponseHeader(HttpResponse response)
        {
            // content-type
            ContentType ct = new ContentType();
            ct.MediaType = MediaTypeNames.Text.Xml;
            ct.CharSet = Encoding.UTF8.WebName;
            response.ContentType = ct.ToString();
            // G[
            response.AddHeader(EXCEPTION_HEADER_NAME, EXCEPTION_VALIDATE);
            // Xe[^X
            response.StatusDescription = STATUS_DESCRIPTION;
        }

        /// <summary>
        /// ͒l؃G[̃X|Xf[^X|X{fBɏ݂܂B
        /// </summary>
        /// <param name="response">ݑΏۂƂȂ <see cref="HttpResponse"/>B</param>
        /// <param name="validationResult">͒l،ʃIuWFNgB</param>
        /// <remarks>
        /// <paramref name="validationResult"/> ͒l؃G[̃X|XXMLf[^쐬A
        /// <paramref name="response"/>  o̓Xg[ɏ݂܂B
        /// <para>ɂɎdtH[}bgXMLf[^쐬܂B</para>
        /// <code>
        /// <![CDATA[
        /// <errors>
        ///   <error>
        ///     <replace-values></replace-value>
        ///     <error-message></error-message>
        ///     <error-code></error-code>
        ///     <error-field></error-field>
        ///   </error>
        /// </errors>
        /// ]]>
        /// </code>
        /// <list type="table">
        /// <listheader>
        /// <term>
        /// vf
        /// </term>
        /// <description>
        /// 
        /// </description>
        /// </listheader>
        /// <item>
        /// <term>
        /// errors
        /// </term>
        /// <description>
        /// [gm[hłB
        /// Kݒ肳܂B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// error
        /// </term>
        /// <description>
        /// G[łBerrorsvf̒ɐݒ肳܂B
        /// <see cref="ValidationResult.Errors"/> ̌AJԂݒ肳܂B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// replace-values
        /// </term>
        /// <description>
        /// error-messagevf̐ݒlŒuĐݒ肳ꂽݒ肵܂B
        /// errorvf̒ɐݒ肳܂B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// error-message
        /// </term>
        /// <description>
        /// ͒l؃G[̃bZ[WłB
        /// errorvf̒1̂ݐݒ肳܂B
        /// <see cref="MessageInfo.Message"/> Ŏ擾lݒ肳܂B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// error-code
        /// </term>
        /// <description>
        /// ͒l؃G[̎ނ\ʎqw肵܂B
        /// errorvf̒1̂ݐݒ肳܂B
        /// <see cref="MessageInfo.Key"/> Ŏ擾lݒ肳܂B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// error-field
        /// </term>
        /// <description>
        /// ͒l؃G[ӏݒ肵܂B
        /// errorvf̒1̂ݐݒ肳܂B
        /// <see cref="ValidationMessageInfo.ErrorPath"/> Ŏ擾lݒ肳܂B
        /// </description>
        /// </item>
        /// </list>
        /// </remarks>
        protected virtual void WriteValidationErrorResponseBody(HttpResponse response, ValidationResult validationResult)
        {
            XmlDocument responseXmlDoc = CreateInitializeErrorDocument();

            XmlElement rootElement = responseXmlDoc.DocumentElement;
            IList<MessageInfo> errMessageList = validationResult.Errors;
            foreach (MessageInfo msgInfo in errMessageList)
            {
                ValidationMessageInfo validationMsgInfo = msgInfo as ValidationMessageInfo;

                XmlElement errElement = responseXmlDoc.CreateElement("error");
                XmlElement msgElement = responseXmlDoc.CreateElement("error-message");
                msgElement.InnerText = validationMsgInfo.Message;
                XmlElement codeElement = responseXmlDoc.CreateElement("error-code");
                codeElement.InnerText = validationMsgInfo.Key;
                XmlElement fieldElement = responseXmlDoc.CreateElement("error-field");
                fieldElement.InnerText = validationMsgInfo.ErrorPath;
                errElement.AppendChild(msgElement);
                errElement.AppendChild(codeElement);
                errElement.AppendChild(fieldElement);
                rootElement.AppendChild(errElement);
            }

            responseXmlDoc.Save(response.OutputStream);
        }

        /// <summary>
        /// rWlXWbNs܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁ARequestAResponseASessionA Server)
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <returns>
        /// rWlXWbNIꍇ true A
        /// ƖG[ꍇ false ԋp܂B
        /// </returns>
        /// <remarks>
        /// <para>
        /// <seealso cref="HttpContext.Items"/>  
        /// <seealso cref="RequestControllerConstants.KEY_BLOGIC_CLASS_TYPE"/> 擾A 
        /// <see cref="Type"/>  <see cref="IBLogic"/> C^tF[XNX̃CX^X
        /// <see cref="BLogicFactory"/> 𗘗pĐA
        /// CX^X <seealso cref="IBLogic.Execute"/> \bh
        /// <seealso cref="HttpContext.Items"/>  
        /// <seealso cref="RequestControllerConstants.KEY_BLOGIC_CLASS_TYPE"/> 
        /// 擾<see cref="DataSet"/> Ɏw肵Ďs܂B
        /// </para>
        /// <para>
        /// ԋpꂽrWlXWbNʃIuWFNg <see cref="BLogicResult"/> 
        /// <seealso cref="HttpContext.Items"/>  
        /// <seealso cref="KEY_CONTEXT_ITEM_BLOGIC_RESULT"/> Ɋi[܂B
        /// </para>
        /// </remarks>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <see cref="IBLogic"/> NX𐶐ł܂B
        /// </item>
        /// <item>
        /// <seealso cref="IBLogic.Execute"/> \bh̕ԋpl null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// \t@CǂݍނƂł܂B
        /// </item>
        /// <item>
        /// \t@CsłB
        /// </item>
        /// </list>
        /// </exception>
        protected virtual bool ExecuteBLogic(HttpContext context)
        {
            string requestName = context.Items[RequestControllerConstants.KEY_REQUEST_NAME] as string;
            IBLogic blogic = BLogicFactory.CreateBLogic(requestName);
            DataSet inputDs = context.Items[KEY_CONTEXT_ITEM_INPUTPARAM] as DataSet;

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_BEGIN_BLOGIC_FUNCTION, blogic.GetType().FullName));
            }

            BLogicParam blogicParam = new BLogicParam();
            blogicParam.ParamData = inputDs;
            BLogicResult result = blogic.Execute(blogicParam);

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_END_BLOGIC_FUNCTION, blogic.GetType().FullName));
            }

            if (result == null)
            {
                // ʂnull̏ꍇ͓dԂȂ̂ŗOƂB
                TerasolunaException exception = new TerasolunaException(Properties.Resources.E_EMPTY_BLOGIC_RESULT);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            context.Items[KEY_CONTEXT_ITEM_BLOGIC_RESULT] = result;

            if (result.Errors.Count > 0)
            {
                return false;
            }

            return true;
        }

        /// <summary>
        /// ƖG[̃X|X݂܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁ARequestAResponseASessionA Server)
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// <para>
        /// <see cref="WriteBLogicErrorResponseHeader"/>ĂяoAƖG[
        /// X|X̃wb_ݒ肵܂B
        /// </para>
        /// <para>
        /// <see cref="WriteBLogicErrorResponseBody"/>ĂяoAƖG[
        /// X|Xf[^ <see cref="HttpResponse.OutputStream"/> ɏ݂܂B
        /// </para>
        /// </remarks>
        protected virtual void WriteBLogicErrorResponse(HttpContext context)
        {
            BLogicResult result = context.Items[KEY_CONTEXT_ITEM_BLOGIC_RESULT] as BLogicResult;
            WriteBLogicErrorResponseHeader(context.Response, result.ResultString);
            WriteBLogicErrorResponseBody(context.Response, result);
        }

        /// <summary>
        /// ƖG[̃X|Xwb_ݒ肵܂B
        /// </summary>
        /// <param name="response">wb_̐ݒΏۂƂȂ <see cref="HttpResponse"/>B</param>
        /// <param name="errorType">G[ʁB</param>
        /// <remarks>
        /// ̍ڂwb_ɐݒ肵܂B
        /// <list type="table">
        /// <listheader>
        /// <term>
        /// wb_
        /// </term>
        /// <description>
        /// ݒl
        /// </description>
        /// </listheader>
        /// <item>
        /// <term>
        /// content-type
        /// </term>
        /// <description>
        /// text/xml; charset=utf-8
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// exception
        /// </term>
        /// <description>
        /// <paramref name="errorType"/> Ɏw肳ꂽlݒ肵܂B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// Xe[^X
        /// </term>
        /// <description>
        /// OK
        /// </description>
        /// </item>
        /// </list>
        /// </remarks>
        /// <exception cref="TerasolunaException">
        /// rWlXWbNŃG[ݒ肳Ă܂AResultStringɃG[ʂݒ肳Ă܂B
        /// </exception>
        protected virtual void WriteBLogicErrorResponseHeader(HttpResponse response, string errorType)
        {
            if (string.IsNullOrEmpty(errorType))
            {
                // ResultStringnull܂͋󕶎̏ꍇ͓dԂȂ̂ŗOƂB
                TerasolunaException exception = new TerasolunaException(Properties.Resources.E_NOT_FOUND_RESULT_STRING);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            // content-type
            ContentType ct = new ContentType();
            ct.MediaType = MediaTypeNames.Text.Xml;
            ct.CharSet = Encoding.UTF8.WebName;
            response.ContentType = ct.ToString();
            // G[
            response.AddHeader(EXCEPTION_HEADER_NAME, errorType);
            // Xe[^X
            response.StatusDescription = STATUS_DESCRIPTION;
        }

        /// <summary>
        /// ƖG[̃X|Xf[^X|X{fBɏ݂܂B
        /// </summary>
        /// <param name="response">ݑΏۂƂȂ <see cref="HttpResponse"/> B</param>
        /// <param name="result">rWlXWbNʃIuWFNgB</param>
        /// <remarks>
        /// <paramref name="result"/> ƖG[̃X|X XML f[^쐬A
        /// <paramref name="response"/>  o̓Xg[ɏ݂܂B
        /// <para>ɂɎdtH[}bg XML f[^쐬܂B</para>
        /// <code>
        /// <![CDATA[
        /// <errors>
        ///   <error>
        ///     <replace-values></replace-value>
        ///     <error-message></error-message>
        ///     <error-code></error-code>
        ///   </error>
        /// </errors>
        /// ]]>
        /// </code>
        /// <list type="table">
        /// <listheader>
        /// <term>
        /// vf
        /// </term>
        /// <description>
        /// 
        /// </description>
        /// </listheader>
        /// <item>
        /// <term>
        /// errors
        /// </term>
        /// <description>
        /// [gm[hłB
        /// Kݒ肳܂B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// error
        /// </term>
        /// <description>
        /// G[łBerrors vf̒ɐݒ肳܂B
        /// <see cref="BLogicResult.Errors"/> ̌AJԂݒ肳܂B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// error-message
        /// </term>
        /// <description>
        /// ƖG[̃bZ[WłB
        /// error vf̒1̂ݐݒ肳܂B
        /// <see cref="MessageInfo.Message"/> Ŏ擾lݒ肳܂B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// error-code
        /// </term>
        /// <description>
        /// ƖG[̎ނ\ʎqw肵܂B
        /// errorvf̒1̂ݐݒ肳܂B
        /// <see cref="MessageInfo.Key"/> Ŏ擾lݒ肳܂B
        /// </description>
        /// </item>
        /// </list>
        /// </remarks>
        protected virtual void WriteBLogicErrorResponseBody(HttpResponse response, BLogicResult result)
        {
            XmlDocument responseXmlDoc = CreateInitializeErrorDocument();
            XmlElement rootElement = responseXmlDoc.DocumentElement;
            IList<MessageInfo> errMessageList = result.Errors;
            foreach (MessageInfo msgInfo in errMessageList)
            {
                XmlElement errElement = responseXmlDoc.CreateElement("error");
                XmlElement msgElement = responseXmlDoc.CreateElement("error-message");
                msgElement.InnerText = msgInfo.Message;
                XmlElement codeElement = responseXmlDoc.CreateElement("error-code");
                codeElement.InnerText = msgInfo.Key;
                errElement.AppendChild(msgElement);
                errElement.AppendChild(codeElement);
                rootElement.AppendChild(errElement);
            }

            responseXmlDoc.Save(response.OutputStream);
        }

        /// <summary>
        /// ĨX|X݂܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁ARequestAResponseASessionA Server)
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// <para>
        /// <see cref="WriteSuccessXmlResponseHeader"/>ĂяoAI
        /// X|X̃wb_ݒ肵܂B
        /// </para>
        /// <para>
        /// <see cref="WriteSuccessXmlResponseBody"/>ĂяoAI
        /// X|Xf[^ <see cref="HttpResponse.OutputStream"/> ɏ݂܂B
        /// </para>
        /// </remarks>
        /// <exception cref="TerasolunaException">
        /// <see cref="HttpContext.Items"/>  <see cref="KEY_CONTEXT_ITEM_BLOGIC_RESULT"/> ɐݒ肳ꂽA 
        /// <see cref="BLogicResult.ResultData"/>  null QƂłB
        /// </exception>
        protected virtual void WriteSuccessResponse(HttpContext context)
        {
            // X|Xf[^̐ݒmFB
            BLogicResult result = context.Items[KEY_CONTEXT_ITEM_BLOGIC_RESULT] as BLogicResult;
            if (result.ResultData == null)
            {
                TerasolunaException exception = new TerasolunaException(string.Format(
                    Properties.Resources.E_EMPTY_RESULT_DATA, "ResultData"));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            // X|Xwb_ݒ
            WriteSuccessXmlResponseHeader(context.Response);

            // X|X{fB
            WriteSuccessXmlResponseBody(context.Response, result.ResultData);            
        }

        /// <summary>
        /// X|XɐĨwb_ݒ肵܂B
        /// </summary>
        /// <param name="response">wb_̐ݒΏۂƂȂ <see cref="HttpResponse"/> B</param>
        /// <remarks>
        /// ̍ڂwb_ɐݒ肵܂B
        /// <list type="table">
        /// <listheader>
        /// <term>
        /// wb_
        /// </term>
        /// <description>
        /// ݒl
        /// </description>
        /// </listheader>
        /// <item>
        /// <term>
        /// content-type
        /// </term>
        /// <description>
        /// text/xml; charset=utf-8
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// Xe[^X
        /// </term>
        /// <description>
        /// OK
        /// </description>
        /// </item>
        /// </list>
        /// </remarks>
        /// <exception cref="HttpException">
        /// HTTP wb_[MꂽɁA StatusDescription ݒ肳Ă܂B
        /// </exception>
        protected virtual void WriteSuccessXmlResponseHeader(HttpResponse response)
        {
            // content-type
            ContentType ct = new ContentType();
            ct.MediaType = MediaTypeNames.Text.Xml;
            ct.CharSet = Encoding.UTF8.WebName;
            response.ContentType = ct.ToString();
            // Xe[^X
            response.StatusDescription = STATUS_DESCRIPTION;
        }

        /// <summary>
        /// X|X̏o̓Xg[ɐI XML dݒ肵܂B
        /// </summary>
        /// <param name="response">ݑΏۂƂȂ <see cref="HttpResponse"/> B</param>
        /// <param name="resultDataSet">rWlXWbNԋpꂽʃf[^B</param>
        /// <remarks>
        /// <para>
        /// <paramref name="resultDataSet"/> ̃f[^ XML tH[}bgŁA 
        /// <paramref name="response"/>  o̓Xg[ɏ݂܂B
        /// </para>
        /// </remarks>
        protected virtual void WriteSuccessXmlResponseBody(HttpResponse response, DataSet resultDataSet)
        {
            resultDataSet.WriteXml(response.OutputStream);
        }

        /// <summary>
        /// VXeG[̃X|X݂̏s܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Reques tA Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <param name="ex">OIuWFNgB</param>
        /// <remarks>
        /// <para>
        /// <see cref="WriteSystemErrorResponseHeader"/> ĂяoAVXeG[
        /// X|X̃wb_ݒ肵܂B
        /// </para>
        /// <para>
        /// <see cref="WriteSystemErrorResponseBody"/> ĂяoAVXeG[
        /// X|Xf[^ <see cref="HttpResponse.OutputStream"/> ɏ݂܂B
        /// </para>
        /// </remarks>
        protected virtual void WriteSystemErrorResponse(HttpContext context, System.Exception ex)
        {
            WriteSystemErrorResponseHeader(context.Response);
            WriteSystemErrorResponseBody(context.Response, ex);
        }

        /// <summary>
        /// VXeG[̃X|Xwb_݂̏s܂B
        /// </summary>
        /// <param name="response">wb_̐ݒΏۂƂȂ <see cref="HttpResponse"/> B</param>
        /// <remarks>
        /// ̍ڂwb_ɐݒ肵܂B
        /// <list type="table">
        /// <listheader>
        /// <term>
        /// wb_
        /// </term>
        /// <description>
        /// ݒl
        /// </description>
        /// </listheader>
        /// <item>
        /// <term>
        /// content-type
        /// </term>
        /// <description>
        /// text/xml; charset=utf-8
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// exception
        /// </term>
        /// <description>
        /// exception
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// Xe[^X
        /// </term>
        /// <description>
        /// OK
        /// </description>
        /// </item>
        /// </list>
        /// </remarks>
        protected virtual void WriteSystemErrorResponseHeader(HttpResponse response)
        {
            // content-type
            ContentType ct = new ContentType();
            ct.MediaType = MediaTypeNames.Text.Xml;
            ct.CharSet = Encoding.UTF8.WebName;
            response.ContentType = ct.ToString();
            // G[
            response.AddHeader(EXCEPTION_HEADER_NAME, EXCEPTION_SYSTEM);
            // Xe[^X
            response.StatusDescription = STATUS_DESCRIPTION;
        }

        /// <summary>
        /// VXeG[̃X|X{fB݂̏s܂B
        /// </summary>
        /// <param name="response">ݑΏۂƂȂ <see cref="HttpResponse"/> B</param>
        /// <param name="ex">OIuWFNgB</param>
        /// <remarks>
        /// <paramref name="ex"/> VXeG[̃X|X XML f[^쐬A
        /// <paramref name="response"/>  o̓Xg[ɏ݂܂B
        /// <para>ɂɎdtH[}bg XML f[^쐬܂B</para>
        /// <code>
        /// <![CDATA[
        /// <errors>
        ///   <error>
        ///     <error-message></error-message>
        ///     <error-code></error-code>
        ///   </error>
        /// </errors>
        /// ]]>
        /// </code>
        /// <list type="table">
        /// <listheader>
        /// <term>
        /// vf
        /// </term>
        /// <description>
        /// 
        /// </description>
        /// </listheader>
        /// <item>
        /// <term>
        /// errors
        /// </term>
        /// <description>
        /// [gm[hłB
        /// Kݒ肳܂B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// error
        /// </term>
        /// <description>
        /// G[łBerrorsvf̒ɐݒ肳܂B
        /// <see cref="BLogicResult.Errors"/> ̌AJԂݒ肳܂B
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// error-message
        /// </term>
        /// <description>
        /// VXeG[̃bZ[WłB
        /// errorvf̒1̂ݐݒ肳܂B
        /// <see cref="Exception.Message"/> Ŏ擾lݒ肳܂B
        /// <para>
        /// AOR[h擾 <see cref="ConfigurationErrorsException"/> ꍇ͕⑫A
        /// ⑫O <see cref="Exception.Message"/> ݒ肳܂B
        /// </para>
        /// </description>
        /// </item>
        /// <item>
        /// <term>
        /// error-code
        /// </term>
        /// <description>
        /// <para>G[̎ނ\ʎqw肵܂B</para>
        /// <para>̗vf́Aerrorvf̒1̂ݐݒ肳܂B</para>
        /// <para>ݒĺAOR[hݒt@Cɐݒ肳Ă <paramref name="ex"/> Ɏw肳ꂽOɊY
        /// OR[hݒ肳܂B</para>
        /// <para>ݒ肪݂ȂA擾ɎɗOꍇ͊lƂāA
        /// <see cref="UNKNOWN_EXCEPTION_ERROR_CODE"/> ݒ肵܂B</para>
        /// </description>
        /// </item>
        /// </list>
        /// </remarks>
        protected virtual void WriteSystemErrorResponseBody(HttpResponse response, Exception ex)
        {
            Exception targetEx = ex;

            // OR[h擾
            string errCode = null;
            try
            {
                errCode = ExceptionCodeConfiguration.GetExceptionCode(ex);
            }
            catch (ConfigurationErrorsException cee)
            {
                if (_log.IsWarnEnabled)
                {
                    _log.Warn(Properties.Resources.W_CONTROLLER_ERROR_CODE_NOT_FOUND, cee);
                }

                // OR[hݒ肪sȏꍇ͐ݒt@CsO
                // ΏۂɒuB
                targetEx = cee;
            }
            if (errCode == null)
            {
                // ΏۗÕG[R[hݒłꍇ
                // OsG[R[hݒ肷B
                errCode = UNKNOWN_EXCEPTION_ERROR_CODE;
            }

            XmlDocument responseXmlDoc = CreateInitializeErrorDocument();
            XmlElement rootElement = responseXmlDoc.DocumentElement;
            XmlElement errElement = responseXmlDoc.CreateElement("error");
            XmlElement msgElement = responseXmlDoc.CreateElement("error-message");
            msgElement.InnerText = targetEx.Message;
            XmlElement codeElement = responseXmlDoc.CreateElement("error-code");
            codeElement.InnerText = errCode;
            errElement.AppendChild(msgElement);
            errElement.AppendChild(codeElement);
            rootElement.AppendChild(errElement);

            responseXmlDoc.Save(response.OutputStream);
        }

        /// <summary>
        /// ُȈꂽXmlDocument𐶐܂B
        /// </summary>
        /// <returns> <see cref="XmlDocument"/> B</returns>
        /// <remarks>
        /// G[Iɋʂ̃[gm[hƂėp &lt;errors&gt; ݒ肵 <see cref="XmlDocument"/> 𐶐܂B
        /// </remarks>
        protected virtual XmlDocument CreateInitializeErrorDocument()
        {
            XmlDocument responseXmlDoc = new XmlDocument();
            responseXmlDoc.LoadXml("<errors></errors>");
            return responseXmlDoc;
        }
    } 
}
