// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.BLogic
{
    /// <summary>
    /// _E[h𔺂rWlXWbNԋpi[NXłB
    /// </summary>
    public class FileDownloadBLogicResult : BLogicResult
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(FileDownloadBLogicResult));

        /// <summary>
        /// _E[hΏۂ̃t@CłB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private FileInfo _downloadFileInfo = null;

        /// <summary>
        /// _E[hf[^łB
        /// </summary>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        private ReadOnlyCollection<byte> _downloadData = null;

        /// <summary>
        /// t@C擾܂B
        /// </summary>
        /// <value>
        /// t@CB
        /// </value>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        public FileInfo DownloadFileInfo
        {
            get
            {
                return _downloadFileInfo;
            }
        }

        /// <summary>
        /// _E[hf[^擾܂B
        /// </summary>
        /// <value>
        /// _E[hf[^B
        /// </value>
        /// <remarks>
        /// ftHg̒ĺA null łB
        /// </remarks>
        public ReadOnlyCollection<byte> DownloadData
        {
            get
            {
                return _downloadData;
            }
        }

        /// <summary>
        /// <see cref="FileDownloadBLogicResult"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        protected FileDownloadBLogicResult()
        {
        }

        /// <summary>
        /// t@CgpāA<see cref="FileDownloadBLogicResult"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="fileInfo">
        /// _E[hΏۂƂȂt@C̃pX񂪊i[ꂽ <see cref="FileInfo"/> IuWFNgB
        /// </param>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="fileInfo"/>  null QƂłB
        /// </exception>
        public FileDownloadBLogicResult(FileInfo fileInfo)
        {
            if (fileInfo == null)
            {
                ArgumentNullException exception = new ArgumentNullException("fileInfo");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "fileInfo"), exception);
                }
                throw exception;
            }
            _downloadFileInfo = fileInfo;
        }

        /// <summary>
        /// t@Cƃ_E[hf[^gpāA<see cref="FileDownloadBLogicResult"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="fileInfo">
        /// _E[hf[^ɑΉtt@Ci[ꂽ@<see cref="FileInfo"/>@IuWFNgB
        /// </param>
        /// <param name="data">
        /// _E[hf[^{́B
        /// </param>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="fileInfo"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="data"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        public FileDownloadBLogicResult(FileInfo fileInfo, byte[] data)
            : this(fileInfo)
        {
            if (data == null)
            {
                ArgumentNullException exception = new ArgumentNullException("data");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "data"), exception);
                }
                throw exception;
            }
            _downloadData = new ReadOnlyCollection<byte>(data);
        }

        /// <summary>
        /// sʕƃG[bZ[WXggpāA<see cref="FileDownloadBLogicResult"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="resultStr">ݒ肷rWlXWbNsʕB</param>
        /// <param name="errorMsgList">ݒ肷G[bZ[W̃XgB</param>
        /// <remarks>
        /// ̒lBLogicResult̃oϐ֐ݒ肵܂B
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="resultStr"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="errorMsgList"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        public FileDownloadBLogicResult(string resultStr, IList<MessageInfo> errorMsgList) 
        {
            if (resultStr == null)
            {
                ArgumentNullException exception = new ArgumentNullException("resultStr");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "resultStr"), exception);
                }
                throw exception;
            }

            ResultString = resultStr;

            if (errorMsgList == null)
            {
                ArgumentNullException exception = new ArgumentNullException("errorMsgList");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "errorMsgList"), exception);
                }
                throw exception;
            }

            foreach (MessageInfo message in errorMsgList)
            {
                Errors.Add(message);
            }
        }

    }
}
