﻿// 次のコードは Microsoft Visual Studio 2005 によって生成されました。
// テストの所有者は、各テストの正当性を確認しなければなりません。
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using System.Data;
using TERASOLUNA.Fw.Common.Validation;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.CommonUT.Validation.ValidationUtilsTestData;
using TERASOLUNA.Fw.Common;
namespace TERASOLUNA.Fw.CommonUT.Validation
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Validation.ValidationUtils のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Validation.ValidationUtils 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class ValidationUtilsTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// GetLastPath (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数xpathがnullの場合、空文字列が返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLastPathTest01()
        {
            string xpath = null;

            string expected = string.Empty;
            string actual;

            actual = ValidationUtils.GetLastPath(xpath);

            Assert.AreEqual(expected, actual);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetLastPath (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数xpathが空文字列の場合、空文字列が返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLastPathTest02()
        {
            string xpath = string.Empty;

            string expected = string.Empty;
            string actual;

            actual = ValidationUtils.GetLastPath(xpath);

            Assert.AreEqual(expected, actual);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetLastPath (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数xpathが1階層のXPathの場合、xpathが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLastPathTest03()
        {
            string xpath = "aaa";

            string expected = "aaa";
            string actual;

            actual = ValidationUtils.GetLastPath(xpath);

            Assert.AreEqual(expected, actual);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetLastPath (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数xpathが3階層のXPathの場合、最後の要素名が返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLastPathTest04()
        {
            string xpath = "aaa/bbb/ccc";

            string expected = "ccc";
            string actual;

            actual = ValidationUtils.GetLastPath(xpath);

            Assert.AreEqual(expected, actual);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetLastPath (string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数xpathが3階層で要素番号が指定されているXPathの場合、
        /// 最後の要素名が返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetLastPathTest05()
        {
            string xpath = "aaa[1]/bbb[2]/ccc";

            string expected = "ccc";
            string actual;

            actual = ValidationUtils.GetLastPath(xpath);

            Assert.AreEqual(expected, actual);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest01()
        {
            DataSet dataSet = null;
            string xpath = string.Empty;

            IList<DataRow> actual = null;
            try
            {
                actual = ValidationUtils.GetRowList(dataSet, xpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("dataSet", e.ParamName);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ValidationUtils), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "dataSet"));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathがnullの場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest02()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = null;

            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathが空文字列の場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest03()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = string.Empty;

            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest04()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.AAA[0];
            DataRow expectedRow2 = dataSet.AAA[1];
            DataRow expectedRow3 = dataSet.AAA[2];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(3, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.IsTrue(actual.Contains(expectedRow2));
            Assert.IsTrue(actual.Contains(expectedRow3));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest05()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA/Ca1";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.AAA[0];
            DataRow expectedRow2 = dataSet.AAA[1];
            DataRow expectedRow3 = dataSet.AAA[2];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(3, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.IsTrue(actual.Contains(expectedRow2));
            Assert.IsTrue(actual.Contains(expectedRow3));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest06()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA/BBB";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest07()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA/BBB/Cb1";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest08()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.AAA[0];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(1, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest09()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/Ca1";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.AAA[0];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(1, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest10()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest11()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB/Cb1";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest12()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB[1]";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest13()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB[1]/Cb1";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest14()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA/Cb1";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest15()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA/BBB/Ca1";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest16()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "CCC";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest17()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[4]";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest18()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB[4]";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest19()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB[1]/Ca1";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで不正な要素番号を指定した場合、FormatExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest20()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[-1]";

            // 実行
            IList<DataRow> actual = null;
            try
            {
                actual = ValidationUtils.GetRowList(dataSet, xpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (FormatException e)
            {
                Assert.AreEqual(MessageManager.GetMessage("E_VALIDATION_XPATH_NEGATIVE_INDEX", xpath), e.Message);
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ValidationUtils), typeof(FormatException), "E_VALIDATION_XPATH_NEGATIVE_INDEX", xpath));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで不正な要素番号を指定した場合、FormatExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest21()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[0]";

            // 実行
            IList<DataRow> actual = null;
            try
            {
                actual = ValidationUtils.GetRowList(dataSet, xpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (FormatException e)
            {
                Assert.AreEqual(MessageManager.GetMessage("E_VALIDATION_XPATH_NEGATIVE_INDEX", xpath), e.Message);
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ValidationUtils), typeof(FormatException), "E_VALIDATION_XPATH_NEGATIVE_INDEX", xpath));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで不正な要素番号を指定した場合、FormatExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest22()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[a]";

            // 実行
            IList<DataRow> actual = null;
            try
            {
                actual = ValidationUtils.GetRowList(dataSet, xpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (FormatException e)
            {
                Assert.AreEqual(MessageManager.GetMessage("E_VALIDATION_XPATH_INVALID_INDEX", xpath), e.Message);
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ValidationUtils), typeof(FormatException), "E_VALIDATION_XPATH_INVALID_INDEX", xpath));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest23()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest24()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA1]";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest25()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "/AAA";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest26()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.AAA[0];
            DataRow expectedRow2 = dataSet.AAA[1];
            DataRow expectedRow3 = dataSet.AAA[2];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(3, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.IsTrue(actual.Contains(expectedRow2));
            Assert.IsTrue(actual.Contains(expectedRow3));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest27()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA/Ca1";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.AAA[0];
            DataRow expectedRow2 = dataSet.AAA[1];
            DataRow expectedRow3 = dataSet.AAA[2];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(3, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.IsTrue(actual.Contains(expectedRow2));
            Assert.IsTrue(actual.Contains(expectedRow3));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest28()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA/BBB";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.BBB[0];
            DataRow expectedRow2 = dataSet.BBB[1];
            DataRow expectedRow3 = dataSet.BBB[2];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(3, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.IsTrue(actual.Contains(expectedRow2));
            Assert.IsTrue(actual.Contains(expectedRow3));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest29()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA/BBB/Cb1";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.BBB[0];
            DataRow expectedRow2 = dataSet.BBB[1];
            DataRow expectedRow3 = dataSet.BBB[2];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(3, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.IsTrue(actual.Contains(expectedRow2));
            Assert.IsTrue(actual.Contains(expectedRow3));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest30()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.AAA[0];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(1, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest31()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/Ca1";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.AAA[0];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(1, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest32()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.BBB[0];
            DataRow expectedRow2 = dataSet.BBB[1];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(2, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.IsTrue(actual.Contains(expectedRow2));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest33()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB/Cb1";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.BBB[0];
            DataRow expectedRow2 = dataSet.BBB[1];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(2, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.IsTrue(actual.Contains(expectedRow2));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest34()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB[2]";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.BBB[1];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(1, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスのDataRowを格納したリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest35()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB[2]/Cb1";

            // 期待値の取得
            DataRow expectedRow1 = dataSet.BBB[1];

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(1, actual.Count);
            Assert.IsTrue(actual.Contains(expectedRow1));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest36()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA/Cb1";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest37()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA/BBB/Ca1";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest38()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "CCC";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest39()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[4]";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest40()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB[3]";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っているデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest41()
        {
            // 準備
            ValidationUtilsTest_RelationDataSet dataSet = new ValidationUtilsTest_RelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B12", "B13");
            dataSet.BBB.AddBBBRow(dataSet.AAA[0], "B22", "B23");
            dataSet.BBB.AddBBBRow(dataSet.AAA[1], "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[1]/BBB[1]/Ca1";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで指定したパスがない場合、要素数0のリストが返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest42()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA]1[";

            // 実行
            IList<DataRow> actual = ValidationUtils.GetRowList(dataSet, xpath);

            // 確認
            Assert.AreEqual(0, actual.Count);
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetRowList (DataSet, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数dataSetがリレーションを張っていないデータセットで、
        /// 引数xpathで不正な要素番号を指定した場合、FormatExceptionがスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetRowListTest43()
        {
            // 準備
            ValidationUtilsTest_NoRelationDataSet dataSet = new ValidationUtilsTest_NoRelationDataSet();
            dataSet.AAA.AddAAARow("A11", "A12", "A13");
            dataSet.AAA.AddAAARow("A21", "A22", "A23");
            dataSet.AAA.AddAAARow("A31", "A32", "A33");
            dataSet.BBB.AddBBBRow("B11", "B12", "B13");
            dataSet.BBB.AddBBBRow("B21", "B22", "B23");
            dataSet.BBB.AddBBBRow("B31", "B32", "B33");
            dataSet.AcceptChanges();
            string xpath = "AAA[]";

            // 実行
            IList<DataRow> actual = null;
            try
            {
                actual = ValidationUtils.GetRowList(dataSet, xpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (FormatException e)
            {
                Assert.AreEqual(MessageManager.GetMessage("E_VALIDATION_XPATH_INVALID_INDEX", xpath), e.Message);
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ValidationUtils), typeof(FormatException), "E_VALIDATION_XPATH_INVALID_INDEX", xpath));
        }

        /// <summary>
        /// GetFollowingPath(string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数xpathがnullの場合、空文字列が返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetFollowingPathTest01()
        {
            // 準備
            string expected = string.Empty;
            // テスト対象メソッドの引数設定
            string xpath = null;

            // 実行
            string actual = ValidationUtils.GetFollowingPath(xpath);

            //検証
            Assert.AreEqual(expected, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetFollowingPath(string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数xpathが空文字列の場合、空文字列が返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetFollowingPathTest02()
        {
            // 準備
            string expected = string.Empty;
            // テスト対象メソッドの引数設定
            string xpath = string.Empty;

            // 実行
            string actual = ValidationUtils.GetFollowingPath(xpath);

            //検証
            Assert.AreEqual(expected, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }

        /// <summary>
        /// GetIndex(string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数xpathがnullの場合、0が返却されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void GetIndexTest01()
        {
            // 準備
            int expected = 0;
            // テスト対象メソッドの引数設定
            string xpath = null;

            // 実行
            int actual = ValidationUtils.GetIndex(xpath);

            //検証
            Assert.AreEqual(expected, actual);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationUtils), LogLevel.INFO));
        }
    }
}
