// <쌠>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Logging.TraceSourceLog;
using TERASOLUNA.Fw.Common.Logging;
using System.Configuration;
namespace TERASOLUNA.Fw.CommonUT.Logging.TraceSourceLog
{
    /// <summary>
    /// TraceSourceLogFactory ̃eXgNXłB
    /// </summary>
    [TestClass()]
    public class TraceSourceLogFactoryTest
    {
        private TestContext testContextInstance;

        /// <summary>
        /// ݂̃eXg̎sɂĂ̏񂨂ы@\
        /// 񋟂eXg ReLXg擾܂͐ݒ肵܂B
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region ǉ̃eXg
        // 
        //eXg쐬ƂɁA̒ǉgp邱Ƃł܂:
        //
        //NX̍ŏ̃eXgsOɃR[hsɂ́AClassInitialize gp
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //NXׂ̂ẴeXgsɃR[hsɂ́AClassCleanup gp
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //eeXgsOɃR[hsɂ́ATestInitialize gp
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = 
                "TERASOLUNA.Fw.Common.Logging.TraceSourceLog.TraceSourceLogFactory, TERASOLUNA.Fw.Common";
        }
        //
        //eeXgsɃR[hsɂ́ATestCleanup gp
        //
        [TestCleanup()]
        public void MyTestCleanup()
        {
            ConfigurationManager.AppSettings["LogFactoryTypeName"] = 
                "TERASOLUNA.Fw.Utlib.Logging.LogUTFactory, TERASOLUNA.Fw.Utlib";
            TERASOLUNA.Fw.Utlib.Logging.LogUTFactory logFactory = new TERASOLUNA.Fw.Utlib.Logging.LogUTFactory();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory; 
        }
        
        #endregion

        #region GetLogger<T>(string, params object[]) ̃eXg

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  null ̏ꍇA
        /// ArgumentNullException X[邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest01()
        {
            // 
            string className = null;
            object[] args = { "sourceName" };

            try
            {
                // {
                ILog target = LogFactory.GetLogger<ILog>(className, args);
                Assert.Fail("BĂ͂ȂR[hłB");
            }
            catch (ArgumentNullException e)
            {
                // mF
                Assert.AreEqual("l Null ɂ邱Ƃ͂ł܂B\r\np[^: className", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("BĂ͂ȂR[hłB" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎̏ꍇA
        /// ArgumentException X[邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest02()
        {
            // 
            string className = string.Empty;
            object[] args = { "sourceName" };

            try
            {
                // {
                ILog target = LogFactory.GetLogger<ILog>(className, args);
                Assert.Fail("BĂ͂ȂR[hłB");
            }
            catch (ArgumentException e)
            {
                // mF
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(" \"className\" ̒l󕶎ɂ邱Ƃ͂ł܂B", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("BĂ͂ȂR[hłB" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// className  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 0 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest03()
        {
            // 
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();        
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs  null ̏ꍇA
        /// ArgumentNullException X[邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest04()
        {
            // 
            string className = "className";

            try
            {
                // {
                ILog target = LogFactory.GetLogger<ILog>(className, null);
                Assert.Fail("BĂ͂ȂR[hłB");
            }
            catch (ArgumentNullException e)
            {
                // mF
                Assert.AreEqual("l Null ɂ邱Ƃ͂ł܂B\r\np[^: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("BĂ͂ȂR[hłB" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 0 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest05()
        {
            // 
            string className = "className";

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 1  args[0]=null ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest06()
        {
            // 
            string className = "className";
            object[] args = { null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 1  args[0] ̕ϊ
        /// 񒷂 0 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest07()
        {
            // 
            string className = "className";
            object[] args = { string.Empty };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 3 
        /// args[0]=args[1]=args[2]=null ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest08()
        {
            // 
            string className = "className";
            object[] args = { null, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 3  args[0] ̕ϊ
        /// 񒷂 0Aargs[1]=args[2]=null ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest09()
        {
            // 
            string className = "className";
            object[] args = { string.Empty, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 3  args[0] ̕ϊ
        /// 񒷂 0 łȂAargs[1]=args[2]=null ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest10()
        {
            // 
            string className = "className";
            object[] args = { "sourceName", null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// className  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 1 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest11()
        {
            // 
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01","sourceName01"));
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(2, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// className  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 3 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest12()
        {
            // 
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01","sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("className02","sourceName02"));
            logFactory.LoggersStub.Add("dummyKey03", new TraceSourceLogger("className03","sourceName03"));
            
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(4, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// className  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 1 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest13()
        {
            // 
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            
            logFactory.LoggersStub.Clear();
            TraceSourceLogger chacheLogger = new TraceSourceLogger("className","sourceName");
            logFactory.LoggersStub.Add("className:sourceName", chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreSame(chacheLogger, logger);
            Assert.IsNull(logFactory._className);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// className  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 3 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericStringObjectTest14()
        {
            // 
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("className02", "sourceName02"));
            TraceSourceLogger chacheLogger = new TraceSourceLogger("className", "sourceName");
            logFactory.LoggersStub.Add("className:sourceName", chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(3, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreSame(chacheLogger, logger);
            Assert.IsNull(logFactory._className);
            Assert.IsNull(logFactory._sourceName);
        }

        #endregion

        #region GetLogger<T>(Type, params object[]) ̃eXg

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  null ̏ꍇA
        /// ArgumentNullException X[邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest01()
        {
            // 
            Type classType = null;
            object[] args = { "sourceName" };

            try
            {
                // {
                ILog target = LogFactory.GetLogger<ILog>(classType, args);
                Assert.Fail("BĂ͂ȂR[hłB");
            }
            catch (ArgumentNullException e)
            {
                // mF
                Assert.AreEqual("l Null ɂ邱Ƃ͂ł܂B\r\np[^: classType", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("BĂ͂ȂR[hłB" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// classType  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 0 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest02()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs  null ̏ꍇA
        /// ArgumentNullException X[邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest03()
        {
            // 
            Type classType = typeof(Object);

            try
            {
                // {
                ILog target = LogFactory.GetLogger<ILog>(classType, null);
                Assert.Fail("BĂ͂ȂR[hłB");
            }
            catch (ArgumentNullException e)
            {
                // mF
                Assert.AreEqual("l Null ɂ邱Ƃ͂ł܂B\r\np[^: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("BĂ͂ȂR[hłB" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 0 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest04()
        {
            // 
            Type classType = typeof(Object);

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 1  args[0]=null ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest05()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 1  args[0] ̕ϊ
        /// 񒷂 0 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest06()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { string.Empty };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 3 
        /// args[0]=args[1]=args[2]=null ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest07()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { null, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 3  args[0] ̕ϊ
        /// 񒷂 0Aargs[1]=args[2]=null ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest08()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { string.Empty, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 3  args[0] ̕ϊ
        /// 񒷂 0 łȂAargs[1]=args[2]=null ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest09()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName", null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// classType  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 1 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest10()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(2, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// classType  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 3 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest11()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("classType02", "sourceName02"));
            logFactory.LoggersStub.Add("dummyKey03", new TraceSourceLogger("classType03", "sourceName03"));

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(4, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// classType  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 1 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest12()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            TraceSourceLogger chacheLogger = new TraceSourceLogger(typeof(Object), "sourceName");
            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            logFactory.LoggersStub.Add(key, chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(chacheLogger, logger);

            Assert.IsNull(logFactory._classType);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger&lt;T&gt; (Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// classType  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 3 ̏ꍇA
        /// TraceSourceLogger ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerGenericTypeObjectTest13()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("classType02", "sourceName02"));
            TraceSourceLogger chacheLogger = new TraceSourceLogger(typeof(Object), "sourceName");
            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            logFactory.LoggersStub.Add(key, chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger<TraceSourceLogger>(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(TraceSourceLogger));
            Assert.AreEqual(3, logFactory.LoggersStub.Count);

            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(chacheLogger, logger);

            Assert.IsNull(logFactory._classType);
            Assert.IsNull(logFactory._sourceName);
        }

        #endregion

        #region GetLogger(string, params object[]) ̃eXg

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  null ̏ꍇA
        /// ArgumentNullException X[邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest01()
        {
            // 
            string className = null;
            object[] args = { "sourceName" };

            try
            {
                // {
                ILog target = LogFactory.GetLogger(className, args);
                Assert.Fail("BĂ͂ȂR[hłB");
            }
            catch (ArgumentNullException e)
            {
                // mF
                Assert.AreEqual("l Null ɂ邱Ƃ͂ł܂B\r\np[^: className", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("BĂ͂ȂR[hłB" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎̏ꍇA
        /// ArgumentException X[邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest02()
        {
            // 
            string className = string.Empty;
            object[] args = { "sourceName" };

            try
            {
                // {
                ILog target = LogFactory.GetLogger(className, args);
                Assert.Fail("BĂ͂ȂR[hłB");
            }
            catch (ArgumentException e)
            {
                // mF
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(" \"className\" ̒l󕶎ɂ邱Ƃ͂ł܂B", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("BĂ͂ȂR[hłB" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// className  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 0 ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest03()
        {
            // 
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs  null ̏ꍇA
        /// ArgumentNullException X[邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest04()
        {
            // 
            string className = "className";

            try
            {
                // {
                ILog target = LogFactory.GetLogger(className, null);
                Assert.Fail("BĂ͂ȂR[hłB");
            }
            catch (ArgumentNullException e)
            {
                // mF
                Assert.AreEqual("l Null ɂ邱Ƃ͂ł܂B\r\np[^: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("BĂ͂ȂR[hłB" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 0 ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest05()
        {
            // 
            string className = "className";

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 1  args[0]=null ̏ꍇA
        /// ILog NX ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest06()
        {
            // 
            string className = "className";
            object[] args = { null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 1  args[0] ̕ϊ
        /// 񒷂 0 ̏ꍇA
        /// ILog NX ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest07()
        {
            // 
            string className = "className";
            object[] args = { string.Empty };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 3 
        /// args[0]=args[1]=args[2]=null ̏ꍇA
        /// ILog NX ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest08()
        {
            // 
            string className = "className";
            object[] args = { null, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 3  args[0] ̕ϊ
        /// 񒷂 0Aargs[1]=args[2]=null ̏ꍇA
        /// ILog NX ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest09()
        {
            // 
            string className = "className";
            object[] args = { string.Empty, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:Default"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  className  󕶎Aargs ̗vf 3  args[0] ̕ϊ
        /// 񒷂 0 łȂAargs[1]=args[2]=null ̏ꍇA
        /// ILog NX ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest10()
        {
            // 
            string className = "className";
            object[] args = { "sourceName", null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// className  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 1 ̏ꍇA
        /// ILog NX ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest11()
        {
            // 
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01", "sourceName01"));
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(2, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// className  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 3 ̏ꍇA
        /// ILog NX ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest12()
        {
            // 
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("className02", "sourceName02"));
            logFactory.LoggersStub.Add("dummyKey03", new TraceSourceLogger("className03", "sourceName03"));

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(4, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreEqual("className", logFactory._className);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// className  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 1 ̏ꍇA
        /// ILog NX ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest13()
        {
            // 
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            TraceSourceLogger chacheLogger = new TraceSourceLogger("className", "sourceName");
            logFactory.LoggersStub.Add("className:sourceName", chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreSame(chacheLogger, logger);
            Assert.IsNull(logFactory._className);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// className  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 3 ̏ꍇA
        /// ILog NX ̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest14()
        {
            // 
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("className01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("className02", "sourceName02"));
            TraceSourceLogger chacheLogger = new TraceSourceLogger("className", "sourceName");
            logFactory.LoggersStub.Add("className:sourceName", chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(3, logFactory.LoggersStub.Count);
            Assert.AreSame(logFactory.LoggersStub["className:sourceName"], logger);
            Assert.AreSame(chacheLogger, logger);
            Assert.IsNull(logFactory._className);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// TraceSourceLogFactory ̃X^uNX𗘗pɎs邱ƂŁA
        /// CreateTraceSourceLoggerByName \bh̃pXmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerStringObjectTest15()
        {
            // 
            string className = "className";
            object[] args = { "sourceName" };

            TraceSourceLogFactory logFactory = new TraceSourceLogFactory();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory.GetLogger(className, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
        }

        #endregion

        #region GetLogger(Type, params object[]) ̃eXg

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  null ̏ꍇA
        /// ArgumentNullException X[邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest01()
        {
            // 
            Type classType = null;
            object[] args = { "sourceName" };

            try
            {
                // {
                ILog target = LogFactory.GetLogger(classType, args);
                Assert.Fail("BĂ͂ȂR[hłB");
            }
            catch (ArgumentNullException e)
            {
                // mF
                Assert.AreEqual("l Null ɂ邱Ƃ͂ł܂B\r\np[^: classType", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("BĂ͂ȂR[hłB" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// classType  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 0 ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest02()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs  null ̏ꍇA
        /// ArgumentNullException X[邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest03()
        {
            // 
            Type classType = typeof(Object);

            try
            {
                // {
                ILog target = LogFactory.GetLogger(classType, null);
                Assert.Fail("BĂ͂ȂR[hłB");
            }
            catch (ArgumentNullException e)
            {
                // mF
                Assert.AreEqual("l Null ɂ邱Ƃ͂ł܂B\r\np[^: args", e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("BĂ͂ȂR[hłB" + e.ToString());
            }
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 0 ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest04()
        {
            // 
            Type classType = typeof(Object);

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 1  args[0]=null ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest05()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 1  args[0] ̕ϊ
        /// 񒷂 0 ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest06()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { string.Empty };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 3 
        /// args[0]=args[1]=args[2]=null ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest07()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { null, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 3  args[0] ̕ϊ
        /// 񒷂 0Aargs[1]=args[2]=null ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest08()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { string.Empty, null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "Default");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("Default", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        ///  classType  not nullAargs ̗vf 3  args[0] ̕ϊ
        /// 񒷂 0 łȂAargs[1]=args[2]=null ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest09()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName", null, null };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// classType  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 1 ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest10()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(2, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// classType  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 3 ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest11()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();
            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("classType02", "sourceName02"));
            logFactory.LoggersStub.Add("dummyKey03", new TraceSourceLogger("classType03", "sourceName03"));

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(4, logFactory.LoggersStub.Count);

            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(classType, logFactory._classType);
            Assert.AreEqual("sourceName", logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// classType  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 1 ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest12()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            TraceSourceLogger chacheLogger = new TraceSourceLogger(typeof(Object), "sourceName");
            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            logFactory.LoggersStub.Add(key, chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(1, logFactory.LoggersStub.Count);

            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(chacheLogger, logger);

            Assert.IsNull(logFactory._classType);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(Type, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// classType  arg[0] 琶L[ɊY
        /// ILog NX̃CX^X̃LbV݂A
        /// Dictionary̗vf 3 ̏ꍇA
        /// ILog NX̃CX^Xɐ邱ƂmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest13()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory_Stub01 logFactory = new TraceSourceLogFactory_Stub01();

            logFactory.LoggersStub.Clear();
            logFactory.LoggersStub.Add("dummyKey01", new TraceSourceLogger("classType01", "sourceName01"));
            logFactory.LoggersStub.Add("dummyKey02", new TraceSourceLogger("classType02", "sourceName02"));
            TraceSourceLogger chacheLogger = new TraceSourceLogger(typeof(Object), "sourceName");
            string key = string.Format("{0}:{1}", classType.FullName, "sourceName");
            logFactory.LoggersStub.Add(key, chacheLogger);

            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory_Stub01.GetLogger(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
            Assert.AreEqual(3, logFactory.LoggersStub.Count);

            Assert.AreSame(logFactory.LoggersStub[key], logger);
            Assert.AreSame(chacheLogger, logger);

            Assert.IsNull(logFactory._classType);
            Assert.IsNull(logFactory._sourceName);
        }

        /// <summary>
        /// GetLogger(string, params object[]) ̃eXg
        /// </summary>
        /// <remarks>
        /// TraceSourceLogFactory ̃X^uNX𗘗pɎs邱ƂŁA
        /// CreateTraceSourceLoggerByName \bh̃pXmFeXgB
        /// </remarks>
        [TestMethod()]
        public void GetLoggerTypeObjectTest14()
        {
            // 
            Type classType = typeof(Object);
            object[] args = { "sourceName" };

            TraceSourceLogFactory logFactory = new TraceSourceLogFactory();
            TERASOLUNA_Fw_Common_Logging_LogFactoryAccessor._logFactory = logFactory;

            // {
            ILog logger = TraceSourceLogFactory.GetLogger(classType, args);

            // mF
            Assert.IsInstanceOfType(logger, typeof(ILog));
        }

        #endregion
    }
}

