// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common.Validation;

namespace TERASOLUNA.Fw.Client
{
    /// <summary>
    /// Cxg@\񋟂NXłB
    /// </summary>
    /// <remarks>
    /// CxgRg[̃vpeBŁAs@\ݒ肵܂B
    /// </remarks>
    [DefaultEvent("ExecuteCompleted")]
    public class EventController : Component
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(EventController));

        /// <summary>
        /// ʐMɒʒm郊NGXg̃L[lłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "RequestName" łB
        /// </remarks>
        public static readonly string REQUEST_NAME = "RequestName";

        /// <summary>
        /// f[^ZbgϊʂRo[gIDłB
        /// </summary>
        private string _convertId = null;

        /// <summary>
        /// srWlXWbNʂrWlXWbNłB
        /// </summary>
        private string _blogicName = null;

        /// <summary>
        /// ʐMɒʒm郊NGXgłB
        /// </summary>
        private string _requestName = null;

        /// <summary>
        /// ͒lؐݒt@C̃pXłB
        /// </summary>
        private string _validationFilePath = null;

        /// <summary>
        /// ͒l؃[ZbgłB
        /// </summary>
        private string _ruleSet = null;

        /// <summary>
        ///  <see cref="DataSet"/> łB
        /// </summary>
        private DataSet _viewData = null;

        /// <summary>
        /// rWlXWbN <see cref="DataSet"/> ̌^łB
        /// </summary>
        private string _blogicParamTypeName = null;

        /// <summary>
        /// rWlXWbNo <see cref="DataSet"/> ̌^łB
        /// </summary>
        private string _blogicResultTypeName = null;

        /// <summary>
        /// G[ϏG[nhłB
        /// </summary>
        private IErrorHandler _errorHandler = null;

        /// <summary>
        /// G[ӏ\L[i[郊XgłB
        /// </summary>
        private IList<string> _errorPaths = new List<string>();

        /// <summary>
        /// rWlXWbNsNXłB
        /// </summary>
        private Coordinator _coordinator = null;

        /// <summary>
        /// OANZX\ȃIuWFNgێ܂B
        /// </summary>
        private IDictionary<string, object> _items = new Dictionary<string, object>();

        /// <summary>
        /// <see cref="ReportCustomValidating"/> ĂяoꂽƂɔ܂B
        /// </summary>
        [Category(""), Description("JX^`FbNsƂɔ܂B")]
        public event CustomValidatingEventHandler CustomValidating;

        /// <summary>
        /// <see cref="ReportValidationFailed"/> ĂяoꂽƂɔ܂B
        /// </summary>
        [Category(""), Description("͒l؃G[ɔ܂B")]
        public event ValidationFailedEventHandler ValidationFailed;

        /// <summary>
        /// <see cref="ReportPreprocessed"/> ĂяoꂽƂɔ܂B
        /// </summary>
        [Category(""), Description("OƂɔ܂B")]
        public event PreprocessedEventHandler Preprocessed;

        /// <summary>
        /// <see cref="ReportPreprocessedFailed"/> ĂяoꂽƂɔ܂B
        /// </summary>
        [Category(""), Description("OG[ɔ܂B")]
        public event PreprocessedFailedEventHandler PreprocessedFailed;

        /// <summary>
        /// <see cref="ReportBLogicFailed"/> ĂяoꂽƂɔ܂B
        /// </summary>
        [Category(""), Description("rWlXWbNsƂɔ܂B")]
        public event BLogicFailedEventHandler BLogicFailed;

        /// <summary>
        /// <see cref="ReportExecuteCompleted"/> ĂяoꂽƂɔ܂B
        /// </summary>
        [Category(""), Description("񓯊Ƃɔ܂B")]
        public event ExecuteCompletedEventHandler ExecuteCompleted;

        /// <summary>
        /// <see cref="ReportExecuteProgressChanged"/> ĂяoꂽƂɔ܂B
        /// </summary>
        [Category(""), Description("obNOEh̐is󋵂ʒmƂɔ܂B")]
        public event ExecuteProgressChangedEventHandler ExecuteProgressChanged;

        /// <summary>
        /// <see cref="EventController"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public EventController()
        {
        }

        /// <summary>
        /// <see cref="EventController"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="container">
        /// ꂽtH[̃fUCiϐB
        /// </param>
        public EventController(IContainer container)
        {
            if (container != null)
            {
                container.Add(this);
            }
        }

        /// <summary>
        /// Ro[g ID 擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// Ro[g ID B
        /// </value>
        [Category("Cxg"), Description("f[^Zbgϊݒt@Cɒ`ꂽRo[gIDw肵܂B")]
        public string ConvertId
        {
            get
            {
                return _convertId;
            }
            set
            {
                _convertId = value;
            }
        }

        /// <summary>
        /// rWlXWbN擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// rWlXWbNB
        /// </value>
        [Category("Cxg"), Description("rWlXWbNݒt@Cɒ`ꂽrWlXWbNw肵܂B")]
        public string BLogicName
        {
            get
            {
                return _blogicName;
            }
            set
            {
                _blogicName = value;
            }
        }

        /// <summary>
        /// ʐMɒʒm郊NGXg擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// ʐMɒʒm郊NGXgB
        /// </value>
        [Category("Cxg"), Description("T[oŎs郊NGXg̎ʎqݒ肵܂B")]
        public string RequestName
        {
            get
            {
                return _requestName;
            }
            set
            {
                _requestName = value;
            }
        }

        /// <summary>
        /// ͒lؐݒt@CpX擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// ͒lؐݒt@CpXB
        /// </value>
        [Category("Cxg"), Description("\[X܂̓[Jɂ͒lؐݒt@C̃pXݒ肵܂B")]
        public string ValidationFilePath
        {
            get
            {
                return _validationFilePath;
            }
            set
            {
                _validationFilePath = value;
            }
        }

        /// <summary>
        /// ͒l؃[Zbg擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// ͒l؃[ZbgB
        /// </value>
        [Category("Cxg"), Description("\[X܂̓[Jɂ͒lؐݒt@C̃[Zbgݒ肵܂B")]
        public string RuleSet
        {
            get
            {
                return _ruleSet;
            }
            set
            {
                _ruleSet = value;
            }
        }

        /// <summary>
        ///  <see cref="DataSet"/> 擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        ///  <see cref="DataSet"/> B
        /// </value>
        [Category("Cxg"), Description("ʃf[^Zbgݒ肵܂B")]
        public DataSet ViewData
        {
            get
            {
                return _viewData;
            }
            set
            {
                _viewData = value;
            }
        }

        /// <summary>
        /// rWlXWbN <see cref="DataSet"/> ̌^擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// rWlXWbN <see cref="DataSet"/> ̌^B
        /// </value>
        [Category("Cxg"), Description("rWlXWbN̓f[^Zbg̊SC^ݒ肵܂B")]
        public string BLogicParamTypeName
        {
            get
            {
                return _blogicParamTypeName;
            }
            set
            {
                _blogicParamTypeName = value;
            }
        }

        /// <summary>
        /// rWlXWbNo <see cref="DataSet"/> ̌^擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// rWlXWbNo <see cref="DataSet"/> ̌^B
        /// </value>
        [Category("Cxg"), Description("rWlXWbNo̓f[^Zbg̊SC^ݒ肵܂B")]
        public string BLogicResultTypeName
        {
            get
            {
                return _blogicResultTypeName;
            }
            set
            {
                _blogicResultTypeName = value;
            }
        }

        /// <summary>
        /// <see cref="Coordinator"/> 񓯊sǂl擾܂B
        /// </summary>
        /// <value>
        /// <see cref="Coordinator"/> 񓯊s̏ꍇ true B
        /// ȊȌꍇ false B
        /// </value>
        [Browsable(false)]
        public bool IsBusy
        {
            get
            {
                return (_coordinator != null && _coordinator.IsBusy);
            }
        }

        /// <summary>
        /// G[ϏG[nh擾܂͐ݒ肵܂B
        /// </summary>
        /// <remarks>
        /// fUCiŁAʂ 
        /// <see cref="TERASOLUNA.Fw.Client.EventController"/> R|[lgǉƂA
        /// ʂ̊NX <see cref="IErrorHandler"/> Ă΁A
        /// IɊNX̃CX^Xݒ肵܂B
        /// </remarks>
        /// <value>
        /// G[ϏG[nhB
        /// </value>
        [Category("Cxg"), Description("IErrorHandlerNX̃CX^Xݒ肵܂B")]
        public IErrorHandler ErrorHandler
        {
            get
            {
                return _errorHandler;
            }
            set
            {
                _errorHandler = value;
            }
        }

        /// <summary>
        /// G[ӏ\L[̃Xg擾܂B
        /// </summary>
        /// <value>
        /// G[ӏ\L[̃XgB
        /// </value>
        [Browsable(false)]
        public IList<string> ErrorPaths
        {
            get
            {
                return _errorPaths;
            }
        }

        /// <summary>
        /// OANZX\ȃIuWFNg擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// OANZX\ȃIuWFNgB
        /// </value>
        [Browsable(false)]
        public IDictionary<string, object> Items
        {
            get
            {
                return _items;
            }
        }

        /// <summary>
        /// rWlXWbN𓯊ŎsA
        /// <see cref="TERASOLUNA.Fw.Client.ExecutionResult"/>
        /// ԋp܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="Coordinator"/>
        /// CX^X擾ArWlXWbN𓯊Ŏs܂B
        /// </para>
        /// </remarks>
        /// <returns>
        /// sʂi[ <see cref="TERASOLUNA.Fw.Client.ExecutionResult"/> B
        /// </returns>
        /// <exception cref="TerasolunaException">
        /// <see cref="Coordinator"/> hNXA
        /// ܂́A <see cref="Coordinator"/> NX̃CX^X𐶐ł܂B
        /// </exception>
        public virtual ExecutionResult Execute()
        {
            _coordinator = Coordinator.CreateCoordinator();

            if (_log.IsDebugEnabled)
            {
                _log.Debug(Properties.Resources.D_BEGIN_EVENT_FUNCTION);
            }

            ExecutionResult executionResult = _coordinator.Execute(this);

            if (_log.IsDebugEnabled)
            {
                _log.Debug(Properties.Resources.D_END_EVENT_FUNCTION);
            }
            
            return executionResult;
        }

        /// <summary>
        /// rWlXWbN񓯊Ŏs܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="Coordinator"/>
        /// CX^X擾ArWlXWbN񓯊Ŏs܂B
        /// </para>
        /// <para>
        /// <see cref="IsBusy"/>  false ̏ꍇ́ArWlXWbN񓯊Ŏs܂B
        /// </para>
        /// <para>
        /// <see cref="IsBusy"/>  true ̏ꍇ́AOX[܂B
        /// </para>
        /// </remarks>
        /// <exception cref="InvalidOperationException">
        /// łɑ̔񓯊sĂ܂B
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// <see cref="Coordinator"/> hNXA
        /// ܂́A<see cref="Coordinator"/> NX̃CX^X𐶐ł܂B
        /// </exception>
        public virtual void ExecuteAsync()
        {
            if (IsBusy)
            {
                InvalidOperationException exception = new InvalidOperationException(
                    Properties.Resources.E_BLOGIC_EXECUTEASYNC_OPERATED);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            _coordinator = Coordinator.CreateCoordinator();

            if (_log.IsDebugEnabled)
            {
                _log.Debug(Properties.Resources.D_BEGIN_EVENT_ASYNC_FUNCTION);
            }

            _coordinator.ExecuteAsync(this);

            if (_log.IsDebugEnabled)
            {
                _log.Debug(Properties.Resources.D_END_EVENT_ASYNC_FUNCTION);
            }

        }

        /// <summary>
        /// rWlXWbN̔񓯊LZ܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="Coordinator.ExecuteAsyncCancel"/> \bhĂяoA
        /// rWlXWbN̔񓯊LZ܂B
        /// </para>
        /// <para>
        /// <see cref="IsBusy"/>  false ̏ꍇA
        /// rWlXWbN͎sĂȂ̂ŗOX[܂B
        /// </para>
        /// <para>
        /// <see cref="IsBusy"/>  true ̏ꍇA
        /// <see cref="Coordinator.ExecuteAsyncCancel"/> \bhĂяo܂B
        /// </para>
        /// <para>
        /// LZ̊Cxgœn <see cref="TERASOLUNA.Fw.Client.ExecuteCompletedEventArgs"/> 
        /// rWlXWbNʂi[ꂽ <see cref="TERASOLUNA.Fw.Client.ExecutionResult"/> QƂ
        /// <see cref="InvalidOperationException"/> X[܂B
        /// </para>
        /// </remarks>
        /// <exception cref="InvalidOperationException">
        /// <see cref="Coordinator"/> Ŕ񓯊͎sĂ܂B
        /// </exception>
        public virtual void ExecuteAsyncCancel()
        {
            if (!IsBusy)
            {
                InvalidOperationException exception = new InvalidOperationException(
                    Properties.Resources.E_BLOGIC_NOT_EXECUTEASYNC_OPERATED);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            if (_log.IsDebugEnabled)
            {
                _log.Debug(Properties.Resources.D_BEGIN_EVENT_ASYNC_CANCEL_FUNCTION);
            }

            _coordinator.ExecuteAsyncCancel();

            if(_log.IsDebugEnabled)
            {
                _log.Debug(Properties.Resources.D_END_EVENT_ASYNC_CANCEL_FUNCTION);
            }
        }

        /// <summary>
        /// Cxgf[^i[
        /// <see cref="CustomValidatingEventArgs"/>
        /// 𐶐AJX^`FbNCxgʒms\bhĂяo܂B
        /// </summary>
        /// <para>
        ///  <see cref="DataSet"/> 
        /// ،ʂ̃G[Xgێ <see cref="ValidationResult"/> 󂯎āA
        /// Cxgf[^i[
        /// <see cref="CustomValidatingEventArgs"/> 𐶐A
        /// JX^`FbNCxgʒms\bhĂяo܂B
        /// </para>
        /// <param name="validationResult">
        /// ،ʂ̃G[Xgێ <see cref="ValidationResult"/> B
        /// </param>
        public virtual void ReportCustomValidating(ValidationResult validationResult)
        {
            CustomValidatingEventArgs args = 
                new CustomValidatingEventArgs(validationResult);
            OnCustomValidating(args);
        }

        /// <summary>
        /// Cxgf[^i[
        /// <see cref="ValidationFailedEventArgs"/> 𐶐A
        /// ͒l؃G[Cxgʒms\bhĂяo܂B
        /// </summary>
        /// <para>
        ///  <see cref="DataSet"/> 
        /// <see cref="ExecutionResult"/> 󂯎āA
        /// Cxgf[^i[
        /// <see cref="ValidationFailedEventArgs"/> 𐶐A
        /// ͒l؃G[Cxgʒms\bhĂяo܂B
        /// </para>
        /// <param name="executionResult">
        /// sʂi[ <see cref="ExecutionResult"/> B
        /// </param>
        public virtual void ReportValidationFailed(ExecutionResult executionResult)
        {
            ValidationFailedEventArgs args =
                new ValidationFailedEventArgs(executionResult);
            OnValidationFailed(args);
        }

        /// <summary>
        /// Cxgf[^i[
        /// <see cref="PreprocessedEventArgs"/> 𐶐A
        /// OCxgʒms\bhĂяo܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// rWlXWbN <see cref="DataSet"/> 
        /// <see cref="ExecutionResult"/>
        /// 󂯎ăCxgf[^i[
        /// <see cref="PreprocessedEventArgs"/>
        /// 𐶐AOCxgʒms\bhĂяo܂B
        /// </para>
        /// </remarks>
        /// <param name="executionResult">
        /// sʂi[ <see cref="ExecutionResult"/> B
        /// </param>
        /// <param name="blogicParamData">
        /// rWlXWbN <see cref="DataSet"/> B
        /// </param>
        public virtual void ReportPreprocessed(
            ExecutionResult executionResult, DataSet blogicParamData)
        {
            PreprocessedEventArgs args =
                new PreprocessedEventArgs(executionResult, blogicParamData);
            OnPreprocessed(args);
        }

        /// <summary>
        /// Cxgf[^i[
        /// <see cref="PreprocessedFailedEventArgs"/>
        /// 𐶐AOG[Cxgʒms\bhĂяo܂B
        /// </summary>
        /// <para>
        /// rWlXWbN <see cref="DataSet"/> 
        /// <see cref="ExecutionResult"/> 󂯎āA
        /// Cxgf[^i[<see cref="PreprocessedFailedEventArgs"/> 𐶐A
        /// ͒l؃G[Cxgʒms\bhĂяo܂B
        /// </para>
        /// <param name="executionResult">
        /// sʂi[ <see cref="ExecutionResult"/> B
        /// </param>
        /// <param name="blogicParamData">
        /// rWlXWbN <see cref="DataSet"/> B
        /// </param>
        public virtual void ReportPreprocessedFailed(
            ExecutionResult executionResult, DataSet blogicParamData)
        {
            PreprocessedFailedEventArgs args =
                new PreprocessedFailedEventArgs(executionResult, blogicParamData);
            OnPreprocessedFailed(args);
        }

        /// <summary>
        /// Cxgf[^i[
        /// <see cref="BLogicFailedEventArgs"/>
        /// 𐶐ArWlXWbNsCxgʒms\bhĂяo܂B
        /// </summary>
        /// <para>
        /// <see cref="ExecutionResult"/> 󂯎āA
        /// Cxgf[^i[ <see cref="BLogicFailedEventArgs"/> 𐶐A
        /// ͒l؃G[Cxgʒms\bhĂяo܂B
        /// </para>
        /// <param name="executionResult">
        /// sʂi[ <see cref="ExecutionResult"/> B
        /// </param>
        public virtual void ReportBLogicFailed(ExecutionResult executionResult)
        {
            BLogicFailedEventArgs args = new BLogicFailedEventArgs(executionResult);
            OnBLogicFailed(args);
        }

        /// <summary>
        /// Cxgf[^i[
        /// <see cref="ExecuteCompletedEventArgs"/>
        /// 𐶐A񓯊Cxgʒms\bhĂяo܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="ExecutionResult"/> A
        /// OALZ󂯎ăCxgf[^i[
        /// <see cref="ExecuteCompletedEventArgs"/>
        /// 𐶐ACxgCxgʒms\bhĂяo܂B
        /// </para>
        /// </remarks>
        /// <param name="executionResult">sʂȂǂi[ <see cref="ExecutionResult"/> B</param>
        /// <param name="error"><see cref="Coordinator"/> Ŕ <see cref="Exception"/> B</param>
        /// <param name="cancelled">LZB</param>
        public virtual void ReportExecuteCompleted(
            ExecutionResult executionResult,Exception error, bool cancelled)
        {
            ExecuteCompletedEventArgs args = 
                new ExecuteCompletedEventArgs(executionResult, error, cancelled);
            OnExecuteCompleted(args);
        }

        /// <summary>
        /// Cxgf[^i[
        /// <see cref="ExecuteProgressChangedEventArgs"/>
        /// 𐶐Ais󋵃Cxgʒms\bhĂяo܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// is󋵂̊ƃCxgnh֓nRNV󂯎
        /// Cxgf[^i[
        /// <see cref="ExecuteProgressChangedEventArgs"/> 𐶐
        /// is󋵃Cxgʒms\bhĂяo܂B
        /// </para>
        /// </remarks>
        /// <param name="progressPercentage">is󋵂̊B</param>
        /// <param name="items">Cxgnh֓nRNVB</param>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="items"/>  null QƂłB
        /// </exception>
        public virtual void ReportExecuteProgressChanged(int progressPercentage, IDictionary items)
        {
            if (items == null)
            {
                ArgumentNullException exception = new ArgumentNullException("items");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "items"), exception);
                }
                throw exception;
            }

            ExecuteProgressChangedEventArgs args = new ExecuteProgressChangedEventArgs(progressPercentage);

            foreach (DictionaryEntry item in items)
            {
                args.Items[item.Key] = item.Value;
            }

            OnExecuteProgressChanged(args);

            foreach (DictionaryEntry item in args.Items)
            {
                items[item.Key] = item.Value;
            }
        }

        /// <summary>
        /// JX^`FbNCxgɓo^ꂽCxgnhɑ΂Ēʒm܂B
        /// </summary>
        /// <param name="e">
        /// Cxgf[^i[Ă <see cref="CustomValidatingEventArgs"/> B
        /// </param>
        protected virtual void OnCustomValidating(CustomValidatingEventArgs e)
        {
            if (CustomValidating != null)
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_BEGIN_EVENT, "CustomValidating"));
                }

                CustomValidating(this, e);

                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_END_EVENT, "CustomValidating"));
                }
            }
        }

        /// <summary>
        /// ͒l؃G[Cxgɓo^ꂽCxgnhɑ΂Ēʒm܂B
        /// </summary>
        /// <param name="e">
        /// Cxgf[^i[Ă <see cref="ValidationFailedEventArgs"/> B
        /// </param>
        protected virtual void OnValidationFailed(ValidationFailedEventArgs e)
        {
            if (ValidationFailed != null)
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_BEGIN_EVENT, "ValidationFailed"));
                }

                ValidationFailed(this, e);

                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_END_EVENT, "ValidationFailed"));
                }
            }
        }

        /// <summary>
        /// OCxgɓo^ꂽCxgnhɑ΂Ēʒm܂B
        /// </summary>
        /// <param name="e">
        /// Cxgf[^i[Ă <see cref="PreprocessedEventArgs"/> B
        /// </param>
        protected virtual void OnPreprocessed(PreprocessedEventArgs e)
        {
            if (Preprocessed != null)
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_BEGIN_EVENT, "Preprocessed"));
                }

                Preprocessed(this, e);

                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_END_EVENT, "Preprocessed"));
                }
            }
        }

        /// <summary>
        /// OG[Cxgɓo^ꂽCxgnhɑ΂Ēʒm܂B
        /// </summary>
        /// <param name="e">
        /// Cxgf[^i[Ă <see cref="PreprocessedFailedEventArgs"/> B
        /// </param>
        protected virtual void OnPreprocessedFailed(PreprocessedFailedEventArgs e)
        {
            if (PreprocessedFailed != null)
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_BEGIN_EVENT, "PreprocessedFailed"));
                }

                PreprocessedFailed(this, e);

                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_END_EVENT, "PreprocessedFailed"));
                }
            }
        }

        /// <summary>
        /// rWlXWbNG[Cxgɓo^ꂽCxgnhɑ΂Ēʒm܂B
        /// </summary>
        /// <param name="e">
        /// Cxgf[^i[Ă <see cref="BLogicFailedEventArgs"/> B
        /// </param>
        protected virtual void OnBLogicFailed(BLogicFailedEventArgs e)
        {
            if (BLogicFailed != null)
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_BEGIN_EVENT, "BLogicFailed"));
                }

                BLogicFailed(this, e);

                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_END_EVENT, "BLogicFailed"));
                }
            }
        }

        /// <summary>
        /// 񓯊Cxgɓo^ꂽCxgnhɑ΂Ēʒm܂B
        /// </summary>
        /// <param name="e">
        /// Cxgf[^i[Ă <see cref="ExecuteCompletedEventArgs"/> B
        /// </param>
        protected virtual void OnExecuteCompleted(ExecuteCompletedEventArgs e)
        {
            if (ExecuteCompleted != null)
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_BEGIN_EVENT, "ExecuteCompleted"));
                }

                ExecuteCompleted(this, e);

                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_END_EVENT, "ExecuteCompleted"));
                }
            }
        }

        /// <summary>
        /// is󋵃Cxgɓo^ꂽCxgnhɑ΂Ēʒm܂B
        /// </summary>
        /// <param name="e">
        /// Cxgf[^i[Ă <see cref="ExecuteProgressChangedEventArgs"/> B
        /// </param>
        protected virtual void OnExecuteProgressChanged(ExecuteProgressChangedEventArgs e)
        {
            if (ExecuteProgressChanged != null)
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_BEGIN_EVENT, "ExecuteProgressChanged"));
                }

                ExecuteProgressChanged(this, e);

                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_END_EVENT, "ExecuteProgressChanged"));
                }
            }
        }
    }

    /// <summary>
    /// JX^`FbNCxgnh̃fQ[głB
    /// </summary>
    /// <param name="sender">Cxg̃\[XB</param>
    /// <param name="e">Cxgf[^i[Ă <see cref="CustomValidatingEventArgs"/> B</param>
    public delegate void CustomValidatingEventHandler(object sender, CustomValidatingEventArgs e);

    /// <summary>
    /// ͒l؃G[Cxgnh̃fQ[głB
    /// </summary>
    /// <param name="sender">Cxg̃\[XB</param>
    /// <param name="e">Cxgf[^i[Ă <see cref="ValidationFailedEventArgs"/> B</param>
    public delegate void ValidationFailedEventHandler(object sender, ValidationFailedEventArgs e);

    /// <summary>
    /// OCxgnh̃fQ[głB
    /// </summary>
    /// <param name="sender">Cxg̃\[XB</param>
    /// <param name="e">Cxgf[^i[Ă <see cref="PreprocessedEventArgs"/> B</param>
    public delegate void PreprocessedEventHandler(object sender, PreprocessedEventArgs e);

    /// <summary>
    /// OG[Cxg̃fQ[głB
    /// </summary>
    /// <param name="sender">Cxg̃\[XB</param>
    /// <param name="e">Cxgf[^i[Ă <see cref="PreprocessedFailedEventArgs"/> B</param>
    public delegate void PreprocessedFailedEventHandler(object sender, PreprocessedFailedEventArgs e);

    /// <summary>
    /// rWlXWbNG[Cxg̃fQ[głB
    /// </summary>
    /// <param name="sender">Cxg̃\[XB</param>
    /// <param name="e">Cxgf[^i[Ă <see cref="BLogicFailedEventArgs"/> B</param>
    public delegate void BLogicFailedEventHandler(object sender, BLogicFailedEventArgs e);

    /// <summary>
    /// 񓯊Cxg̃fQ[głB
    /// </summary>
    /// <param name="sender">Cxg̃\[XB</param>
    /// <param name="e">Cxgf[^i[Ă <see cref="ExecuteCompletedEventArgs"/> B</param>
    public delegate void ExecuteCompletedEventHandler(object sender, ExecuteCompletedEventArgs e);

    /// <summary>
    /// is󋵃Cxgnh̃fQ[głB
    /// </summary>
    /// <param name="sender">Cxg̃\[XB</param>
    /// <param name="e">Cxgf[^i[Ă <see cref="ExecuteProgressChangedEventArgs"/> B</param>
    public delegate void ExecuteProgressChangedEventHandler(object sender, ExecuteProgressChangedEventArgs e);
}
