// <쌠>
// Copyright (c) 2006-2007, NTT DATA Corporation.

using System;
using System.IO;
using System.Data;
using NTTDATA.TERASOLUNA.FW.Client.Communication;
using NTTDATA.TERASOLUNA.FW.Common;

namespace NTTDATA.TERASOLUNA.FW.Client.BLogic
{
    /// <summary>
    /// t@CAbv[hs <see cref="BLogicBase"/> hNXłB
    /// </summary>
    /// <remarks>
    /// <see cref="FileCommunicator"/> gpăt@CAbv[hs܂B
    /// </remarks>
    /// <typeparam name="T">
    /// T[oԋpꂽf[^i[邽߂̃rWlXWbNo <see cref="DataSet"/>B
    /// </typeparam>
    /// <author>
    /// V菲[
    /// </author>   
    public class UploadBLogic<T> : BLogicBase where T : DataSet, new()
    {
        /// <summary>
        /// Abv[ht@CpX<see cref="DataSet"/>擾ۂɃL[Ƃėpe[ułB
        /// </summary>
        /// <remarks><para>̒萔̒l "DtoFile" łB</para></remarks>
        protected static readonly string DTO_TABLE_NAME = "DtoFile";

        /// <summary>
        /// Abv[ht@CpX<see cref="DataSet"/>擾ۂɃL[ƂėpJłB
        /// </summary>
        /// <remarks><para>̒萔̒l "FilePath" łB</para></remarks>
        protected static readonly string DTO_COLUMN_NAME = "FilePath";

        /// <summary>
        /// t@CAbv[h@\񋟂NXێtB[hłB
        /// </summary>
        private FileCommunicator _fileCommunicator = new FileCommunicator();

        /// <summary>
        /// <see cref="BLogicBase.Cancelled"/> ̐ݒ莞ɗp铯p̃IuWFNgłB
        /// </summary>
        private object _syncRoot = new object();

        /// <summary>
        /// <see cref="UploadBLogic{T}"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^B
        /// </remarks>
        public UploadBLogic()
        {
            _fileCommunicator.ProgressChanged += new ExecuteProgressChangedEventHandler(DoFileCommunicateProgressChanged);
        }

        /// <summary>
        /// Abv[hs܂B
        /// </summary>
        /// <remarks>
        /// <para>T[oփt@CAbv[h܂B</para>
        /// <para>rWlXWbN <see cref="DataSet"/> ɁAAbv[ht@C̃pXi[ĂKv܂B</para>
        /// <para>Abv[ht@C̃pXi[ꏊ́A<see cref="DTO_TABLE_NAME"/>e[ũJ<see cref="DTO_COLUMN_NAME"/>1sڂłB</para>
        /// <para>Abv[ȟʂ <see cref="BLogicResult"/> Ɋi[ԋp܂B</para>
        /// <para>Abv[hɏIƁA<see cref="BLogicResult.ResultString">BLogicResult.ResultString</see> "success" ݒ肵܂B</para>
        /// <para>Abv[h <see cref="Cancel"/> \bhsƁA<see cref="BLogicResult.ResultString">BLogicResult.ResultString</see> "failure" ݒ肵܂B</para>
        /// </remarks>
        /// <param name="dto">rWlXWbN <see cref="DataSet"/>B</param>
        /// <returns>Abv[hʂێ <see cref="BLogicResult"/>B</returns>
        /// <exception cref="ArgumentNullException">
        /// <para><paramref name="dto"/>  null QƂłB</para>
        /// <para>Abv[ht@CpX null QƂłB</para>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <para><see cref="DTO_TABLE_NAME"/>ɑ΂e[u<paramref name="dto"/>Ɍ܂B</para>
        /// <para><see cref="DTO_TABLE_NAME"/>e[uɃR[h܂B</para>
        /// <para><see cref="DTO_COLUMN_NAME"/>ɑ΂J<see cref="DTO_TABLE_NAME"/>e[uɌ܂B</para>
        /// <para>Abv[ht@CpX󕶎łB</para>
        /// </exception>
        /// <exception cref="FileNotFoundException">
        /// Abv[ht@CpXŎw肳ꂽt@C܂łB
        /// </exception>
        /// <exception cref="UnauthorizedAccessException">
        /// Abv[ht@CɕKvȃANZX܂B
        /// </exception>
        /// <exception cref="System.IO.PathTooLongException">
        /// Abv[ht@CpXAAbv[ht@CA܂̗͂VXe`̍ő咷𒴂Ă܂BƂ΁AWindows x[X̃vbgtH[̏ꍇApX̒ 248 At@C̒ 260 łKv܂B
        /// </exception>
        /// <exception cref="InvalidOperationException">
        /// <see cref="BLogicBase.RequestName"/>ݒ肳Ă܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// ʐMɃG[܂B
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>słB
        /// </exception>
        public override BLogicResult Execute(DataSet dto)
        {
            if (dto == null) 
            {
                throw new ArgumentNullException("dto");
            }
            DataTable dtoTable = dto.Tables[DTO_TABLE_NAME];
            if (dtoTable == null)
            {
                throw new ArgumentException(string.Format(Properties.Resources.E_BLOGIC_TABLE_NOT_FOUND, dto.GetType().FullName));
            }
            if (dtoTable.Rows.Count == 0)
            {
                throw new ArgumentException(string.Format(Properties.Resources.E_BLOGIC_RECORD_NOT_FOUND, dto.GetType().FullName));
            }
            if (!dtoTable.Columns.Contains(DTO_COLUMN_NAME))
            {
                throw new ArgumentException(string.Format(Properties.Resources.E_BLOGIC_COLUMN_NOT_FOUND, dto.GetType().FullName));
            }

            if (string.IsNullOrEmpty(RequestName))
            {
                throw new InvalidOperationException(
                        string.Format(Properties.Resources.E_NULL_OR_EMPTY_PROPERTY_STRING,
                        "EventContext", "RequestName"));
            }

            // Abv[ht@CpX̎擾
            string filePath = dtoTable.Rows[0][DTO_COLUMN_NAME] as string;
            
            T receiveData = new T();
            BLogicResult blogicResult = new BLogicResult();

            if (Cancelled)
            {
                blogicResult.ResultString = FAILURE;
                return blogicResult;
            }

            try
            {
                CommunicationResult communicationResult = _fileCommunicator.Upload(RequestName, filePath, receiveData);

                if (communicationResult.ErrorType == null)
                {
                    blogicResult.ResultString = SUCCESS;
                    blogicResult.ResultData = receiveData;
                }
                else
                {
                    blogicResult.ResultString = FAILURE;
                    blogicResult.AddErrors(communicationResult.Errors);
                }
            }
            catch (CommunicationException)
            {
                lock (_syncRoot)
                {
                    if (!Cancelled)
                    {
                        throw;
                    }
                }

                blogicResult.ResultString = FAILURE;
            }

            return blogicResult;
        }

        /// <summary>
        /// ʐMLZ܂B
        /// </summary>
        public override void Cancel()
        {
            lock (_syncRoot)
            {
                _fileCommunicator.Cancel();
                Cancelled = true;
            }
        }

        /// <summary>
        /// <see cref="FileCommunicator"/> ̃Cxgʒm 
        /// <see cref="BLogicExecutor"/> ֈϏ܂B
        /// </summary>
        /// <param name="sender">CxgIuWFNgB</param>
        /// <param name="e">Cxgf[^i[Ă <see cref="ExecuteProgressChangedEventArgs"/>B</param>
        protected virtual void DoFileCommunicateProgressChanged(object sender, ExecuteProgressChangedEventArgs e)
        {
            OnProgressChanged(e);
        }

    }
}
