/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich;

import java.util.HashSet;
import java.util.Set;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.ForbiddenURICheckerImpl}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * 񂪋URI肷`FbJ̃ftHgNXB<br>
 * isAllowedURÏnot nullƂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.ForbiddenURICheckerImpl
 */
public class ForbiddenURICheckerImplTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ForbiddenURICheckerImplTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ForbiddenURICheckerImplTest(String name) {
        super(name);
    }

    /**
     * testSetAllowedURISet01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() allowedURISet:SetCX^X<br>
     *         () allowedURISet:null<br>
     *         
     * <br>
     * ҒlF(ԕω) allowedURISet:Ɠ̃CX^X<br>
     *         
     * <br>
     * ̒l𐳏ɑɐݒ肷邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetAllowedURISet01() throws Exception {
        // O
        // allowedURISet
        Set<String> allowedURISet = new HashSet<String>();
        
        ForbiddenURICheckerImpl impl = new ForbiddenURICheckerImpl();
        UTUtil.setPrivateField(impl, "allowedURISet", null);

        // eXg{
        impl.setAllowedURISet(allowedURISet);

        // 
        assertSame(allowedURISet, UTUtil.getPrivateField(impl, "allowedURISet"));
    }

    /**
     * testIsAllowedURI01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() requestURI:"AAA"<br>
     *         () allowedURISet:{"AAA", "BBB", "CCC"}<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         
     * <br>
     * ̃ZbgɈ̕񂪊܂܂ĂꍇAtrueԋp邱Ƃ̃eXgBivfj
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsAllowedURI01() throws Exception {
        // O
        // requestURI : "AAA"
        String requestURI = "AAA";
        
        // allowedURISet : "AAA", "BBB", "CCC"
        Set<String> allowedURISet = new HashSet<String>();
        allowedURISet.add("AAA");
        allowedURISet.add("BBB");
        allowedURISet.add("CCC");
        
        ForbiddenURICheckerImpl impl = new ForbiddenURICheckerImpl();
        UTUtil.setPrivateField(impl, "allowedURISet", allowedURISet);

        // eXg{
        boolean b = impl.isAllowedURI(requestURI);

        // 
        assertTrue(b);
    }

    /**
     * testIsAllowedURI02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() requestURI:"AAA"<br>
     *         () allowedURISet:{"AAA"}<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         
     * <br>
     * ̃ZbgɈ̕񂪊܂܂ĂꍇAtrueԋp邱Ƃ̃eXgBivfPj
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsAllowedURI02() throws Exception {
        // O
        // requestURI : "AAA"
        String requestURI = "AAA";
        
        // allowedURISet : "AAA"
        Set<String> allowedURISet = new HashSet<String>();
        allowedURISet.add("AAA");
        
        ForbiddenURICheckerImpl impl = new ForbiddenURICheckerImpl();
        UTUtil.setPrivateField(impl, "allowedURISet", allowedURISet);

        // eXg{
        boolean b = impl.isAllowedURI(requestURI);

        // 
        assertTrue(b);
    }

    /**
     * testIsAllowedURI03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() requestURI:"AAA"<br>
     *         () allowedURISet:{}<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * falseԋp邱Ƃ̃eXgBiJj
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsAllowedURI03() throws Exception {
        // O
        // requestURI : "AAA"
        String requestURI = "AAA";
        
        // allowedURISet : {}
        Set<String> allowedURISet = new HashSet<String>();
        
        ForbiddenURICheckerImpl impl = new ForbiddenURICheckerImpl();
        UTUtil.setPrivateField(impl, "allowedURISet", allowedURISet);

        // eXg{
        boolean b = impl.isAllowedURI(requestURI);

        // 
        assertFalse(b);
    }

    /**
     * testIsAllowedURI04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() requestURI:""<br>
     *         () allowedURISet:{"", "BBB", "CCC"}<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         
     * <br>
     * ̃ZbgɈ̕񂪊܂܂ĂꍇAtrueԋp邱Ƃ̃eXgBi󕶎j
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsAllowedURI04() throws Exception {
        // O
        // requestURI : ""
        String requestURI = "";
        
        // allowedURISet : "", "BBB", "CCC"
        Set<String> allowedURISet = new HashSet<String>();
        allowedURISet.add("");
        allowedURISet.add("BBB");
        allowedURISet.add("CCC");
        
        ForbiddenURICheckerImpl impl = new ForbiddenURICheckerImpl();
        UTUtil.setPrivateField(impl, "allowedURISet", allowedURISet);

        // eXg{
        boolean b = impl.isAllowedURI(requestURI);

        // 
        assertTrue(b);
    }

    /**
     * testIsAllowedURI05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() requestURI:"AAA"<br>
     *         () allowedURISet:null<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * falseԋp邱Ƃ̃eXgBinullj
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsAllowedURI05() throws Exception {
        // O
        // requestURI : "AAA"
        String requestURI = "AAA";
        
        ForbiddenURICheckerImpl impl = new ForbiddenURICheckerImpl();
        UTUtil.setPrivateField(impl, "allowedURISet", null);

        // eXg{
        boolean b = impl.isAllowedURI(requestURI);

        // 
        assertFalse(b);
    }

}
