/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.util;

public class Throttle {
    private final Object LOCK = new Object();
    private int count;
    private int limit;
    private long maxWait;

    public Throttle(int limit) {
        this.limit = limit;
        this.maxWait = 0L;
    }

    public Throttle(int limit, long maxWait) {
        this.limit = limit;
        this.maxWait = maxWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        Object object = this.LOCK;
        synchronized (object) {
            long totalWaitTime = 0L;
            while (this.count >= this.limit) {
                if (this.maxWait > 0L) {
                    long waitTime = System.currentTimeMillis();
                    try {
                        this.LOCK.wait(this.maxWait - totalWaitTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if ((totalWaitTime += System.currentTimeMillis() - waitTime) <= this.maxWait) continue;
                    throw new RuntimeException("Throttle waited too long (" + totalWaitTime + " milliseconds) for lock.");
                }
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException e) {}
            }
            ++this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement() {
        Object object = this.LOCK;
        synchronized (object) {
            --this.count;
            this.LOCK.notify();
        }
    }
}

