/*
 * Copyright (c) 2008 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.util;

import java.util.Locale;

import jp.terasoluna.fw.exception.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

/**
 * <p>
 * Spring̃bZ[W\[XStruts痘pMessageResourcesNXB<br>
 * </p>
 * <p>
 * SpringMessageResourcesFactorystruts-config.xmlmessage-resourcesvf
 * factoryɐݒ肷B<br>
 * <ul>
 *   <li>parameterlMessageSourceBeanIDw肵ꍇ́A
 *       w肵MessageSourcegB<br>
 *   <strong>̂Ƃw肵BeanȂꍇA擾Bean
 *   MessageSourceCX^XłȂꍇAPT[oNɗOB</strong>
 *   </li>
 *   <li>parameterlȗꍇ̓ftHg "messageSource" gB
 *   </li>
 * </ul>
 * </p>
 *
 * <p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>struts-config.xmlݒiparameterȗj</legend>
 * <pre><code>
 * &lt;message-resources parameter=""
 *   factory="jp.terasoluna.fw.web.struts.util.SpringMessageResourcesFactory"/&gt;
 * </code></pre>
 * </fieldset>
 * </p>
 *
 * <p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>struts-config.xmlݒiparameterw莞j</legend>
 * <pre><code>
 * &lt;message-resources parameter="hogeMessageSource"
 *   factory="jp.terasoluna.fw.web.struts.util.SpringMessageResourcesFactory"/&gt;
 * </code></pre>
 * </fieldset>
 * </p>
 *
 * <p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>Bean`t@Cݒ</legend>
 * ResourceBundleMessageSource𗘗pꍇAbasenamesvpeBɂ
 * bZ[WvpeBt@Cw肷B
 * <pre><code>
 * &lt;bean id="messageSource"
 *       class="org.springframework.context.support.ResourceBundleMessageSource"&gt;
 *   &lt;property name="basenames" value="MessageResources"/&gt;
 * &lt;/bean&gt;
 * </code></pre>
 * 
 * DataSourceMessageSource𗘗pDBbZ[W悤ɂȂB
 * <pre><code>
 * &lt;bean id="messageSource"
 *       class="jp.terasoluna.fw.message.DataSourceMessageSource"&gt;
 *   &lt;property name="dbMessageResourceDAO" ref="dbMessageResourceDAO"/&gt;
 * &lt;/bean&gt;
 * </code></pre> 
 * </fieldset>
 * </p>
 * 
 * <p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>QbZ[W\[X`ꍇBean`t@Cݒ</legend>
 * <pre><code>
 * &lt;bean id="messageSource"
 *       class="jp.terasoluna.fw.message.DataSourceMessageSource"&gt;
 *   &lt;property name="dbMessageResourceDAO" ref="dbMessageResourceDAO"/&gt;    
 *   &lt;property name="parentMessageSource" ref="parentSource"/&gt;
 * &lt;/bean&gt;
 * 
 * &lt;bean id="parentSource"
 *       class="org.springframework.context.support.ResourceBundleMessageSource"&gt;
 *   &lt;property name="basenames" value="MessageResources"/&gt;
 * &lt;/bean&gt;
 * </code></pre>
 * </fieldset>
 * </p>
 *
 * @see jp.terasoluna.fw.web.struts.util.SpringMessageResourcesFactory
 * @see org.springframework.context.support.ResourceBundleMessageSource
 * @see jp.terasoluna.fw.message.DataSourceMessageSource
 *
 */
public class SpringMessageResources extends MessageResources {

    /** 
     * VAo[WID
     */
    private static final long serialVersionUID = 8870342287587564386L;

    /**
     *  OCX^X
     */
    private static Log log = LogFactory.getLog(SpringMessageResources.class);

    /** 
     * G[bZ[WL[
     */
    private static final String ERR_BEAN_EXCEPTION = "errors.message.bean.exception";

    /** 
     * AvP[VReLXg
     */
    private WebApplicationContext context = null;

    /** 
     * Spring̃bZ[W\[X
     */
    private MessageSource messageSource = null;

    /**
     * w肳ꂽp[^ɂSpringMessageResources𐶐B
     *
     * @param factory bZ[W\[Xt@Ng
     * @param config Rei擾MessageSourceBean
     *               iȗ̓ftHg"messageSource"j
     */
    public SpringMessageResources(MessageResourcesFactory factory, String config) {
        super(factory, config);
        this.context = ContextLoader.getCurrentWebApplicationContext();

        initMessageSource();
    }

    /**
     * w肳ꂽp[^ɂSpringMessageResources𐶐B
     *
     * @param factory bZ[W\[Xt@Ng
     * @param config Rei擾MessageSourceBean
     *               iȗ̓ftHg"messageSource"j
     * @param returnNull <code>org.apache.struts.util.MessageResources</code>
     *                   NX <code>returnNull</code>B
     *                   <code>false</code> w莞AL[ɊY郁bZ[W
     *                   ݂Ȃꍇ???Locale.key???Ƃ`ŃbZ[W
     *                   ԋpB
     */
    public SpringMessageResources(MessageResourcesFactory factory,
            String config, boolean returnNull) {
        super(factory, config, returnNull);
        this.context = ContextLoader.getCurrentWebApplicationContext();

        initMessageSource();
    }

    /**
     * MessageSourcȅsB
     */
    private void initMessageSource() {
        if (this.context != null) {
            if (config != null && !("".equals(config))) {
                // p[^Ɏw肳ꂽBeanID擾
                try {
                    this.messageSource = (MessageSource) this.context.getBean(
                            config, MessageSource.class);
                } catch (BeansException e) {
                    if (log.isErrorEnabled()) {
                        StringBuilder mes = new StringBuilder();
                        mes.append(config);
                        mes.append(" is not found");
                        mes.append(" or it is not MessageSource instance.");
                        log.error(mes.toString());
                    }
                    throw new SystemException(e, ERR_BEAN_EXCEPTION);
                }

                if (log.isDebugEnabled()) {
                    StringBuilder mes = new StringBuilder();
                    mes.append(config);
                    mes.append(" MessageSource is used.");
                    log.debug(mes.toString());
                }
            }

            // ftHgMessageSource̗piApplicationContextgj
            if (this.messageSource == null) {
                this.messageSource = this.context;
                if (log.isDebugEnabled()) {
                    log.debug("Default MessageSource is used.");
                }
            }
        } else {
            if (log.isWarnEnabled()) {
                log.warn("ApplicationContext is not found.");
            }
        }
    }

    /**
     * w肳ꂽL[ƃP[ɂƂÂbZ[W擾B
     *
     * @see org.apache.struts.util.MessageResources#getMessage(java.util.Locale, java.lang.String)
     */
    @Override
    public String getMessage(Locale locale, String key) {
        if (this.messageSource != null) {
            String retMessage = null;

            try {
                retMessage = this.messageSource.getMessage(key, null, locale);
            } catch (NoSuchMessageException e) {
                // Ȃ
            }
            
            if (retMessage != null) {
                if (log.isDebugEnabled()) {
                    StringBuilder mes = new StringBuilder();
                    mes.append("key:[");
                    mes.append(key);
                    mes.append("] locale:[");
                    mes.append(locale);
                    mes.append("] message:[");
                    mes.append(retMessage);
                    mes.append("]");
                    log.debug(mes.toString());
                }
                return retMessage;
            }
        }

        // bZ[W݂Ȃꍇ́AreturnNull̐ݒ̗Lɏ]ĕԋp
        if (!returnNull) {
            StringBuilder mes = new StringBuilder();
            mes.append("???");
            mes.append(messageKey(locale, key));
            mes.append("???");
            return mes.toString();
        }
        return null;
    }

}
