/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation.springmodules;

import org.apache.commons.validator.Validator;
import org.springframework.validation.Errors;
import org.springmodules.validation.commons.DefaultValidatorFactory;

/**
 * terasoluna-validator-springCommonsValidatorExCX^X𐶐t@NgNXB
 * 
 * <p>{@link jp.terasoluna.fw.validation.FieldChecks}NXɂ
 * gpG[C^tF[X̎
 * Springt[[N{@link org.springframework.validation.Errors}NX
 * ߂̃NXB
 * Springt[[NASpring-Modulesgp邱ƂOƂĂA
 * Bean`t@CɈȉ̂悤Ȑݒ肪KvƂȂB</p>
 * 
 * <hr>
 * 
 * <h5>Bean`t@Cݒ</h5>
 * <code><pre>
 * &lt;!-- Validatort@Ngݒ --&gt;
 * &lt;bean id="validatorFactory" 
 *   class="jp.terasoluna.fw.validation.springmodules.DefaultValidatorFactoryEx"&gt; 
 *   &lt;property name="validationConfigLocations"&gt; 
 *     &lt;list&gt; 
 *       &lt;value&gt;/WEB-INF/validation/validator-rules.xml&lt;/value&gt;
 *       &lt;value&gt;/WEB-INF/validation/validator-rules-ex.xml&lt;/value&gt;
 *       &lt;value&gt;/WEB-INF/validation/validation.xml&lt;/value&gt; 
 *     &lt;/list&gt; 
 *   &lt;/property&gt; 
 * &lt;/bean&gt; 
 *   
 * &lt;!-- Validatorݒ --&gt;
 * &lt;bean id="beanValidator" class="jp.terasoluna.fw.validation.springmodules.DefaultBeanValidatorEx"&gt; 
 *   &lt;property name="validatorFactory"&gt;&lt;ref local="validatorFactory"/&gt;&lt;/property&gt; 
 * &lt;/bean&gt;
 * </pre></code>
 * 
 * @see jp.terasoluna.fw.validation.ValidationErrors
 * @see jp.terasoluna.fw.validation.springmodules.SpringValidationErrors
 *
 */
public class DefaultValidatorFactoryEx extends DefaultValidatorFactory {

    /**
     * ValidatorCX^Xɐݒ肷G[IuWFNg̃L[B
     */
    public static final String TERASOLUNA_ERRORS_KEY = 
        "jp.terasoluna.fw.validation.ValidationErrors";
    
    /**
     * ValidatorCX^X擾B
     * 
     * @param beanName ؂JavaBean̖OB
     * @param bean ؑΏۂJavaBeanB
     * @param errors Springt[[ÑG[B
     * @return ValidatorCX^XB
     */
    @Override
    public Validator getValidator(
            String beanName, Object bean, Errors errors) {
        Validator validator = 
            new CommonsValidatorEx(getValidatorResources(), beanName);
        
        // BindExceptionbvG[NXValidatorɐݒ肷
        SpringValidationErrors commonErrors = createSpringValidationErrors();
        commonErrors.setErrors(errors);
        validator.setParameter(TERASOLUNA_ERRORS_KEY, commonErrors);
        
        validator.setParameter(Validator.BEAN_PARAM, bean);
        return validator;
    }
    
    /**
     * ʓ͒l؃G[IuWFNg𐶐B
     * @return ʓ͒l؃G[IuWFNgB
     */
    protected SpringValidationErrors createSpringValidationErrors() {
        return new SpringValidationErrors();
    }
}
