/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.OutputFileColumn;
import jp.terasoluna.fw.file.annotation.StringConverter;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.FileLineException;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.standard.ColumnFormatter;
import jp.terasoluna.fw.file.dao.standard.FileDAOUtility;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileLineWriter<T>
implements FileLineWriter<T> {
    private static final int INITIAL_LINE_NO = -1;
    private Writer writer = null;
    private String fileName = null;
    private String fileEncoding = System.getProperty("file.encoding");
    private Class<T> clazz = null;
    private String lineFeedChar = System.getProperty("line.separator");
    private Field[] fields = null;
    private StringConverter[] stringConverters = null;
    private static Map<Class, StringConverter> stringConverterCacheMap = new HashMap<Class, StringConverter>();
    private Field[] fieldArray = null;
    private Method[] methods = null;
    private Map<String, ColumnFormatter> columnFormatterMap = null;
    private boolean writeData = false;
    private boolean writeTrailer = false;
    private int currentLineCount = 0;
    private boolean calledInit = false;

    public AbstractFileLineWriter(String fileName, Class<T> clazz, Map<String, ColumnFormatter> columnFormatterMap) {
        if (fileName == null || "".equals(fileName)) {
            throw new FileException("fileName is required.", new IllegalArgumentException(), fileName);
        }
        if (clazz == null) {
            throw new FileException("clazz is required.", new IllegalArgumentException(), fileName);
        }
        if (columnFormatterMap == null || columnFormatterMap.isEmpty()) {
            throw new FileException("columnFormatterMap is required.", new IllegalArgumentException(), fileName);
        }
        this.fileName = fileName;
        this.clazz = clazz;
        this.columnFormatterMap = columnFormatterMap;
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        if (fileFormat == null) {
            throw new FileException("FileFormat annotation is not found.", new IllegalStateException(), fileName);
        }
        if (fileFormat.delimiter() == fileFormat.encloseChar()) {
            throw new FileException("Delimiter is the same as EncloseChar and is no use.", new IllegalStateException(), fileName);
        }
        if (fileFormat.fileEncoding() != null && !"".equals(fileFormat.fileEncoding())) {
            this.fileEncoding = fileFormat.fileEncoding();
        }
        if (fileFormat.lineFeedChar() != null && !"".equals(fileFormat.lineFeedChar())) {
            this.lineFeedChar = fileFormat.lineFeedChar();
        }
        if (this.lineFeedChar.length() > 2) {
            throw new FileException("lineFeedChar length must be 1 or 2. but: " + this.lineFeedChar.length(), new IllegalStateException(), fileName);
        }
    }

    protected void init() {
        if (!this.calledInit) {
            FileFormat fileFormat = this.clazz.getAnnotation(FileFormat.class);
            this.buildFields();
            this.buildStringConverters();
            this.buildMethods();
            if (fileFormat.overWriteFlg()) {
                File file = new File(this.fileName);
                file.delete();
            }
            try {
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName, true), this.fileEncoding));
            }
            catch (UnsupportedEncodingException e) {
                throw new FileException("Failed in generation of writer.", e, this.fileName);
            }
            catch (FileNotFoundException e) {
                throw new FileException("Failed in generation of writer.", e, this.fileName);
            }
            this.calledInit = true;
        }
    }

    private void buildFields() {
        ArrayList<Field[]> fieldList = new ArrayList<Field[]>();
        Field[] declaredFieldArray = null;
        int allFieldCount = 0;
        for (Class<T> tempClass = this.clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            declaredFieldArray = tempClass.getDeclaredFields();
            fieldList.add(declaredFieldArray);
            allFieldCount += declaredFieldArray.length;
        }
        Field[] dataColumnFields = new Field[allFieldCount];
        OutputFileColumn outputFileColumn = null;
        int maxColumnIndex = -1;
        int columnIndex = -1;
        int columnCount = 0;
        Iterator i$ = fieldList.iterator();
        while (i$.hasNext()) {
            Field[] fields;
            for (Field field : fields = (Field[])i$.next()) {
                outputFileColumn = field.getAnnotation(OutputFileColumn.class);
                if (outputFileColumn == null) continue;
                if (this.columnFormatterMap.get(field.getType().getName()) == null) {
                    throw new FileException("There is a type which isn't supported in a mapping target field in FileLineObject.", new IllegalStateException(), this.fileName);
                }
                columnIndex = outputFileColumn.columnIndex();
                if (columnIndex < 0) {
                    throw new FileException("Column Index in FileLineObject is the minus number.", new IllegalStateException(), this.fileName);
                }
                if (dataColumnFields.length <= columnIndex) {
                    throw new FileException("Column Index in FileLineObject is bigger than the total number of the field.", new IllegalStateException(), this.fileName);
                }
                if (dataColumnFields[columnIndex] == null) {
                    dataColumnFields[columnIndex] = field;
                    if (maxColumnIndex < columnIndex) {
                        maxColumnIndex = columnIndex;
                    }
                    ++columnCount;
                    continue;
                }
                throw new FileException("Column Index is duplicate : " + columnIndex, this.fileName);
            }
        }
        if (columnCount != maxColumnIndex + 1) {
            throw new FileException("columnIndex in FileLineObject is not sequential order.", new IllegalStateException(), this.fileName);
        }
        this.fieldArray = dataColumnFields;
        if (dataColumnFields.length == columnCount) {
            this.fields = dataColumnFields;
        } else {
            this.fields = new Field[columnCount];
            System.arraycopy(dataColumnFields, 0, this.fields, 0, columnCount);
        }
    }

    private void buildStringConverters() {
        StringConverter[] dataColumnStringConverters = new StringConverter[this.fields.length];
        OutputFileColumn outputFileColumn = null;
        Class<? extends StringConverter> converterKind = null;
        for (int i = 0; i < this.fields.length; ++i) {
            outputFileColumn = this.fields[i].getAnnotation(OutputFileColumn.class);
            try {
                converterKind = outputFileColumn.stringConverter();
                if (stringConverterCacheMap.containsKey(converterKind)) {
                    dataColumnStringConverters[i] = stringConverterCacheMap.get(converterKind);
                    continue;
                }
                dataColumnStringConverters[i] = converterKind.newInstance();
                stringConverterCacheMap.put(converterKind, dataColumnStringConverters[i]);
                continue;
            }
            catch (InstantiationException e) {
                throw new FileLineException("Failed in an instantiate of a stringConverter.", e, this.fileName, -1, this.fields[i].getName(), outputFileColumn.columnIndex());
            }
            catch (IllegalAccessException e) {
                throw new FileLineException("Failed in an instantiate of a stringConverter.", e, this.fileName, -1, this.fields[i].getName(), outputFileColumn.columnIndex());
            }
        }
        this.stringConverters = dataColumnStringConverters;
    }

    private void buildMethods() {
        Method[] dataColumnGetMethods = new Method[this.fields.length];
        StringBuilder getterName = new StringBuilder();
        String fieldName = null;
        for (int i = 0; i < this.fields.length; ++i) {
            fieldName = this.fields[i].getName();
            getterName.setLength(0);
            getterName.append("get");
            getterName.append(StringUtils.upperCase((String)fieldName.substring(0, 1)));
            getterName.append(fieldName.substring(1, fieldName.length()));
            try {
                dataColumnGetMethods[i] = this.clazz.getMethod(getterName.toString(), new Class[0]);
                continue;
            }
            catch (NoSuchMethodException e) {
                throw new FileException("The getter method of column doesn't exist.", e, this.fileName);
            }
        }
        this.methods = dataColumnGetMethods;
    }

    @Override
    public void printHeaderLine(List<String> headerLine) {
        if (this.writeData || this.writeTrailer) {
            throw new FileException("Header part should be called before data part or trailer part.", new IllegalStateException(), this.fileName);
        }
        this.printList(headerLine);
    }

    @Override
    public void printDataLine(T t) {
        int i;
        this.checkWriteTrailer();
        StringBuilder fileLineBuilder = new StringBuilder();
        if (this.getDelimiter() == '\u0000' && this.getEncloseChar() == '\u0000') {
            for (i = 0; i < this.fields.length; ++i) {
                fileLineBuilder.append(this.getColumn(t, i));
            }
        } else {
            for (i = 0; i < this.fields.length; ++i) {
                if (this.getEncloseChar() != '\u0000') {
                    fileLineBuilder.append(this.getEncloseChar());
                    fileLineBuilder.append(this.getColumn(t, i));
                    fileLineBuilder.append(this.getEncloseChar());
                } else {
                    fileLineBuilder.append(this.getColumn(t, i));
                }
                fileLineBuilder.append(this.getDelimiter());
            }
            if (fileLineBuilder.length() > 0) {
                fileLineBuilder.deleteCharAt(fileLineBuilder.length() - 1);
            }
        }
        fileLineBuilder.append(this.getLineFeedChar());
        try {
            this.getWriter().write(fileLineBuilder.toString());
        }
        catch (IOException e) {
            throw new FileException("Processing of writer was failed.", e, this.fileName);
        }
        ++this.currentLineCount;
        this.setWriteData(true);
    }

    @Override
    public void printTrailerLine(List<String> trailerLine) {
        this.printList(trailerLine);
        this.writeTrailer = true;
    }

    private void printList(List<String> stringList) {
        for (String stringData : stringList) {
            try {
                this.writer.write(stringData);
                this.writer.write(this.lineFeedChar);
            }
            catch (IOException e) {
                throw new FileException("Processing of writer was failed.", e, this.fileName);
            }
        }
    }

    @Override
    public void closeFile() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new FileException("Closing of writer was failed.", e, this.fileName);
        }
    }

    protected String getColumn(T t, int index) {
        String columnString = null;
        OutputFileColumn outputFileColumn = this.fields[index].getAnnotation(OutputFileColumn.class);
        ColumnFormatter columnFormatter = this.columnFormatterMap.get(this.methods[index].getReturnType().getName());
        try {
            columnString = columnFormatter.format(t, this.methods[index], outputFileColumn.columnFormat());
        }
        catch (IllegalArgumentException e) {
            throw new FileLineException("Failed in column data formatting.", e, this.fileName, this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
        }
        catch (IllegalAccessException e) {
            throw new FileLineException("Failed in column data formatting.", e, this.fileName, this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
        }
        catch (InvocationTargetException e) {
            throw new FileLineException("Failed in column data formatting.", e, this.fileName, this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
        }
        if (columnString == null) {
            columnString = "";
        }
        columnString = FileDAOUtility.trim(columnString, this.fileEncoding, outputFileColumn.trimChar(), outputFileColumn.trimType());
        columnString = FileDAOUtility.padding(columnString, this.fileEncoding, outputFileColumn.bytes(), outputFileColumn.paddingChar(), outputFileColumn.paddingType());
        columnString = this.stringConverters[index].convert(columnString);
        if (this.isCheckByte(outputFileColumn)) {
            try {
                if (outputFileColumn.bytes() <= 0) {
                    throw new FileLineException("bytes is not set or a number equal to or less than 0 is set.", new IllegalStateException(), this.getFileName(), this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
                }
                if (columnString.getBytes(this.fileEncoding).length != outputFileColumn.bytes()) {
                    throw new FileLineException("The data size is different from bytes value of the set value of the column .", new IllegalStateException(), this.fileName, this.currentLineCount + 1, this.fields[index].getName(), outputFileColumn.columnIndex());
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new FileException("fileEncoding which isn't supported was set.", e, this.fileName);
            }
        }
        return columnString;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected String getLineFeedChar() {
        return this.lineFeedChar;
    }

    public void setColumnFormatterMap(Map<String, ColumnFormatter> columnFormatterMap) {
        this.columnFormatterMap = columnFormatterMap;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected Field[] getFields() {
        return this.fields;
    }

    protected Method[] getMethods() {
        return this.methods;
    }

    protected Field[] getFieldArray() {
        return this.fieldArray;
    }

    protected void setWriteData(boolean writeData) {
        this.writeData = writeData;
    }

    protected void checkWriteTrailer() {
        if (this.writeTrailer) {
            throw new FileException("Header part or data part should be called before TrailerPart", new IllegalStateException(), this.fileName);
        }
    }

    public abstract char getDelimiter();

    public abstract char getEncloseChar();

    protected boolean isCheckByte(OutputFileColumn outputFileColumn) {
        return 0 < outputFileColumn.bytes();
    }
}

