/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.commonj.init;

import jp.terasoluna.fw.batch.commonj.init.JobExecutor;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.JobStatusSummarizer;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.init.JobInfo;
import jp.terasoluna.fw.batch.openapi.JobContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class ChildJobExecutor
extends JobExecutor {
    private static final Log log = LogFactory.getLog(ChildJobExecutor.class);
    private JobContext jobContext = null;

    public JobStatus execute(JobInfo jobInfo, JobContext jobContext) {
        this.printStartLog(jobContext);
        ConfigurableApplicationContext jobFactory = this.getJobBeanFactory(jobInfo);
        Workable<WorkUnit> jobManager = this.getJobManager(jobFactory);
        this.jobStatus = this.getJobStatus(jobFactory, jobContext);
        this.initEndFileChecker(this.jobStatus, jobContext);
        WorkUnit rootWorkQueueElement = this.getWorkUnit(jobContext);
        jobManager.work(rootWorkQueueElement, this.jobStatus);
        ((JobStatusSummarizer)jobFactory.getBean("JobStatusSummarizer")).summarize(this.jobStatus);
        this.setDefaultJobExitCode(this.jobStatus);
        if (!((Boolean)jobFactory.getBean("useCache")).booleanValue()) {
            jobFactory.close();
        }
        this.printEndLog(this.jobStatus);
        return this.jobStatus;
    }

    public void run() {
        this.jobStatus = this.execute(this.getJobInfo(), this.jobContext);
    }

    protected JobStatus getJobStatus(ConfigurableApplicationContext jobFactory, JobContext jobContext) {
        JobStatus initJobStatus = null;
        initJobStatus = (Boolean)jobFactory.getBean("useMonitorable") != false ? (JobStatus)jobFactory.getBean("MonitorableJobStatus") : (JobStatus)jobFactory.getBean("JobStatus");
        initJobStatus.setJobRequestNo(jobContext.getJobRequestNo());
        initJobStatus.setJobId(jobContext.getJobId());
        initJobStatus.setJobState(JobStatus.STATE.STARTED);
        initJobStatus.setPartitionNo(jobContext.getPartitionNo());
        initJobStatus.setPartitionKey(jobContext.getPartitionKey());
        return initJobStatus;
    }

    protected void printStartLog(JobContext jobContext) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Child job processing START. : [jobId=");
            logStr.append(jobContext.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobContext.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobContext.getPartitionNo());
            logStr.append("] [StartType=");
            logStr.append((Object)(this.isAsync() ? JobContext.START_TYPE.ASYNC : JobContext.START_TYPE.SYNC));
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }

    protected void printEndLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Child job processing END. : [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [StartType=");
            logStr.append((Object)(this.isAsync() ? JobContext.START_TYPE.ASYNC : JobContext.START_TYPE.SYNC));
            logStr.append("] [jobExitCode=");
            logStr.append(jobStatus.getJobExitCode());
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }
}

