/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Map;

import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.dao.FileException;

/**
 * Œ蒷t@Cp̃t@CANZX(f[^擾)NXB
 * 
 * <p>
 * Œ蒷t@Cf[^ǂݍ݁A
 * 1s̃f[^t@CsIuWFNgɊi[B
 * </p>
 * 
 * <b>pt@CsIuWFNg̃Ame[V</b><br>
 * @D@{@link FileFormat}̐ݒ荀<br>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b>_ږ</b> </td>
 *    <td> <b>ږ</b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>s؂蕶</code> </td>
 *    <td> <code>lineFeedChar</code> </td>
 *    <td> <code>VXe̍s؂蕶</code> </td>
 *    <td> <code>IvV</code> </td>
 *   <tr>
 *   <tr>
 *    <td> <code>t@CGR[fBO</code> </td>
 *    <td> <code>fileEncodeing</code> </td>
 *    <td> <code>VXẽt@CGR[fBO</code> </td>
 *    <td> <code>IvV</code> </td>
 *   <tr>
 *   <tr>
 *    <td> <code>wb_s</code> </td>
 *    <td> <code>headerLineCount</code> </td>
 *    <td> <code>0</code> </td>
 *    <td> <code>IvV</code> </td>
 *   <tr>
 *   <tr>
 *    <td> <code>gCs</code> </td>
 *    <td> <code>trailerLineCount</code> </td>
 *    <td> <code>0</code> </td>
 *    <td> <code>IvV</code> </td>
 *   <tr>
 *  </table>
 * </div>
 * <br>
 * AD@{@link InputFileColumn}A@{@link jp.terasoluna.fw.file.annotation.OutputFileColumn}̐ݒ荀<br>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b>_ږ</b> </td>
 *    <td> <b>ږ</b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>JCfbNX</code> </td>
 *    <td> <code>columnIndex</code> </td>
 *    <td> - </td>
 *    <td> <code>K{</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>tH[}bg</code> </td>
 *    <td> <code>columnFormat</code> </td>
 *    <td> <code>""</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>oCg</code> </td>
 *    <td> <code>bytes</code> </td>
 *    <td> <code>-1</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>pfBO</code> </td>
 *    <td> <code>paddingType</code> </td>
 *    <td> <code>pfBOȂ</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>pfBO</code> </td>
 *    <td> <code>paddingChar</code> </td>
 *    <td> <code>' '</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>g</code> </td>
 *    <td> <code>trimType</code> </td>
 *    <td> <code>gȂ</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>g</code> </td>
 *    <td> <code>trimChar</code> </td>
 *    <td> <code>' '</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>ϊ</code> </td>
 *    <td> <code>stringConverter</code> </td>
 *    <td> <code>NullStringConverter.class</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *  </table>
 * </div>
 * <br>
 * <b>ӎ</b><br>
 * <ul>
 * @<li>؂蕶ݒ肷邱Ƃ͏oȂB(G[)</li>
 * @<li>͂ݕݒ肷邱Ƃ͏oȂB(G[)</li>
 * </ul>
 * 
 * 
 * @param <T>
 *            t@CsIuWFNgB
 */
public class FixedFileLineIterator<T> extends AbstractFileLineIterator<T> {

    /**
     * ؂蕶BŒ蒷t@Ću,(J})vŌŒB
     */
    private static final char DELIMITER = ',';

    /**
     * ͂ݕBŒ蒷t@Ću'\u0000'vŌŒB
     */
    private static final char ENCLOSE_CHAR = Character.MIN_VALUE;

    /**
     * <code>InputFileColumn</code>Œ`ꂽoCgB<br>
     * 1sɓf[^̑oCgłB
     */
    private int totalDefineBytes = 0;
    
    /**
     * RXgN^B
     * 
     * <p>؂蕶lȊȌꍇA
     * ͂ݕlȊȌꍇ<code>FileException</code>X[B
     * 
     * @param fileName
     *            t@C
     * @param clazz
     *            ʃNX
     * @param columnParserMap
     *            tH[}bgXg
     */
    public FixedFileLineIterator(String fileName, Class<T> clazz,
            Map<String, ColumnParser> columnParserMap) {

        super(fileName, clazz, columnParserMap);

        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);

        // ؂蕶lȊȌꍇAOX[B
        if (fileFormat.delimiter() != DELIMITER) {
            throw new FileException("Delimiter can not change.",
                    new IllegalStateException(), fileName);
        }

        // ͂ݕlȊȌꍇAOX[B
        if (fileFormat.encloseChar() != ENCLOSE_CHAR) {
            throw new FileException("EncloseChar can not change.",
                    new IllegalStateException(), fileName);
        }
        
        // sB
        super.init();

        // Ame[VŒ`ꂽoCg̎擾
        for (Field field : getFields()) {
            totalDefineBytes += 
                field.getAnnotation(InputFileColumn.class).bytes();
        }
    }

    /**
     * ǂݍ񂾌Œ蒷̃R[hAme[VbyteA
     * columnIndexɏ]ĕB<br>
     * <code>fileLineString</code><code>null</code>
     * 󕶎̏ꍇ́AvfȂ<code>String</code>zԂ܂B
     * 
     * <p>
     * ̏́A<br>
     * <ul>
     * <li>t@CsIuWFNgŒ`oCg̍vƃt@Cǂݎ1s̃oCgr</li>
     * <li>t@CsIuWFNg̃Ame[VŒ`bytes̕𐶐</li>
     * </ul>
     * <p>
     * 
     * @param fileLineString
     *            Œ蒷t@C1R[h̕
     * @return f[^Ps̕𕪉z
     */
    protected String[] separateColumns(String fileLineString) {

        // R[hnull󕶎̏ꍇ͗vfO̔zԋp
        if (fileLineString == null || "".equals(fileLineString)) {
            return new String[0];
        }

        Field[] fields = getFields();
        String[] results = new String[fields.length];
        
        // t@CsIuWFNgŒ`oCg̍vƃt@Cǂݎ1s̃oCgr
        try {
            // t@Cǂݎ1s̃oCgƁAt@CsIuWFNg
            // `oCg̍vrB
            byte[] bytes = fileLineString.getBytes(getFileEncoding());
            if (totalDefineBytes != bytes.length) {
                throw new FileException("Total Columns byte is different "
                        + "from Total FileLineObject's columns byte.",
                        new IllegalStateException(), this.getFileName());
            }
            
            //@t@CsIuWFNg̃Ame[VŒ`bytes̕𐶐
            int byteIndex = 0;
            int columnBytes = 0;
            
            for (int i = 0; i < fields.length; i++) {
                columnBytes = fields[i].getAnnotation(InputFileColumn.class)
                        .bytes();
                results[i] = new String(bytes, byteIndex, columnBytes, 
                        getFileEncoding());
                byteIndex += columnBytes;
            }
        } catch (UnsupportedEncodingException e) {
            throw new FileException(
                    "fileEncoding which isn't supported was set.",
                    e, this.getFileName());
        }

        return results;
    }

    /**
     * ΏۃJɑ΂oCg`FbNsԂB<br>
     * FixedFileLineIterator͌Œ蒷̂߁AsPʂŃoCg`FbNsB<br>
     * ̂߃Jɑ΂oCg`FbN͍sȂB
     * 
     * @param inputFileColumn ΏۃJInputFileColumn
     * @return false
     */
    @Override
    protected boolean isCheckByte(InputFileColumn inputFileColumn) {
        return false;
    }

    /**
     * ؂蕶擾B<br>
     * Œ蒷t@Ću,(J})vŌŒB
     * 
     * @return s؂蕶
     */
    @Override
    public char getDelimiter() {

        return DELIMITER;
    }

    /**
     * ͂ݕ擾B<br>
     * Œ蒷t@Ću'\u0000'vŌŒB
     * 
     * @return ͂ݕ
     */
    @Override
    public char getEncloseChar() {

        return ENCLOSE_CHAR;
    }
}
