/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.transaction;

import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.Workable;

/**
 * gUNVs[J[NXB
 * 
 * <p><code>jobWorker</code> ɐݒ肳ꂽ[J̌ĂяogUNV
 * sȂsB</p>
 * <p>Z[u|Cg𗘗pꍇɂ́A{NXŃZ[u|Cgg
 * gUNVsB<br>
 * Wu[J[̏ŗOIۂɁA
 * Wȕ󋵂ł΃R~bgsAȊȌꍇ̓[obN
 * sB<br>
 * [obNȌō쐬ꂽZ[u|Cg܂ōsꂽꍇ́A
 * ȑÕZ[u|Cg܂ł̏R~bgB
 * </p>
 * <p>܂AL[̏ɂėOɏIŁAWȕ󋵂
 * fIA͋Iłꍇɂ́A
 * 󋵂𒆒f/IɕύXB</p> 
 * <p>gUNVs߁AWuXe[^XƂ 
 * <code>TransactionalJobStatus</code>gpKvB</p>
 * 
 */
public class TransactionalWorker implements Workable<Chunk> {

    /**
     * Wu[J[B
     */
    private Workable<Chunk> jobWorker = null;
    
    /**
     * [J[̏sB
     * 
     * @param chunk `N
     * @param jobStatus gUNViWuXe[^X
     */
    public void work(Chunk chunk, JobStatus jobStatus) {
        
        TransactionalJobStatus transactionalJobStatus = 
            (TransactionalJobStatus) jobStatus;
        transactionalJobStatus.beginTransaction();
        
        // Z[u|CgLɍŏ̃Z[u|Cg쐬
        if (transactionalJobStatus.useSavepoint()) {
            transactionalJobStatus.releaseAndCreateSavepoint();
        }

        boolean commitFlag = false;
        try {
            jobWorker.work(chunk, transactionalJobStatus);
            commitFlag = true;
        } finally {
            if (commitFlag && jobStatus.isNormallyState()) {
                transactionalJobStatus.commit();
            } else {
                // [obN
                if (transactionalJobStatus.useSavepoint()) {
                    transactionalJobStatus.rollbackToSavepoint();
                    // Z[u|CgL͍ŌɃR~bg
                    transactionalJobStatus.commit();
                } else {
                    transactionalJobStatus.rollback();
                }
            }
        }

        // EfI
        if (jobStatus.isShutdownGraceful() || 
                jobStatus.isShutdownImmediate()) {
            jobStatus.suspend();
            return;
        }
    }

    /**
     * Wu[J[ݒ肷B
     * 
     * @param jobWorker Wu[J[
     */
    public void setJobWorker(Workable<Chunk> jobWorker) {
        this.jobWorker = jobWorker;
    }
}
