/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.core;

import java.util.LinkedHashMap;
import jp.terasoluna.fw.batch.core.Collector;
import jp.terasoluna.fw.batch.core.CollectorException;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.CollectorResultHandler;
import jp.terasoluna.fw.batch.core.ExceptionHandlerUtil;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.core.WorkQueueFactory;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobManager
implements Workable<WorkUnit> {
    private static final Log log = LogFactory.getLog(JobManager.class);
    private Collector<JobContext> collector = null;
    private CollectorResultHandler collectorResultHandler = null;
    private WorkQueueFactory workQueueFactory = null;
    private String name = null;
    private LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap = null;
    private JobExceptionHandler defaultJobExceptionHandler = null;
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();
    private SupportProcessor preProcessor = null;
    private SupportProcessor postProcessor = null;

    @Override
    public void work(WorkUnit workUnit, JobStatus jobStatus) {
        JobStatus childJobStatus = null;
        childJobStatus = jobStatus.getChild(workUnit.getJobContext());
        try {
            this.writeStartLog(childJobStatus);
            this.preProcessor.process(workUnit.getJobContext(), childJobStatus);
            if (!childJobStatus.isContinue()) {
                return;
            }
            WorkQueue managerQueue = this.workQueueFactory.getWorkQueue(childJobStatus);
            this.processCollect(workUnit.getJobContext(), managerQueue, childJobStatus);
            managerQueue.waitForAllWorkers();
            this.postProcessor.process(workUnit.getJobContext(), childJobStatus);
            this.finishWork(jobStatus, childJobStatus);
            this.writeEndLog(childJobStatus);
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(workUnit.getJobContext(), throwable, childJobStatus);
        }
    }

    protected void finishWork(JobStatus parentJobStatus, JobStatus jobStatus) {
        if (jobStatus.isExecuting()) {
            jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
        } else if (jobStatus.isShutdownGraceful() || jobStatus.isShutdownImmediate()) {
            jobStatus.suspend();
        }
    }

    private void processCollect(JobContext jobContext, WorkQueue workQueue, JobStatus jobStatus) {
        CollectorResult collectorResult = null;
        try {
            collectorResult = this.collector.collect(jobContext, workQueue, jobStatus);
            this.collectorResultHandler.handle(collectorResult, jobStatus);
        }
        catch (RuntimeException e) {
            CollectorException wrappingException = new CollectorException(e, collectorResult);
            JobExceptionHandler handler = ExceptionHandlerUtil.getJobExceptionHandler(wrappingException, this.exceptionHandlerMap, this.defaultJobExceptionHandler);
            try {
                handler.handlException(jobContext, wrappingException, jobStatus);
            }
            catch (RuntimeException handlerException) {
                log.error((Object)("[Exception in ExceptionHandler] Error JobID: " + jobStatus.getJobId()), (Throwable)handlerException);
                jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
            }
        }
    }

    public void setCollectorResultHandler(CollectorResultHandler collectorResultHandler) {
        this.collectorResultHandler = collectorResultHandler;
    }

    public void setWorkQueueFactory(WorkQueueFactory workQueueFactory) {
        this.workQueueFactory = workQueueFactory;
    }

    public void setCollector(Collector<JobContext> collector) {
        this.collector = collector;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPostProcessor(SupportProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public void setPreProcessor(SupportProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public void setExceptionHandlerMap(LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    public void setDefaultJobExceptionHandler(JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

    private void writeStartLog(JobStatus jobStatus) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Job processing START: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [partitionKey=");
            logStr.append(jobStatus.getPartitionKey());
            logStr.append("] [JobManagerName=");
            logStr.append(this.name);
            logStr.append("] [JobState=");
            logStr.append((Object)jobStatus.getJobState());
            logStr.append("]");
            log.info((Object)logStr.toString());
        }
    }

    private void writeEndLog(JobStatus jobStatus) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Job processing END: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [partitionKey=");
            logStr.append(jobStatus.getPartitionKey());
            logStr.append("] [JobManagerName=");
            logStr.append(this.name);
            logStr.append("] [JobState=");
            logStr.append((Object)jobStatus.getJobState());
            logStr.append("]");
            log.info((Object)logStr.toString());
        }
    }
}

