/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.commonj.listener;

import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.terasoluna.fw.batch.commonj.listener.WorkMapListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkQueueListener
implements WorkMapListener {
    private static final Log log = LogFactory.getLog(WorkQueueListener.class);
    private Map<WorkItem, Work> map = Collections.synchronizedMap(new HashMap());

    public void addWork(WorkItem workItem, Work work) {
        this.map.put(workItem, work);
    }

    public Work getWork(WorkItem workItem) {
        return this.map.get(workItem);
    }

    public Work removeWork(WorkItem workItem) {
        return this.map.remove(workItem);
    }

    public void workAccepted(WorkEvent we) {
        this.printSimpleLog("Work accepted: ", this.getWork(we.getWorkItem()));
    }

    public void workCompleted(WorkEvent we) {
        this.printSimpleLog("Work completed: ", this.removeWork(we.getWorkItem()));
    }

    public void workRejected(WorkEvent we) {
        this.printSimpleLog("Work rejected: ", this.removeWork(we.getWorkItem()));
    }

    public void workStarted(WorkEvent we) {
        this.printSimpleLog("Work started: ", this.getWork(we.getWorkItem()));
    }

    private void printSimpleLog(String message, Object object) {
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(message);
            builder.append("[");
            builder.append(object);
            builder.append("]");
            log.debug((Object)builder.toString());
        }
    }
}

