/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.joda.time.ReadableInstant;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.condition.bean.EqualPropertiesBeanCondition;
import org.springmodules.validation.util.condition.bean.PropertyBeanCondition;
import org.springmodules.validation.util.condition.collection.IsEmptyCollectionCondition;
import org.springmodules.validation.util.condition.collection.MaxSizeCollectionCondition;
import org.springmodules.validation.util.condition.collection.MinSizeCollectionCondition;
import org.springmodules.validation.util.condition.collection.SizeRangeCollectionCondition;
import org.springmodules.validation.util.condition.common.AndCondition;
import org.springmodules.validation.util.condition.common.InstanceOfCondition;
import org.springmodules.validation.util.condition.common.IsNullCondition;
import org.springmodules.validation.util.condition.common.IsTrueCondition;
import org.springmodules.validation.util.condition.common.NotCondition;
import org.springmodules.validation.util.condition.common.OrCondition;
import org.springmodules.validation.util.condition.date.IsAfterDateCondition;
import org.springmodules.validation.util.condition.date.IsBeforeDateCondition;
import org.springmodules.validation.util.condition.date.IsInTheFutureDateCondition;
import org.springmodules.validation.util.condition.date.IsInThePastDateCondition;
import org.springmodules.validation.util.condition.date.jodatime.IsAfterInstantCondition;
import org.springmodules.validation.util.condition.date.jodatime.IsBeforeInstantCondition;
import org.springmodules.validation.util.condition.date.jodatime.IsInTheFutureInstantCondition;
import org.springmodules.validation.util.condition.date.jodatime.IsInThePastInstantCondition;
import org.springmodules.validation.util.condition.range.BetweenCondition;
import org.springmodules.validation.util.condition.range.BetweenIncludingCondition;
import org.springmodules.validation.util.condition.range.BetweenIncludingLowerBoundCondition;
import org.springmodules.validation.util.condition.range.BetweenIncludingUpperBoundCondition;
import org.springmodules.validation.util.condition.range.GreaterThanCondition;
import org.springmodules.validation.util.condition.range.GreaterThanOrEqualsCondition;
import org.springmodules.validation.util.condition.range.LessThanCondition;
import org.springmodules.validation.util.condition.range.LessThanOrEqualsCondition;
import org.springmodules.validation.util.condition.string.ContainsSubstringStringCondition;
import org.springmodules.validation.util.condition.string.EqualsIgnoreCaseStringCondition;
import org.springmodules.validation.util.condition.string.IsEmptyStringCondition;
import org.springmodules.validation.util.condition.string.MaxLengthStringCondition;
import org.springmodules.validation.util.condition.string.MinLengthStringCondition;
import org.springmodules.validation.util.condition.string.RegExpStringCondition;

public final class Conditions {
    private Conditions() {
    }

    public static Condition not(Condition condition) {
        return new NotCondition(condition);
    }

    public static Condition and(Condition c1, Condition c2) {
        return Conditions.and(new Condition[]{c1, c2});
    }

    public static Condition and(Condition[] conditions) {
        return new AndCondition(conditions);
    }

    public static Condition and(Collection conditions) {
        return new AndCondition(conditions);
    }

    public static Condition or(Condition c1, Condition c2) {
        return Conditions.or(new Condition[]{c1, c2});
    }

    public static Condition or(Condition[] conditions) {
        return new OrCondition(conditions);
    }

    public static Condition or(Collection conditions) {
        return new OrCondition(conditions);
    }

    public static Condition isTrue() {
        return new IsTrueCondition();
    }

    public static Condition isFalse() {
        return Conditions.not(Conditions.isTrue());
    }

    public static Condition instanceOf(Class clazz) {
        return new InstanceOfCondition(clazz);
    }

    public static Condition isNull() {
        return new IsNullCondition();
    }

    public static Condition notNull() {
        return Conditions.not(Conditions.isNull());
    }

    public static Condition propertiesMatch(String[] propertyNames) {
        return new EqualPropertiesBeanCondition(propertyNames);
    }

    public static Condition isDateInTheFuture() {
        return new IsInTheFutureDateCondition();
    }

    public static Condition isDateInThePast() {
        return new IsInThePastDateCondition();
    }

    public static Condition isInstantInTheFuture() {
        return new IsInTheFutureInstantCondition();
    }

    public static Condition isInstantInThePast() {
        return new IsInThePastInstantCondition();
    }

    public static Condition isBefore(Date date) {
        return new IsBeforeDateCondition(date);
    }

    public static Condition isBefore(ReadableInstant instant) {
        return new IsBeforeInstantCondition(instant);
    }

    public static Condition isBefore(Calendar calendar) {
        return new IsBeforeDateCondition(calendar);
    }

    public static Condition isAfter(Date date) {
        return new IsAfterDateCondition(date);
    }

    public static Condition isAfter(ReadableInstant instant) {
        return new IsAfterInstantCondition(instant);
    }

    public static Condition isAfter(Calendar calendar) {
        return new IsAfterDateCondition(calendar);
    }

    public static Condition contains(String text) {
        return new ContainsSubstringStringCondition(text);
    }

    public static Condition equalsIgnoreCase(String text) {
        return new EqualsIgnoreCaseStringCondition(text);
    }

    public static Condition isEmptyString() {
        return new IsEmptyStringCondition();
    }

    public static Condition notBlank() {
        return Conditions.not(Conditions.isEmptyString());
    }

    public static Condition regexp(String regexp) {
        return new RegExpStringCondition(regexp);
    }

    public static Condition minLength(int minLength) {
        return new MinLengthStringCondition(minLength);
    }

    public static Condition maxLength(int maxLength) {
        return new MaxLengthStringCondition(maxLength);
    }

    public static Condition lengthBetween(int minLength, int maxLength) {
        return Conditions.minLength(minLength).and(Conditions.maxLength(maxLength));
    }

    public static Condition isEmpty() {
        return new IsEmptyCollectionCondition();
    }

    public static Condition notEmpty() {
        return Conditions.not(Conditions.isEmpty());
    }

    public static Condition minSize(int minSize) {
        return new MinSizeCollectionCondition(minSize);
    }

    public static Condition minSize(String propertyName, int minSize) {
        return Conditions.property(propertyName, Conditions.minSize(minSize));
    }

    public static Condition maxSize(int maxSize) {
        return new MaxSizeCollectionCondition(maxSize);
    }

    public static Condition maxSize(String propertyName, int maxSize) {
        return Conditions.property(propertyName, Conditions.maxSize(maxSize));
    }

    public static Condition sizeRange(int minSize, int maxSize) {
        return new SizeRangeCollectionCondition(minSize, maxSize);
    }

    public static Condition sizeRange(String propertyName, int minSize, int maxSize) {
        return Conditions.property(propertyName, Conditions.sizeRange(minSize, maxSize));
    }

    public static Condition isGt(Comparable min) {
        return new GreaterThanCondition(min);
    }

    public static Condition isGt(String propertyName, Comparable min) {
        return Conditions.property(propertyName, Conditions.isGt(min));
    }

    public static Condition isGte(Comparable min) {
        return new GreaterThanOrEqualsCondition(min);
    }

    public static Condition isGte(String propertyName, Comparable min) {
        return Conditions.property(propertyName, Conditions.isGte(min));
    }

    public static Condition isLt(Comparable max) {
        return new LessThanCondition(max);
    }

    public static Condition isLte(Comparable max) {
        return new LessThanOrEqualsCondition(max);
    }

    public static Condition isLte(String propertyName, Comparable max) {
        return Conditions.property(propertyName, Conditions.isLte(max));
    }

    public static Condition isBetween(Comparable min, Comparable max) {
        return new BetweenCondition(min, max);
    }

    public static Condition isBetweenIncluding(Comparable min, Comparable max) {
        return new BetweenIncludingCondition(min, max);
    }

    public static Condition isBetweenIncludingMin(Comparable min, Comparable max) {
        return new BetweenIncludingLowerBoundCondition(min, max);
    }

    public static Condition isBetweenIncludingMax(Comparable min, Comparable max) {
        return new BetweenIncludingUpperBoundCondition(min, max);
    }

    public static Condition property(String propertyName, Condition condition) {
        return new PropertyBeanCondition(propertyName, condition);
    }

    public static Condition isTrue(String propertyName) {
        return Conditions.property(propertyName, Conditions.isTrue());
    }

    public static Condition isFalse(String propertyName) {
        return Conditions.not(Conditions.isTrue(propertyName));
    }

    public static Condition isNull(String propertyName) {
        return Conditions.property(propertyName, Conditions.isNull());
    }

    public static Condition notNull(String propertyName) {
        return Conditions.not(Conditions.isNull(propertyName));
    }

    public static Condition instanceOf(String propertyName, Class clazz) {
        return Conditions.property(propertyName, Conditions.instanceOf(clazz));
    }

    public static Condition isEmptyString(String propertyName) {
        return Conditions.property(propertyName, Conditions.isEmptyString());
    }

    public static Condition notEmptyString(String propertyName) {
        return Conditions.not(Conditions.isEmptyString(propertyName));
    }

    public static Condition maxLength(String propertyName, int maxLength) {
        return Conditions.property(propertyName, Conditions.maxLength(maxLength));
    }

    public static Condition minLength(String propertyName, int minLength) {
        return Conditions.property(propertyName, Conditions.minLength(minLength));
    }

    public static Condition isEmpty(String propertyName) {
        return Conditions.property(propertyName, Conditions.isEmpty());
    }

    public static Condition notEmpty(String propertyName) {
        return Conditions.not(Conditions.isEmpty(propertyName));
    }

    public static Condition isBetween(String propertyName, Comparable min, Comparable max) {
        return Conditions.property(propertyName, Conditions.isBetween(min, max));
    }

    public static Condition notInBetween(String propertyName, Comparable min, Comparable max) {
        return Conditions.not(Conditions.isBetween(propertyName, min, max));
    }
}

