/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import jp.terasoluna.fw.batch.core.BLogicResultHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.messages.BLogicMessage;
import jp.terasoluna.fw.batch.messages.BLogicMessages;
import jp.terasoluna.fw.batch.messages.MessageAccessor;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardBLogicResultHandler
implements BLogicResultHandler {
    private static Log log = LogFactory.getLog(StandardBLogicResultHandler.class);
    private MessageAccessor messageAccessor = null;
    private LOG_TYPE bLogicMessagesLogLevel = LOG_TYPE.INFO;
    private LOG_TYPE bLogicErroresLogLevel = LOG_TYPE.ERROR;

    @Override
    public void handle(BLogicResult blogicResult, Object blogicInputData, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        jobStatus.countBLogic(blogicResult.getReturnCode());
        this.processBLogicMessages(blogicResult);
        switch (blogicResult.getReturnCode()) {
            case NORMAL_CONTINUE: {
                this.processNormalContinue(jobStatus, blogicResult, batchUpdateMapList);
                break;
            }
            case NORMAL_END: {
                this.processNormalEnd(jobStatus, blogicResult, batchUpdateMapList);
                break;
            }
            case ERROR_CONTINUE: {
                this.processErrorContinue(blogicInputData, jobStatus, blogicResult);
                break;
            }
            case ERROR_END: {
                this.processErrorEnd(blogicInputData, jobStatus, blogicResult);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)blogicResult.getReturnCode()) + " illegal ReturnCode");
            }
        }
    }

    protected void processBLogicMessages(BLogicResult blogicResult) {
        this.writeBLogicMessagesLog(blogicResult.getMessages(), this.bLogicMessagesLogLevel);
        this.writeBLogicMessagesLog(blogicResult.getErrors(), this.bLogicErroresLogLevel);
    }

    protected void processNormalContinue(JobStatus jobStatus, BLogicResult bLogicResult, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        if (bLogicResult.getBatchUpdateMap() != null && bLogicResult.getBatchUpdateMap().size() > 0) {
            batchUpdateMapList.add(bLogicResult.getBatchUpdateMap());
        }
    }

    protected void processNormalEnd(JobStatus jobStatus, BLogicResult bLogicResult, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        if (bLogicResult.getBatchUpdateMap() != null && bLogicResult.getBatchUpdateMap().size() > 0) {
            batchUpdateMapList.add(bLogicResult.getBatchUpdateMap());
        }
        jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
        jobStatus.setJobExitCode(bLogicResult.getJobExitCode());
    }

    protected void processErrorContinue(Object blogicInputData, JobStatus jobStatus, BLogicResult bLogicResult) {
        this.writeWarnLog("Business logic result code is ERROR_CONTINUE", jobStatus, bLogicResult, blogicInputData);
    }

    protected void processErrorEnd(Object blogicInputData, JobStatus jobStatus, BLogicResult bLogicResult) {
        this.writeErrorLog("Business logic result code is ERROR_END", jobStatus, bLogicResult, blogicInputData);
        jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
        jobStatus.setJobExitCode(bLogicResult.getJobExitCode());
    }

    protected void writeErrorLog(String message, JobStatus jobStatus, BLogicResult bLogicResult, Object blogicInputData) {
        StringBuilder logStr = new StringBuilder(message);
        logStr.append(" : [jobId=");
        logStr.append(jobStatus.getJobId());
        logStr.append("] [jobRequestNo=");
        logStr.append(jobStatus.getJobRequestNo());
        logStr.append("] [partitionNo=");
        logStr.append(jobStatus.getPartitionNo());
        logStr.append("] [InputData: ");
        logStr.append(blogicInputData);
        logStr.append("]");
        log.error((Object)logStr.toString());
    }

    protected void writeWarnLog(String message, JobStatus jobStatus, BLogicResult bLogicResult, Object blogicInputData) {
        StringBuilder logStr = new StringBuilder(message);
        logStr.append(" : [jobId=");
        logStr.append(jobStatus.getJobId());
        logStr.append("] [jobRequestNo=");
        logStr.append(jobStatus.getJobRequestNo());
        logStr.append("] [partitionNo=");
        logStr.append(jobStatus.getPartitionNo());
        logStr.append("] [InputData: ");
        logStr.append(blogicInputData);
        logStr.append("]");
        log.warn((Object)logStr.toString());
    }

    protected void writeBLogicMessagesLog(BLogicMessages blogicMessages, LOG_TYPE logType) {
        if (blogicMessages == null || blogicMessages.isEmpty()) {
            return;
        }
        Iterator<BLogicMessage> itr = blogicMessages.get();
        while (itr.hasNext()) {
            BLogicMessage blogicMessage = itr.next();
            if (blogicMessage.isResource()) {
                this.writeLog(this.messageAccessor.getMessage(blogicMessage.getKey(), blogicMessage.getValues()), logType);
                continue;
            }
            this.writeLog(blogicMessage.getKey(), logType);
        }
    }

    protected void writeLog(String message, LOG_TYPE logType) {
        switch (logType) {
            case TRACE: {
                if (!log.isFatalEnabled()) break;
                log.trace((Object)message);
                break;
            }
            case DEBUG: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)message);
                break;
            }
            case INFO: {
                if (!log.isInfoEnabled()) break;
                log.info((Object)message);
                break;
            }
            case WARN: {
                log.warn((Object)message);
                break;
            }
            case ERROR: {
                log.error((Object)message);
                break;
            }
            case FATAL: {
                log.fatal((Object)message);
                break;
            }
            default: {
                throw new IllegalArgumentException("No log Type which agrees.");
            }
        }
    }

    public void setMessageAccessor(MessageAccessor messageAccessor) {
        this.messageAccessor = messageAccessor;
    }

    public void setBLogicErroresLogLevel(String logLevel) {
        this.bLogicErroresLogLevel = LOG_TYPE.valueOf(logLevel);
    }

    public void setBLogicMessagesLogLevel(String logLevel) {
        this.bLogicMessagesLogLevel = LOG_TYPE.valueOf(logLevel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum LOG_TYPE {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

