/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.commonj.init;

import commonj.work.Work;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.init.JobInfo;
import jp.terasoluna.fw.batch.init.JobRequestInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JobExecutor
extends jp.terasoluna.fw.batch.springsupport.init.JobExecutor
implements Work {
    private static Log log = LogFactory.getLog(JobExecutor.class);
    private static final String COMMONJ_DEFINITION_NAME = "/common/WorkManagerTaskContext-batch.xml";
    private JobRequestInfo jobInfo = null;
    protected JobStatus jobStatus = null;

    protected JobExecutor() {
    }

    protected JobExecutor(String[] beanFileName) {
        super(beanFileName);
    }

    protected JobStatus execute(JobInfo jobInfo) {
        return super.execute(jobInfo);
    }

    protected synchronized ConfigurableApplicationContext getJobBeanFactory(JobInfo jobInfo) {
        Object jobFactory = null;
        jobFactory = this.isAsync() ? super.getJobBeanFactory(jobInfo) : new ClassPathXmlApplicationContext(new String[]{jobInfo.getJobDiscriptorPath(), "/common/dataAccessContext-batch.xml", COMMONJ_DEFINITION_NAME, "/common/ValidationContext-batch.xml"}, (ApplicationContext)this.getFrameworkFactory());
        return jobFactory;
    }

    public JobRequestInfo getJobInfo() {
        return this.jobInfo;
    }

    public void setJobInfo(JobRequestInfo jobInfo) {
        this.jobInfo = jobInfo;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public boolean isDaemon() {
        return false;
    }

    public void release() {
    }

    public void run() {
        try {
            this.jobStatus = this.execute(this.jobInfo);
        }
        catch (Exception e) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("A job has ended abnormally by an exception. : [jobId=");
            logStr.append(this.jobInfo.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(this.jobInfo.getJobRequestNo());
            logStr.append("]");
            log.error((Object)logStr.toString(), (Throwable)e);
        }
        catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! ");
            logStr.append("A job has ended abnormally by an throwable. : [jobId=");
            logStr.append(this.jobInfo.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(this.jobInfo.getJobRequestNo());
            logStr.append("]");
            log.error((Object)logStr.toString(), throwable);
        }
    }
}

