/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/**
 * RequestDispatcher ̃bNAbvNXB
 * <BR><BR>
 * ɁATERASOLUNA t[[N̊g̒P̃eXgp̃NXŁA
 * ƖAvP[ṼeXgŕKvɂȂ邱Ƃ͂قƂǂȂƎvB
 * 
 */
public class MockRequestDispatcher implements RequestDispatcher {

    /**
     * NGXgAMockRequestDispatcherKx[W
     * eXgP[XŔrł悤Astaticɂďێ
     */
    private static ServletRequest request = null;

    /**
     * X|XAMockRequestDispatcherKx[W
     * eXgP[XŔrł悤Astaticɂďێ
     */
    private static ServletResponse response = null;

    /**
     * pXAMockRequestDispatcherKx[W
     * eXgP[XŔrł悤Astaticɂďێ
     */
    private static String path = null;

    /**
     * RXgN^
     *
     * @param path Jڐ
     */
    public MockRequestDispatcher(String path) {
        MockRequestDispatcher.path = path;
    }

    /**
     * @see javax.servlet.RequestDispatcher#forward(ServletRequest, 
     * ServletResponse)
     */
    public void forward(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        MockRequestDispatcher.request = request;
        MockRequestDispatcher.response = response;
    }

    /**
     * @see javax.servlet.RequestDispatcher#forward(ServletRequest, 
     * ServletResponse)
     */
    public void include(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        MockRequestDispatcher.request = request;
        MockRequestDispatcher.response = response;
    }

    /**
     * assertEqualsŔrׁAstaticƂĕێĂ
     * JڐԋpB
     * 
     * @return Jڐ
     */
    public String getPath() {
        return path;
    }

    /**
     * assertEqualsŔrׁAstaticƂĕێĂ
     * ServletRequestԋpB
     * 
     * @return T[ubgNGXg
     */
    public ServletRequest getServletRequest() {
        return request;
    }

    /**
     * assertEqualsŔrׁAstaticƂĕێĂ
     * ServletResponseԋpB
     * 
     * @return T[ubgX|X
     */
    public ServletResponse getServletResponse() {
        return response;
    }

}
