/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportLogicResultHandler;
import jp.terasoluna.fw.batch.openapi.BLogicResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <code>SupportLogicResultHandler</code> C^tF[X̕WNXB
 * 
 * <p>̃NXł́AT|[gWbNʂ <code>NORMAL_END</code>A
 * <code>ERROR_END</code>łƂɁAWuXe[^XXVB</p>
 * 
 */
public class StandardSupportLogicResultHandler 
    implements SupportLogicResultHandler {

    /**
     * OCX^XB
     */
    private static Log log = 
        LogFactory.getLog(StandardSupportLogicResultHandler.class);

    /**
     * T|[g̎sʂB
     * 
     * @param blogicResult T|[g̎s
     * @param jobStatus WuXe[^X
     * @param name T|[gNXɐݒ肳ꂽO
     */
    public void handle(BLogicResult blogicResult, JobStatus jobStatus,
            String name) {
        switch (blogicResult.getReturnCode()) {
            case NORMAL_CONTINUE:
                processNormalContinue(jobStatus, blogicResult, name);
                break;
            case NORMAL_END:
                processNormalEnd(jobStatus, blogicResult, name);
                break;
            case ERROR_CONTINUE:
                processErrorContinue(jobStatus, blogicResult, name);
                break;
            case ERROR_END:
                processErrorEnd(jobStatus, blogicResult, name);
                break;
            default:
                throw new IllegalArgumentException(blogicResult.getReturnCode()
                        + " illegal ReturnCode");
            
        }
    }

    /**
     * <code>BLogicResult</code> ̃^[R[h <code>NORMAL_CONTINUE</code>
     *  łƂ̏sB
     * 
     * @param jobStatus WuXe[^X
     * @param bLogicResult rWlXWbN
     * @param name T|[gNXɐݒ肳ꂽO
     */
    protected void processNormalContinue(JobStatus jobStatus,
            BLogicResult bLogicResult, String name) {
    }

    /**
     * <code>BLogicResult</code> ̃^[R[h <code>NORMAL_END</code> 
     * Ƃ̏sB
     * 
     * <p><code>JobStatus</code>̃WuԂ
     * <code>JobStatus.STATE.ENDING_NORMALLY</code> ɍXVA
     * <code>BLogicResult</code>
     * ̃WuIR[h <code>JobStatus</code> ɔfB</p>
     *
     * @param jobStatus WuXe[^X
     * @param bLogicResult rWlXWbN
     * @param name T|[gNXɐݒ肳ꂽO
     */
    protected void processNormalEnd(JobStatus jobStatus,
            BLogicResult bLogicResult, String name) {
        jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
        jobStatus.setJobExitCode(bLogicResult.getJobExitCode());
    }

    /**
     * <code>BLogicResult</code> ̃^[R[h <code>ERROR_CONTINUE</code>
     *  łƂ̏sB
     *
     * <p>xOo͂B</p>
     * 
     * @param jobStatus WuXe[^X
     * @param bLogicResult T|[g̎s
     * @param name T|[gNXɐݒ肳ꂽO
     */
    protected void processErrorContinue(JobStatus jobStatus, 
            BLogicResult bLogicResult, String name) {
        writeWarnLog(jobStatus, bLogicResult, name);
    }

    /**
     * <code>BLogicResult</code> ̃^[R[h <code>ERROR_END</code> 
     * Ƃ̏sB
     *
     * <p>G[Oo͂B</p>
     * 
     * <p><code>JobStatus</code>̃WuԂ
     * <code>JobStatus.STATE.ENDING_ABNORMALLY</code> ɍXVA
     * <code>BLogicResult</code>
     * ̃WuIR[h <code>JobStatus</code> ɔfB</p>
     *
     * @param jobStatus WuXe[^X
     * @param bLogicResult rWlXWbN
     * @param name T|[gNXɐݒ肳ꂽO
     */
    protected void processErrorEnd(JobStatus jobStatus, 
            BLogicResult bLogicResult, String name) {
        writeErrorLog(jobStatus, bLogicResult, name);
        jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
        jobStatus.setJobExitCode(bLogicResult.getJobExitCode());
    }

    /**
     * T|[gWbN̏ʂ̃G[Oo͂B
     * 
     * @param jobStatus WuXe[^X
     * @param result T|[gWbN̏
     * @param name T|[gNXɐݒ肳ꂽO
     */
    protected void writeErrorLog(JobStatus jobStatus, BLogicResult result,
            String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("Support logic result code is ERROR_END : [jobId=");
        builder.append(jobStatus.getJobId());
        builder.append("][SupportLogicName=");
        builder.append(name);
        builder.append("][SupportLogicResult=");
        builder.append(result.toString());
        builder.append("]");
        log.error(builder.toString());
    }

    /**
     * T|[gWbN̏ʂ̌xOo͂B
     * 
     * @param jobStatus WuXe[^X
     * @param result T|[gWbN̏
     * @param name T|[gNXɐݒ肳ꂽO
     */
    protected void writeWarnLog(JobStatus jobStatus, BLogicResult result,
            String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("Support logic result code is ERROR_CONTINUE : [jobId=");
        builder.append(jobStatus.getJobId());
        builder.append("][SupportLogicName=");
        builder.append(name);
        builder.append("][SupportLogicResult=");
        builder.append(result.toString());
        builder.append("]");
        log.warn(builder.toString());
    }
}
