/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.commonj.init;

import jp.terasoluna.fw.batch.commonj.listener.WorkMapListener;
import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.init.JobRequestInfo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import commonj.work.WorkItem;
import commonj.work.WorkManager;

/**
 * CommonJpWuNNXB
 * 
 * 
 */
public class JobStarterImpl implements JobStarter {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(JobStarterImpl.class);

    /**
     * [N}l[Wւ̍ƈ˗B
     */
    private static final int SCHDULE_SUCCESS = 0;
    
    /**
     * [N}l[Wւ̍ƈ˗sB
     */
    private static final int SCHDULE_ERROR = -1;
 
    /**
     * [N}l[W[B
     */
    private WorkManager workManager = null;

    /**
     * [NXi[B
     */
    private WorkMapListener workListener = null;

    /**
     * Wu̎sB
     * @param jobId Wuhc
     * @param beanFileName WuBean`t@C
     * @param args Wup[^
     * @return s
     */
    public int execute(String jobId, String beanFileName, String[] args) {
        if (workManager == null) {
            throw new InitializeException("WorkManager is required.");
        }
        if (workListener == null) {
            throw new InitializeException("WorkListener is required.");
        }
        
        try {
            // P̔zɂ܂Ƃ߂
            String[] newArgs = new String[args.length + 2];
            newArgs[0] = jobId;
            newArgs[1] = beanFileName;
            System.arraycopy(args, 0, newArgs, 2, args.length);

            JobRequestInfo jobInfo = new JobRequestInfo(newArgs);
            jobInfo.init();
            JobExecutor jobExecutor = new JobExecutor();
            jobExecutor.setJobInfo(jobInfo);
            WorkItem workItem = workManager.schedule(jobExecutor, workListener);
            workListener.addWork(workItem, jobExecutor);
        } catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! JobID: ");
            logStr.append(jobId);
            logStr.append(" ");
            logStr.append(throwable.getMessage());
            log.error(logStr.toString(), throwable);
            return SCHDULE_ERROR;
        }
        return SCHDULE_SUCCESS;
    }

    /**
     * [NXi[̐ݒB
     * 
     * @param workListener [NXi[
     */
    public void setWorkListener(WorkMapListener workListener) {
        this.workListener = workListener;
    }

    /**
     * [N}l[W[̐ݒB
     * 
     * @param workManager [N}l[W[
     */
    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

}
