/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.openapi.JobContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardWorkQueue
implements WorkQueue {
    private int queueCheckTimeout = 10000;
    private BlockingQueue<WorkUnit> queue;
    private JobStatus jobStatus;
    private List<Future<?>> futureResultList = new ArrayList();
    public static final WorkUnit END_MARK = new WorkUnit(){

        public boolean isEndMark() {
            return true;
        }

        public JobContext getJobContext() {
            throw new UnsupportedOperationException();
        }

        public void setJobContext(JobContext jobContext) {
            throw new UnsupportedOperationException();
        }
    };

    public StandardWorkQueue(int queueLength, JobStatus jobStatus) {
        this.queue = new ArrayBlockingQueue<WorkUnit>(queueLength);
        this.jobStatus = jobStatus;
    }

    @Override
    public void put(WorkUnit element) {
        try {
            while (!this.queue.offer(element, this.queueCheckTimeout, TimeUnit.MILLISECONDS)) {
                this.checkJobStatus();
            }
        }
        catch (InterruptedException e) {
            throw new QueueingException(e);
        }
    }

    private void checkJobStatus() {
        if (this.jobStatus.isShutdownGraceful() || this.jobStatus.isShutdownImmediate()) {
            this.jobStatus.suspend();
            throw new QueueingException();
        }
        if (!this.jobStatus.isExecuting()) {
            throw new QueueingException();
        }
    }

    @Override
    public void close() {
        this.put(END_MARK);
    }

    @Override
    public WorkUnit take() {
        try {
            while (true) {
                WorkUnit workUnit;
                if ((workUnit = this.queue.poll(this.queueCheckTimeout, TimeUnit.MILLISECONDS)) == END_MARK) {
                    this.put(END_MARK);
                    return END_MARK;
                }
                if (workUnit != null) {
                    return workUnit;
                }
                this.checkJobStatus();
            }
        }
        catch (InterruptedException e) {
            throw new QueueingException(e);
        }
    }

    @Override
    public void waitForAllWorkers() {
        for (Future<?> futureResult : this.futureResultList) {
            try {
                futureResult.get();
            }
            catch (ExecutionException e) {
                throw new JobException(e);
            }
            catch (InterruptedException e) {
                throw new JobException(e);
            }
        }
    }

    public void addFutureJobResult(Future<?> futureResult) {
        this.futureResultList.add(futureResult);
    }

    public void setQueueCheckTimeout(int timeout) {
        this.queueCheckTimeout = timeout;
    }
}

